/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdUtils;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RDFDatasetUtils;
import com.github.jsonldjava.core.UniqueNamer;
import com.github.jsonldjava.utils.Obj;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class NormalizeUtils {
    private final UniqueNamer namer;
    private final Map<String, Object> bnodes;
    private final List<Object> quads;
    private final JsonLdOptions options;

    public NormalizeUtils(List<Object> quads, Map<String, Object> bnodes, UniqueNamer namer, JsonLdOptions options) {
        this.options = options;
        this.quads = quads;
        this.bnodes = bnodes;
        this.namer = namer;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Object hashBlankNodes(Collection<String> unnamed_) throws JsonLdError {
        ArrayList hashes;
        ArrayList<String> arrayList = new ArrayList<String>(unnamed_);
        ArrayList<String> nextUnnamed = new ArrayList<String>();
        LinkedHashMap duplicates = new LinkedHashMap();
        LinkedHashMap<String, String> unique = new LinkedHashMap<String, String>();
        int hui = 0;
        while (true) {
            void var2_3;
            if (hui == var2_3.size()) {
                Boolean named = false;
                hashes = new ArrayList(unique.keySet());
                Collections.sort(hashes);
                for (String hash : hashes) {
                    String bnode2 = (String)unique.get(hash);
                    this.namer.getName(bnode2);
                    named = true;
                }
                if (!named.booleanValue()) break;
                hui = -1;
                ArrayList<String> arrayList2 = nextUnnamed;
                nextUnnamed = new ArrayList();
                duplicates = new LinkedHashMap();
                unique = new LinkedHashMap();
            } else {
                String bnode3 = (String)var2_3.get(hui);
                String hash = NormalizeUtils.hashQuads(bnode3, this.bnodes, this.namer);
                if (duplicates.containsKey(hash)) {
                    ((List)duplicates.get(hash)).add(bnode3);
                    nextUnnamed.add(bnode3);
                } else if (unique.containsKey(hash)) {
                    ArrayList<Object> tmp = new ArrayList<Object>();
                    tmp.add(unique.get(hash));
                    tmp.add(bnode3);
                    duplicates.put(hash, tmp);
                    nextUnnamed.add((String)unique.get(hash));
                    nextUnnamed.add(bnode3);
                    unique.remove(hash);
                } else {
                    unique.put(hash, bnode3);
                }
            }
            ++hui;
        }
        hashes = new ArrayList(duplicates.keySet());
        Collections.sort(hashes);
        int pgi = 0;
        while (true) {
            if (pgi == hashes.size()) {
                Iterator quad;
                ArrayList<String> normalized = new ArrayList<String>();
                for (int cai = 0; cai < this.quads.size(); ++cai) {
                    quad = (Map)this.quads.get(cai);
                    for (String attr : new String[]{"subject", "object", "name"}) {
                        Map qa;
                        if (!quad.containsKey(attr) || (qa = (Map)quad.get(attr)) == null || !"blank node".equals(qa.get("type")) || ((String)qa.get("value")).indexOf("_:c14n") == 0) continue;
                        qa.put("value", this.namer.getName((String)qa.get("value")));
                    }
                    normalized.add(RDFDatasetUtils.toNQuad((RDFDataset.Quad)((Object)quad), quad.containsKey("name") && quad.get("name") != null ? (String)((Map)quad.get("name")).get("value") : null));
                }
                Collections.sort(normalized);
                if (this.options.format != null) {
                    if (!"application/nquads".equals(this.options.format)) {
                        throw new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT, this.options.format);
                    }
                    String rval = "";
                    quad = normalized.iterator();
                    while (true) {
                        if (!quad.hasNext()) {
                            return rval;
                        }
                        String string = (String)quad.next();
                        rval = rval + string;
                    }
                }
                String rval = "";
                quad = normalized.iterator();
                while (true) {
                    if (!quad.hasNext()) {
                        return RDFDatasetUtils.parseNQuads(rval);
                    }
                    String string = (String)quad.next();
                    rval = rval + string;
                }
            }
            List group = (List)duplicates.get(hashes.get(pgi));
            ArrayList<HashResult> results = new ArrayList<HashResult>();
            int n = 0;
            while (true) {
                if (n == group.size()) {
                    Collections.sort(results, new Comparator<HashResult>(){

                        @Override
                        public int compare(HashResult a, HashResult b) {
                            int res = a.hash.compareTo(b.hash);
                            return res;
                        }
                    });
                    for (HashResult r : results) {
                        for (String key : r.pathNamer.existing().keySet()) {
                            this.namer.getName(key);
                        }
                    }
                    break;
                }
                String string = (String)group.get(n);
                if (!this.namer.isNamed(string).booleanValue()) {
                    UniqueNamer pathNamer = new UniqueNamer("_:b");
                    pathNamer.getName(string);
                    HashResult result = NormalizeUtils.hashPaths(string, this.bnodes, this.namer, pathNamer);
                    results.add(result);
                }
                ++n;
            }
            ++pgi;
        }
    }

    private static HashResult hashPaths(String id, Map<String, Object> bnodes, UniqueNamer namer, UniqueNamer pathNamer) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            LinkedHashMap groups = new LinkedHashMap();
            List quads = (List)((Map)bnodes.get(id)).get("quads");
            int hpi = 0;
            while (true) {
                if (hpi == quads.size()) {
                    ArrayList groupHashes = new ArrayList(groups.keySet());
                    Collections.sort(groupHashes);
                    int hgi = 0;
                    while (true) {
                        if (hgi == groupHashes.size()) {
                            HashResult res = new HashResult();
                            res.hash = NormalizeUtils.encodeHex(md.digest());
                            res.pathNamer = pathNamer;
                            return res;
                        }
                        String groupHash = (String)groupHashes.get(hgi);
                        md.update(groupHash.getBytes("UTF-8"));
                        String chosenPath = null;
                        UniqueNamer chosenNamer = null;
                        Permutator permutator = new Permutator((List)groups.get(groupHash));
                        while (true) {
                            Boolean contPermutation = false;
                            Boolean breakOut = false;
                            List<String> permutation = permutator.next();
                            UniqueNamer pathNamerCopy = pathNamer.clone();
                            String path = "";
                            ArrayList<String> recurse = new ArrayList<String>();
                            for (String bnode2 : permutation) {
                                if (namer.isNamed(bnode2).booleanValue()) {
                                    path = path + namer.getName(bnode2);
                                } else {
                                    if (!pathNamerCopy.isNamed(bnode2).booleanValue()) {
                                        recurse.add(bnode2);
                                    }
                                    path = path + pathNamerCopy.getName(bnode2);
                                }
                                if (chosenPath == null || path.length() < chosenPath.length() || path.compareTo(chosenPath) <= 0) continue;
                                if (permutator.hasNext()) {
                                    contPermutation = true;
                                    break;
                                }
                                md.update(chosenPath.getBytes("UTF-8"));
                                pathNamer = chosenNamer;
                                breakOut = true;
                                break;
                            }
                            if (contPermutation.booleanValue()) continue;
                            if (breakOut.booleanValue()) break;
                            int nrn = 0;
                            while (true) {
                                String bnode2;
                                if (nrn == recurse.size()) {
                                    if (chosenPath == null || path.compareTo(chosenPath) < 0) {
                                        chosenPath = path;
                                        chosenNamer = pathNamerCopy;
                                    }
                                    if (permutator.hasNext()) break;
                                    md.update(chosenPath.getBytes("UTF-8"));
                                    pathNamer = chosenNamer;
                                    breakOut = true;
                                    break;
                                }
                                bnode2 = (String)recurse.get(nrn);
                                HashResult result = NormalizeUtils.hashPaths(bnode2, bnodes, namer, pathNamerCopy);
                                path = path + pathNamerCopy.getName(bnode2) + "<" + result.hash + ">";
                                pathNamerCopy = result.pathNamer;
                                if (chosenPath != null && path.length() >= chosenPath.length() && path.compareTo(chosenPath) > 0) {
                                    if (permutator.hasNext()) break;
                                    md.update(chosenPath.getBytes("UTF-8"));
                                    pathNamer = chosenNamer;
                                    breakOut = true;
                                    break;
                                }
                                ++nrn;
                            }
                            if (breakOut.booleanValue()) break;
                        }
                        ++hgi;
                    }
                }
                Map quad = (Map)quads.get(hpi);
                String bnode3 = NormalizeUtils.getAdjacentBlankNodeName((Map)quad.get("subject"), id);
                String direction = null;
                if (bnode3 != null) {
                    direction = "p";
                } else {
                    bnode3 = NormalizeUtils.getAdjacentBlankNodeName((Map)quad.get("object"), id);
                    if (bnode3 != null) {
                        direction = "r";
                    }
                }
                if (bnode3 != null) {
                    String name = namer.isNamed(bnode3) != false ? namer.getName(bnode3) : (pathNamer.isNamed(bnode3) != false ? pathNamer.getName(bnode3) : NormalizeUtils.hashQuads(bnode3, bnodes, namer));
                    MessageDigest md1 = MessageDigest.getInstance("SHA-1");
                    md1.update(direction.getBytes("UTF-8"));
                    md1.update(((String)((Map)quad.get("predicate")).get("value")).getBytes("UTF-8"));
                    md1.update(name.getBytes("UTF-8"));
                    String groupHash = NormalizeUtils.encodeHex(md1.digest());
                    if (groups.containsKey(groupHash)) {
                        ((List)groups.get(groupHash)).add(bnode3);
                    } else {
                        ArrayList<String> tmp = new ArrayList<String>();
                        tmp.add(bnode3);
                        groups.put(groupHash, tmp);
                    }
                }
                ++hpi;
            }
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(e2);
        }
        catch (UnsupportedEncodingException e3) {
            throw new RuntimeException(e3);
        }
    }

    private static String hashQuads(String id, Map<String, Object> bnodes, UniqueNamer namer) {
        if (((Map)bnodes.get(id)).containsKey("hash")) {
            return (String)((Map)bnodes.get(id)).get("hash");
        }
        List quads = (List)((Map)bnodes.get(id)).get("quads");
        ArrayList<String> nquads = new ArrayList<String>();
        for (int i = 0; i < quads.size(); ++i) {
            nquads.add(RDFDatasetUtils.toNQuad((RDFDataset.Quad)quads.get(i), ((Map)quads.get(i)).get("name") != null ? (String)((Map)((Map)quads.get(i)).get("name")).get("value") : null, id));
        }
        Collections.sort(nquads);
        String hash = NormalizeUtils.sha1hash(nquads);
        ((Map)bnodes.get(id)).put("hash", hash);
        return hash;
    }

    private static String sha1hash(Collection<String> nquads) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            for (String nquad : nquads) {
                md.update(nquad.getBytes("UTF-8"));
            }
            return NormalizeUtils.encodeHex(md.digest());
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(e2);
        }
        catch (UnsupportedEncodingException e3) {
            throw new RuntimeException(e3);
        }
    }

    private static String encodeHex(byte[] data) {
        String rval = "";
        for (byte b : data) {
            rval = rval + String.format("%02x", b);
        }
        return rval;
    }

    private static String getAdjacentBlankNodeName(Map<String, Object> node, String id) {
        return "blank node".equals(node.get("type")) && (!node.containsKey("value") || !Obj.equals(node.get("value"), id)) ? (String)node.get("value") : null;
    }

    private static class Permutator {
        private final List<String> list;
        private boolean done;
        private final Map<String, Boolean> left;

        public Permutator(List<String> list) {
            this.list = (List)JsonLdUtils.clone(list);
            Collections.sort(this.list);
            this.done = false;
            this.left = new LinkedHashMap<String, Boolean>();
            for (String i : this.list) {
                this.left.put(i, true);
            }
        }

        public boolean hasNext() {
            return !this.done;
        }

        public List<String> next() {
            List rval = (List)JsonLdUtils.clone(this.list);
            String k = null;
            int pos = 0;
            int length = this.list.size();
            for (int i = 0; i < length; ++i) {
                String element = this.list.get(i);
                Boolean left = this.left.get(element);
                if (k != null && element.compareTo(k) <= 0 || (!left.booleanValue() || i <= 0 || element.compareTo(this.list.get(i - 1)) <= 0) && (left.booleanValue() || i >= length - 1 || element.compareTo(this.list.get(i + 1)) <= 0)) continue;
                k = element;
                pos = i;
            }
            if (k == null) {
                this.done = true;
            } else {
                int swap = this.left.get(k) != false ? pos - 1 : pos + 1;
                this.list.set(pos, this.list.get(swap));
                this.list.set(swap, k);
                for (int i = 0; i < length; ++i) {
                    if (this.list.get(i).compareTo(k) <= 0) continue;
                    this.left.put(this.list.get(i), this.left.get(this.list.get(i)) == false);
                }
            }
            return rval;
        }
    }

    private static class HashResult {
        String hash;
        UniqueNamer pathNamer;

        private HashResult() {
        }
    }
}

