/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.statements;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.jena.graph.Node;

public class DataWorldSqlParameterMetadata
implements ParameterMetaData {
    private int paramCount;

    public DataWorldSqlParameterMetadata(String query) throws SQLException {
        if (query == null) {
            throw new SQLException("Parameterized query String cannot be null");
        }
        this.paramCount = this.countParameters(query);
    }

    private int countParameters(String query) {
        int count = 0;
        for (int i = 0; i < query.length(); ++i) {
            if (query.charAt(i) != '?') continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.checkParamIndex(param);
        return Node.class.getCanonicalName();
    }

    private void checkParamIndex(int param) throws SQLException {
        if (param < 1 || param > this.paramCount) {
            throw new SQLException("Parameter Index is out of bounds");
        }
    }

    @Override
    public int getParameterCount() {
        return this.paramCount;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.checkParamIndex(param);
        return 1;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.checkParamIndex(param);
        return 2000;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        this.checkParamIndex(param);
        return Node.class.getCanonicalName();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.checkParamIndex(param);
        return 0;
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.checkParamIndex(param);
        return 0;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.checkParamIndex(param);
        return 0;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        this.checkParamIndex(param);
        return false;
    }
}

