/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.results;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.PeekIterator;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.QueryExecution;
import world.data.jdbc.metadata.TripleResultsMetadata;
import world.data.jdbc.results.StreamedResults;
import world.data.jdbc.statements.DataWorldStatement;

public class TripleIteratorResults
extends StreamedResults<Triple> {
    private TripleResultsMetadata metadata;
    private PeekIterator<Triple> triples;
    private String subjColumn;
    private String predColumn;
    private String objColumn;
    private int numColumns;

    public TripleIteratorResults(DataWorldStatement statement, QueryExecution qe, Iterator<Triple> ts) throws SQLException {
        super(statement, qe);
        this.triples = PeekIterator.create(ts);
        this.metadata = new TripleResultsMetadata(this, this.triples);
        this.numColumns = this.metadata.getColumnCount();
        this.subjColumn = this.metadata.getSubjectColumnLabel();
        this.predColumn = this.metadata.getPredicateColumnLabel();
        this.objColumn = this.metadata.getObjectColumnLabel();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (this.subjColumn != null && this.subjColumn.equals(columnLabel)) {
            return 1;
        }
        if (this.predColumn != null && this.predColumn.equals(columnLabel)) {
            return this.subjColumn == null ? 1 : 2;
        }
        if (this.objColumn != null && this.objColumn.equals(columnLabel)) {
            return this.subjColumn == null && this.predColumn == null ? 1 : (this.subjColumn == null || this.predColumn == null ? 2 : 3);
        }
        throw new SQLException("Column " + columnLabel + " does not exist in these results");
    }

    @Override
    protected boolean hasNext() throws SQLException {
        try {
            return this.triples.hasNext();
        }
        catch (QueryCancelledException e2) {
            throw new SQLException("Query was cancelled, it is likely that your query exceeded the specified execution timeout", e2);
        }
        catch (Throwable e3) {
            throw new SQLException("Unexpected error while moving through results", e3);
        }
    }

    @Override
    protected Triple moveNext() throws SQLException {
        try {
            return this.triples.next();
        }
        catch (QueryCancelledException e2) {
            throw new SQLException("Query was cancelled, it is likely that your query exceeded the specified execution timeout", e2);
        }
        catch (Throwable e3) {
            throw new SQLException("Unexpected error while moving through results", e3);
        }
    }

    @Override
    protected void closeStreamInternal() {
        if (this.triples != null) {
            if (this.triples instanceof Closeable) {
                ((Closeable)((Object)this.triples)).close();
            }
            this.triples = null;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.metadata;
    }

    @Override
    protected String findColumnLabel(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        if (columnIndex >= 1 && columnIndex <= this.numColumns) {
            switch (columnIndex) {
                case 1: {
                    return this.subjColumn != null ? this.subjColumn : (this.predColumn != null ? this.predColumn : this.objColumn);
                }
                case 2: {
                    return this.subjColumn != null && this.predColumn != null ? this.predColumn : this.objColumn;
                }
                case 3: {
                    return this.objColumn;
                }
            }
            throw new SQLException("Column Index is out of bounds");
        }
        throw new SQLException("Column Index is out of bounds");
    }

    @Override
    protected Node getNode(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        if (this.getCurrentRow() == null) {
            throw new SQLException("Not currently at a row");
        }
        Triple t = (Triple)this.getCurrentRow();
        if (this.subjColumn != null && this.subjColumn.equals(columnLabel)) {
            return t.getSubject();
        }
        if (this.predColumn != null && this.predColumn.equals(columnLabel)) {
            return t.getPredicate();
        }
        if (this.objColumn != null && this.objColumn.equals(columnLabel)) {
            return t.getObject();
        }
        throw new SQLException("Unknown column label");
    }
}

