/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.metadata;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.jena.atlas.iterator.PeekIterator;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.jdbc.results.metadata.columns.ColumnInfo;
import org.apache.jena.jdbc.results.metadata.columns.SparqlColumnInfo;
import org.apache.jena.jdbc.results.metadata.columns.StringColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.data.jdbc.JdbcCompatibility;
import world.data.jdbc.metadata.DataWorldResultsMetadata;
import world.data.jdbc.results.DataWorldResultsSet;

public class TripleResultsMetadata
extends DataWorldResultsMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleResultsMetadata.class);
    private static final String COLUMN_LABEL_SUBJECT = "Subject";
    private static final String COLUMN_LABEL_PREDICATE = "Predicate";
    private static final String COLUMN_LABEL_OBJECT = "Object";
    public static final int COLUMN_INDEX_SUBJECT = 1;
    public static final int COLUMN_INDEX_PREDICATE = 2;
    public static final int COLUMN_INDEX_OBJECT = 3;
    private static final int NUM_COLUMNS = 3;
    private String subjColumn = "Subject";
    private String predColumn = "Predicate";
    private String objColumn = "Object";

    private static ColumnInfo[] makeColumns(DataWorldResultsSet results, PeekIterator<Triple> ts) throws SQLException {
        return TripleResultsMetadata.makeColumns(results, ts, COLUMN_LABEL_SUBJECT, COLUMN_LABEL_PREDICATE, COLUMN_LABEL_OBJECT);
    }

    private static ColumnInfo[] makeColumns(DataWorldResultsSet results, PeekIterator<Triple> ts, String subjLabel, String predLabel, String objLabel) throws SQLException {
        int numColumns = 0;
        if (subjLabel != null) {
            ++numColumns;
        }
        if (predLabel != null) {
            ++numColumns;
        }
        if (objLabel != null) {
            ++numColumns;
        }
        ColumnInfo[] columns = new ColumnInfo[numColumns];
        String[] names = new String[numColumns];
        String string = subjLabel != null ? subjLabel : (names[0] = predLabel != null ? predLabel : objLabel);
        if (numColumns > 1) {
            String string2 = names[1] = subjLabel != null && predLabel != null ? predLabel : objLabel;
        }
        if (numColumns == 3) {
            names[2] = objLabel;
        }
        int level = JdbcCompatibility.normalizeLevel(results.getJdbcCompatibilityLevel());
        boolean columnsAsStrings = JdbcCompatibility.shouldTypeColumnsAsString(level);
        boolean columnsDetected = JdbcCompatibility.shouldDetectColumnTypes(level);
        Triple t = null;
        Node[] values = new Node[numColumns];
        if (columnsDetected) {
            if (ts.hasNext()) {
                t = ts.peek();
                if (numColumns == 3) {
                    values[0] = t.getSubject();
                    values[1] = t.getPredicate();
                    values[2] = t.getObject();
                } else {
                    Node node = subjLabel != null ? t.getSubject() : (values[0] = predLabel != null ? t.getPredicate() : t.getObject());
                    if (numColumns > 1) {
                        values[1] = subjLabel != null && predLabel != null ? t.getPredicate() : t.getObject();
                    }
                }
            } else {
                columnsAsStrings = true;
                columnsDetected = false;
            }
        }
        for (int i = 0; i < columns.length; ++i) {
            if (!columnsAsStrings && !columnsDetected) {
                columns[i] = new SparqlColumnInfo(names[i], 2000, 0);
                LOGGER.info("Low JDBC compatibility, column " + names[i] + " is being typed as Node");
                continue;
            }
            if (columnsAsStrings) {
                columns[i] = new StringColumn(names[i], 0);
                LOGGER.info("Medium JDBC compatibility, column " + names[i] + " is being typed as String");
                continue;
            }
            if (columnsDetected) {
                columns[i] = JdbcCompatibility.detectColumnType(names[i], values[i], false);
                LOGGER.info("High compatibility, column " + names[i] + " was detected as being of type " + columns[i].getClassName());
                continue;
            }
            throw new SQLFeatureNotSupportedException("Unknown JDBC compatibility level was set");
        }
        return columns;
    }

    public TripleResultsMetadata(DataWorldResultsSet results, PeekIterator<Triple> ts) throws SQLException {
        super(results, TripleResultsMetadata.makeColumns(results, ts));
    }

    public String getSubjectColumnLabel() {
        return this.subjColumn;
    }

    public String getPredicateColumnLabel() {
        return this.predColumn;
    }

    public String getObjectColumnLabel() {
        return this.objColumn;
    }
}

