/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.jdbc.metadata.MetadataSchema;
import org.apache.jena.jdbc.metadata.results.MetaResultSet;
import org.apache.jena.vocabulary.XSD;
import world.data.jdbc.connections.DataWorldConnection;

public class DataWorldSparqlMetadata
implements DatabaseMetaData {
    private static final String CATALOG_TERM = "RDF Store";
    private static final String SCHEMA_TERM = "Dataset";
    private static final String DEFAULT_CATALOG = "RDF";
    private static final String DEFAULT_SCHEMA = "Dataset";
    private static final int NO_LIMIT = 0;
    private static final int UNKNOWN_LIMIT = 0;
    private static final String[] SPARQL_KEYWORDS = new String[]{"BASE", "PREFIX", "SELECT", "DISTINCT", "REDUCED", "AS", "CONSTRUCT", "DESCRIBE", "ASK", "FROM", "NAMED", "WHERE", "GROUP", "BY", "HAVING", "ORDER", "ASC", "DESC", "LIMIT", "OFFSET", "VALUES", "LOAD", "SILENT", "INTO", "GRAPH", "CLEAR", "DROP", "CREATE", "ADD", "MOVE", "COPY", "INSERT DATA", "DELETE DATA", "DELETE WHERE", "WITH", "INSERT", "USING", "DEFAULT", "ALL", "OPTIONAL", "SERVICE", "BIND", "UNION", "UNDEF", "MINUS", "EXISTS", "NOT EXISTS", "FILTER", "a", "IN", "NOT IN", "STR", "LANG", "LANGMATCHES", "DATATYPE", "BOUND", "IRI", "URI", "BNODE", "RAND", "ABS", "CEIL", "FLOOR", "ROUND", "CONCAT", "STRLEN", "UCASE", "LCASE", "ENCODE_FOR_URI", "CONTAINS", "STRSTARTS", "STRENDS", "STRBEFORE", "STRAFTER", "YEAR", "MONTH", "DAY", "HOURS", "MINUTES", "SECONDS", "TIMEZONE", "TZ", "NOW", "UUID", "STRUUID", "MD5", "SHA1", "SHA256", "SHA384", "SHA512", "COALESCE", "IF", "STRLANG", "STRDT", "SAMETERM", "ISIRI", "ISURI", "ISBLANK", "REGEX", "SUBSTR", "REPLACE", "COUNT", "SUM", "MIN", "MAX", "AVG", "SAMPLE", "GROUP_CONCAT", "SEPARATOR", "true", "false"};
    private static final String[] SPARQL_NUMERIC_FUNCTIONS = new String[]{"ABS", "CEIL", "FLOOR", "RAND", "ROUND"};
    private static final String[] SPARQL_STR_FUNCTIONS = new String[]{"STR", "LANG", "LANGMATCHES", "CONCAT", "STRLEN", "UCASE", "LCASE", "ENCODE_FOR_URI", "CONTAINS", "STRSTARTS", "STRENDS", "STRBEFORE", "STRAFTER", "REGEX", "SUBSTR", "REPLACE"};
    private static final String[] SPARQL_DATETIME_FUNCTIONS = new String[]{"YEAR", "MONTH", "DAY", "HOURS", "MINUTES", "SECONDS", "TIMEZONE", "TZ", "NOW"};
    private DataWorldConnection connection;

    public DataWorldSparqlMetadata(DataWorldConnection connection) throws SQLException {
        if (connection == null) {
            throw new SQLException("Connection cannot be null");
        }
        this.connection = connection;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int arg0) {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    @Override
    public ResultSet getAttributes(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        return new MetaResultSet(MetadataSchema.getAttributeColumns());
    }

    @Override
    public ResultSet getBestRowIdentifier(String arg0, String arg1, String arg2, int arg3, boolean arg4) throws SQLException {
        return new MetaResultSet(MetadataSchema.getBestRowIdentifierColumns());
    }

    @Override
    public String getCatalogSeparator() {
        return "";
    }

    @Override
    public String getCatalogTerm() {
        return CATALOG_TERM;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return new MetaResultSet(MetadataSchema.getCatalogsColumns(), new Object[][]{{DEFAULT_CATALOG}});
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return new MetaResultSet(MetadataSchema.getClientInfoPropertyColumns());
    }

    @Override
    public ResultSet getColumnPrivileges(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        return new MetaResultSet(MetadataSchema.getColumnPrivilegeColumns());
    }

    @Override
    public ResultSet getColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        return new MetaResultSet(MetadataSchema.getColumnColumns());
    }

    @Override
    public final Connection getConnection() {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String arg0, String arg1, String arg2, String arg3, String arg4, String arg5) throws SQLException {
        return new MetaResultSet(MetadataSchema.getCrossReferenceColumns());
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int isolationLevel) {
        return isolationLevel == 0;
    }

    @Override
    public int getDatabaseMajorVersion() {
        return 1;
    }

    @Override
    public int getDatabaseMinorVersion() {
        return 0;
    }

    @Override
    public String getDatabaseProductName() {
        return "data.world";
    }

    @Override
    public String getDatabaseProductVersion() {
        return "1.0";
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public String getDriverName() {
        return "data.world JDBC driver";
    }

    @Override
    public String getDriverVersion() {
        return "1.0";
    }

    @Override
    public ResultSet getExportedKeys(String arg0, String arg1, String arg2) throws SQLException {
        return new MetaResultSet(MetadataSchema.getExportedKeyColumns());
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public ResultSet getFunctionColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        return new MetaResultSet(MetadataSchema.getFunctionColumnColumns());
    }

    @Override
    public ResultSet getFunctions(String arg0, String arg1, String arg2) throws SQLException {
        return new MetaResultSet(MetadataSchema.getFunctionColumns());
    }

    @Override
    public String getIdentifierQuoteString() {
        return " ";
    }

    @Override
    public ResultSet getImportedKeys(String arg0, String arg1, String arg2) throws SQLException {
        return new MetaResultSet(MetadataSchema.getImportedKeyColumns());
    }

    @Override
    public ResultSet getIndexInfo(String arg0, String arg1, String arg2, boolean arg3, boolean arg4) throws SQLException {
        return new MetaResultSet(MetadataSchema.getIndexInfoColumns());
    }

    @Override
    public final int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public final int getJDBCMinorVersion() {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 4;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 0;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 0;
    }

    @Override
    public String getNumericFunctions() {
        return StrUtils.strjoin(",", SPARQL_NUMERIC_FUNCTIONS);
    }

    @Override
    public ResultSet getPrimaryKeys(String arg0, String arg1, String arg2) throws SQLException {
        return new MetaResultSet(MetadataSchema.getPrimaryKeyColumns());
    }

    @Override
    public ResultSet getProcedureColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        return new MetaResultSet(MetadataSchema.getProcedureColumnColumns());
    }

    @Override
    public String getProcedureTerm() {
        return null;
    }

    @Override
    public ResultSet getProcedures(String arg0, String arg1, String arg2) throws SQLException {
        return new MetaResultSet(MetadataSchema.getProcedureColumns());
    }

    @Override
    public int getResultSetHoldability() {
        return 2;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public String getSQLKeywords() {
        return StrUtils.strjoin(",", SPARQL_KEYWORDS);
    }

    @Override
    public int getSQLStateType() {
        return 1;
    }

    @Override
    public String getSchemaTerm() {
        return "Dataset";
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return new MetaResultSet(MetadataSchema.getSchemaColumns(), new Object[][]{{"Dataset", DEFAULT_CATALOG}});
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (DEFAULT_CATALOG.equals(catalog)) {
            if (schemaPattern == null || "Dataset".equals(schemaPattern)) {
                return this.getSchemas();
            }
            return new MetaResultSet(MetadataSchema.getSchemaColumns());
        }
        return new MetaResultSet(MetadataSchema.getSchemaColumns());
    }

    @Override
    public String getSearchStringEscape() {
        return "";
    }

    @Override
    public String getStringFunctions() {
        return StrUtils.strjoin(",", SPARQL_STR_FUNCTIONS);
    }

    @Override
    public ResultSet getSuperTables(String arg0, String arg1, String arg2) throws SQLException {
        return new MetaResultSet(MetadataSchema.getSuperTableColumns());
    }

    @Override
    public ResultSet getSuperTypes(String arg0, String arg1, String arg2) throws SQLException {
        return new MetaResultSet(MetadataSchema.getSuperTypeColumns());
    }

    @Override
    public String getSystemFunctions() {
        return "";
    }

    @Override
    public ResultSet getTablePrivileges(String arg0, String arg1, String arg2) throws SQLException {
        return new MetaResultSet(MetadataSchema.getTablePrivilegeColumns());
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return new MetaResultSet(MetadataSchema.getTableTypeColumns());
    }

    @Override
    public ResultSet getTables(String arg0, String arg1, String arg2, String[] arg3) throws SQLException {
        return new MetaResultSet(MetadataSchema.getTableColumns());
    }

    @Override
    public String getTimeDateFunctions() {
        return StrUtils.strjoin(",", SPARQL_DATETIME_FUNCTIONS);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return new MetaResultSet(MetadataSchema.getTypeInfoColumns(), new Object[][]{{XSD.xboolean.toString(), 16, 0, null, null, null, (short)1, false, (short)3, false, false, false, null, (short)0, (short)0, 0, 0, 0}, {XSD.xbyte.toString(), -6, Byte.toString((byte)127).length(), "\"", "\"", null, (short)1, false, (short)3, false, false, false, null, (short)0, (short)0, 0, 0, 0}, {XSD.date.toString(), 91, 0, "\"", "\"", null, (short)1, false, (short)3, false, false, false, null, (short)0, (short)0, 0, 0, 0}, {XSD.dateTime.toString(), 91, 0, "\"", "\"", null, (short)1, false, (short)3, false, false, false, null, (short)0, (short)0, 0, 0, 0}, {XSD.decimal.toString(), 3, 16, null, null, null, (short)1, false, (short)3, false, false, false, null, (short)0, (short)16, 0, 0, 10}, {XSD.xdouble.toString(), 8, 16, null, null, null, (short)1, false, (short)3, false, false, false, null, (short)0, (short)16, 0, 0, 10}, {XSD.xfloat.toString(), 6, 15, "\"", "\"", null, (short)1, false, (short)3, false, false, false, null, (short)0, (short)7, 0, 0, 10}, {XSD.xshort.toString(), 4, Integer.toString(Integer.MAX_VALUE).length(), "\"", "\"", null, (short)1, false, (short)3, false, false, false, null, (short)0, (short)0, 0, 0, 10}, {XSD.integer.toString(), -5, Long.toString(Long.MAX_VALUE).length(), null, null, null, (short)1, false, (short)3, false, false, false, null, (short)0, (short)0, 0, 0, 10}, {XSD.xlong.toString(), -5, Long.toString(Long.MAX_VALUE).length(), "\"", "\"", null, (short)1, false, (short)3, false, false, false, null, (short)0, (short)0, 0, 0, 10}, {XSD.xint.toString(), -5, Long.toString(Long.MAX_VALUE).length(), "\"", "\"", null, (short)1, false, (short)3, false, false, false, null, (short)0, (short)0, 0, 0, 10}, {XSD.negativeInteger.toString(), -5, Long.toString(Long.MAX_VALUE).length(), "\"", "\"", null, (short)1, false, (short)3, false, false, false, null, (short)0, (short)0, 0, 0, 10}, {XSD.nonNegativeInteger.toString(), -5, Long.toString(Long.MAX_VALUE).length(), "\"", "\"", null, (short)1, false, (short)3, true, false, false, null, (short)0, (short)0, 0, 0, 10}, {XSD.nonPositiveInteger.toString(), -5, Long.toString(Long.MAX_VALUE).length(), "\"", "\"", null, (short)1, false, (short)3, false, false, false, null, (short)0, (short)0, 0, 0, 10}, {XSD.positiveInteger.toString(), -5, Long.toString(Long.MAX_VALUE).length(), "\"", "\"", null, (short)1, false, (short)3, true, false, false, null, (short)0, (short)0, 0, 0, 10}, {XSD.unsignedByte.toString(), -6, Byte.toString((byte)127).length(), "\"", "\"", null, (short)1, false, (short)3, true, false, false, null, (short)0, (short)0, 0, 0, 10}, {XSD.unsignedInt.toString(), -5, Long.toString(Long.MAX_VALUE).length(), "\"", "\"", null, (short)1, false, (short)3, true, false, false, null, (short)0, (short)0, 0, 0, 10}, {XSD.unsignedLong.toString(), -5, Long.toString(Long.MAX_VALUE).length(), "\"", "\"", null, (short)1, false, (short)3, true, false, false, null, (short)0, (short)0, 0, 0, 10}, {XSD.unsignedShort.toString(), 4, Integer.toString(Integer.MAX_VALUE).length(), "\"", "\"", null, (short)1, false, (short)3, true, false, false, null, (short)0, (short)0, 0, 0, 10}, {XSD.xstring.toString(), -9, 0, "\"", "\"", null, (short)1, true, (short)3, false, false, false, null, (short)0, (short)0, 0, 0, 0}, {XSD.time.toString(), 92, 0, "\"", "\"", null, (short)1, false, (short)3, false, false, false, null, (short)0, (short)0, 0, 0, 0}});
    }

    @Override
    public ResultSet getUDTs(String arg0, String arg1, String arg2, int[] arg3) throws SQLException {
        return new MetaResultSet(MetadataSchema.getUdtColumns());
    }

    @Override
    public String getURL() {
        return null;
    }

    @Override
    public String getUserName() {
        return null;
    }

    @Override
    public ResultSet getVersionColumns(String arg0, String arg1, String arg2) throws SQLException {
        return new MetaResultSet(MetadataSchema.getVersionColumns());
    }

    @Override
    public boolean insertsAreDetected(int arg0) {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return true;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return true;
    }

    @Override
    public boolean othersDeletesAreVisible(int arg0) {
        return true;
    }

    @Override
    public boolean othersInsertsAreVisible(int arg0) {
        return true;
    }

    @Override
    public boolean othersUpdatesAreVisible(int arg0) {
        return true;
    }

    @Override
    public boolean ownDeletesAreVisible(int arg0) {
        return true;
    }

    @Override
    public boolean ownInsertsAreVisible(int arg0) {
        return true;
    }

    @Override
    public boolean ownUpdatesAreVisible(int arg0) {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int arg0, int arg1) {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return concurrency == 1007 && this.supportsResultSetType(type);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return holdability == 2;
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return type == 1003;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int arg0) {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return new MetaResultSet(MetadataSchema.getPsuedoColumnColumns());
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return false;
    }
}

