/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import world.data.jdbc.DataWorldHttpAuthenticator;
import world.data.jdbc.connections.DataWorldConnection;

public class DataWorldJdbcDriver
implements Driver {
    private int majorVer = 0;
    private int minorVer = 1;

    public static synchronized void register() throws SQLException {
        DriverManager.registerDriver(new DataWorldJdbcDriver());
    }

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith("jdbc:data:world:sql:") || url.startsWith("jdbc:data:world:sparql:");
    }

    @Override
    public final Connection connect(String url, Properties props) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties effectiveProps = new Properties();
        String[] split = url.split(":");
        effectiveProps.setProperty("lang", split[3]);
        effectiveProps.setProperty("agentid", split[4]);
        effectiveProps.setProperty("datasetid", split[5]);
        effectiveProps.setProperty("querybaseurl", "https://query.data.world");
        if (props != null) {
            for (Map.Entry<Object, Object> e2 : props.entrySet()) {
                String key = e2.getKey().toString().toLowerCase(Locale.ENGLISH);
                Object value = e2.getValue();
                effectiveProps.put(key, value);
            }
        }
        String queryEndpoint = effectiveProps.get("querybaseurl") + "/" + effectiveProps.get("lang") + "/" + effectiveProps.get("agentid") + "/" + effectiveProps.get("datasetid");
        effectiveProps.put("query", queryEndpoint);
        HttpAuthenticator authenticator = this.configureAuthenticator(effectiveProps);
        return new DataWorldConnection(effectiveProps.getProperty("query"), authenticator, effectiveProps.getProperty("lang"));
    }

    @Override
    public int getMajorVersion() {
        return this.minorVer;
    }

    @Override
    public int getMinorVersion() {
        return this.majorVer;
    }

    @Override
    public final DriverPropertyInfo[] getPropertyInfo(String url, Properties props) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public final boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    private HttpAuthenticator configureAuthenticator(Properties props) {
        String username = (String)props.get("user");
        String password = (String)props.get("password");
        DataWorldHttpAuthenticator authenticator = new DataWorldHttpAuthenticator(username, password);
        props.put("authenticator", authenticator);
        return authenticator;
    }

    static {
        try {
            DataWorldJdbcDriver.register();
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }
}

