/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.Trie;
import org.apache.jena.iri.IRI;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapBase;

public class FastAbbreviatingPrefixMap
extends PrefixMapBase {
    private Map<String, IRI> prefixes = new HashMap<String, IRI>();
    private Map<String, IRI> prefixesView = Collections.unmodifiableMap(this.prefixes);
    private Trie<String> abbrevs = new Trie();

    public FastAbbreviatingPrefixMap() {
    }

    public FastAbbreviatingPrefixMap(PrefixMap pmap) {
        this.putAll(pmap);
    }

    @Override
    public Map<String, IRI> getMapping() {
        return this.prefixesView;
    }

    @Override
    public void add(String prefix, IRI iri) {
        IRI existing = this.prefixes.get(prefix = this.canonicalPrefix(prefix));
        if (existing != null && existing.equals(iri)) {
            return;
        }
        if (existing != null) {
            this.abbrevs.remove(existing.toString());
        }
        this.prefixes.put(prefix, iri);
        this.abbrevs.add(iri.toString(), prefix);
    }

    @Override
    public void delete(String prefix) {
        IRI iri = this.prefixes.get(prefix = this.canonicalPrefix(prefix));
        if (iri == null) {
            return;
        }
        this.abbrevs.remove(iri.toString());
        this.prefixes.remove(prefix);
    }

    @Override
    public boolean contains(String prefix) {
        prefix = this.canonicalPrefix(prefix);
        return this.prefixes.containsKey(prefix);
    }

    @Override
    public String abbreviate(String uriStr) {
        Pair<String, String> p = this.abbrev(this.prefixes, uriStr, true);
        if (p == null) {
            return null;
        }
        return p.getLeft() + ":" + p.getRight();
    }

    @Override
    public Pair<String, String> abbrev(String uriStr) {
        return this.abbrev(this.prefixes, uriStr, true);
    }

    @Override
    protected Pair<String, String> abbrev(Map<String, IRI> prefixes, String uriStr, boolean checkLocalPart) {
        String prefix = this.abbrevs.longestMatch(uriStr);
        if (prefix == null) {
            return null;
        }
        String ln2 = uriStr.substring(this.prefixes.get(prefix).toString().length());
        if (!checkLocalPart || this.isSafeLocalPart(ln2)) {
            return Pair.create(prefix, ln2);
        }
        return null;
    }

    @Override
    public String expand(String prefixedName) {
        int i = prefixedName.indexOf(58);
        if (i < 0) {
            return null;
        }
        return this.expand(prefixedName.substring(0, i), prefixedName.substring(i + 1));
    }

    @Override
    public String expand(String prefix, String localName) {
        IRI x = this.prefixes.get(prefix = this.canonicalPrefix(prefix));
        if (x == null) {
            return null;
        }
        return x.toString() + localName;
    }

    @Override
    public boolean isEmpty() {
        return this.prefixes.isEmpty();
    }

    @Override
    public int size() {
        return this.prefixes.size();
    }
}

