/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.results;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.jena.atlas.iterator.PeekIterator;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.jdbc.results.JenaResultSet;
import org.apache.jena.jdbc.results.MaterializedResults;
import org.apache.jena.jdbc.results.metadata.TripleResultsMetadata;
import org.apache.jena.jdbc.statements.JenaStatement;
import org.apache.jena.query.QueryExecution;

public class TripleListResults
extends MaterializedResults<Triple> {
    private TripleResultsMetadata metadata;
    private List<Triple> triples;
    private String subjColumn;
    private String predColumn;
    private String objColumn;
    private int numColumns;

    public TripleListResults(JenaStatement statement, QueryExecution qe, List<Triple> ts, boolean commit) throws SQLException {
        super(statement, qe, commit);
        if (ts == null) {
            throw new SQLException("Triple Iterator cannot be null");
        }
        this.triples = ts;
        this.metadata = statement.getJenaConnection().applyPostProcessors(new TripleResultsMetadata((JenaResultSet)this, new PeekIterator<Triple>(ts.iterator())));
        this.numColumns = this.metadata.getColumnCount();
        this.subjColumn = this.metadata.getSubjectColumnLabel();
        this.predColumn = this.metadata.getPredicateColumnLabel();
        this.objColumn = this.metadata.getObjectColumnLabel();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (this.subjColumn != null && this.subjColumn.equals(columnLabel)) {
            return 1;
        }
        if (this.predColumn != null && this.predColumn.equals(columnLabel)) {
            return this.subjColumn == null ? 1 : 2;
        }
        if (this.objColumn != null && this.objColumn.equals(columnLabel)) {
            return this.subjColumn == null && this.predColumn == null ? 1 : (this.subjColumn == null || this.predColumn == null ? 2 : 3);
        }
        throw new SQLException("Column " + columnLabel + " does not exist in these results");
    }

    @Override
    protected boolean hasNext() {
        return this.getRow() < this.triples.size();
    }

    @Override
    protected Triple moveNext() {
        return this.triples.get(this.getRow());
    }

    @Override
    protected boolean hasPrevious() {
        return this.getRow() > 1;
    }

    @Override
    protected Triple movePrevious() {
        return this.triples.get(this.getRow() - 1);
    }

    @Override
    protected int getTotalRows() {
        return this.triples.size();
    }

    @Override
    protected void closeStreamInternal() {
        if (this.triples != null) {
            this.triples = null;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.metadata;
    }

    @Override
    protected String findColumnLabel(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        if (columnIndex >= 1 && columnIndex <= this.numColumns) {
            switch (columnIndex) {
                case 1: {
                    return this.subjColumn != null ? this.subjColumn : (this.predColumn != null ? this.predColumn : this.objColumn);
                }
                case 2: {
                    return this.subjColumn != null && this.predColumn != null ? this.predColumn : this.objColumn;
                }
                case 3: {
                    return this.objColumn;
                }
            }
            throw new SQLException("Column Index is out of bounds");
        }
        throw new SQLException("Column Index is out of bounds");
    }

    @Override
    protected Node getNode(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        if (this.getCurrentRow() == null) {
            throw new SQLException("Not currently at a row");
        }
        Triple t = (Triple)this.getCurrentRow();
        if (this.subjColumn != null && this.subjColumn.equals(columnLabel)) {
            return t.getSubject();
        }
        if (this.predColumn != null && this.predColumn.equals(columnLabel)) {
            return t.getPredicate();
        }
        if (this.objColumn != null && this.objColumn.equals(columnLabel)) {
            return t.getObject();
        }
        throw new SQLException("Unknown column label");
    }
}

