/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.remote.statements;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.jdbc.remote.connections.RemoteEndpointConnection;
import org.apache.jena.jdbc.statements.JenaStatement;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;
import org.apache.jena.sparql.modify.UpdateProcessRemoteBase;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;

public class RemoteEndpointStatement
extends JenaStatement {
    private RemoteEndpointConnection remoteConn;
    private HttpAuthenticator authenticator;

    public RemoteEndpointStatement(RemoteEndpointConnection connection) throws SQLException {
        this(connection, null, 1003, 1000, 0, 2);
    }

    public RemoteEndpointStatement(RemoteEndpointConnection connection, HttpAuthenticator authenticator, int type, int fetchDir, int fetchSize, int holdability) throws SQLException {
        super(connection, type, fetchDir, fetchSize, holdability, false, 0);
        this.remoteConn = connection;
        this.authenticator = authenticator;
    }

    @Override
    protected QueryExecution createQueryExecution(Query q) throws SQLException {
        if (this.remoteConn.getQueryEndpoint() == null) {
            throw new SQLException("This statement is backed by a write-only connection, read operations are not supported");
        }
        QueryEngineHTTP exec = (QueryEngineHTTP)QueryExecutionFactory.sparqlService(this.remoteConn.getQueryEndpoint(), q);
        if (this.authenticator != null) {
            exec.setAuthenticator(this.authenticator);
        }
        if (this.remoteConn.getDefaultGraphURIs() != null) {
            exec.setDefaultGraphURIs(this.remoteConn.getDefaultGraphURIs());
        }
        if (this.remoteConn.getNamedGraphURIs() != null) {
            exec.setNamedGraphURIs(this.remoteConn.getNamedGraphURIs());
        }
        if (this.remoteConn.getSelectResultsType() != null) {
            exec.setSelectContentType(this.remoteConn.getSelectResultsType());
        }
        if (this.remoteConn.getModelResultsType() != null) {
            exec.setModelContentType(this.remoteConn.getModelResultsType());
        }
        return exec;
    }

    @Override
    protected UpdateProcessor createUpdateProcessor(UpdateRequest u) {
        UpdateProcessRemoteBase proc = (UpdateProcessRemoteBase)UpdateExecutionFactory.createRemote(u, this.remoteConn.getUpdateEndpoint());
        if (this.authenticator != null) {
            proc.setAuthenticator(this.authenticator);
        }
        if (this.remoteConn.getUsingGraphURIs() != null) {
            proc.setDefaultGraphs(this.remoteConn.getUsingGraphURIs());
        }
        if (this.remoteConn.getNamedGraphURIs() != null) {
            proc.setNamedGraphs(this.remoteConn.getUsingNamedGraphURIs());
        }
        return proc;
    }

    @Override
    protected void beginTransaction(ReadWrite type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions against remote endpoint backed connections are not supported");
    }

    @Override
    protected void commitTransaction() throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions against remote endpoint backed connections are not supported");
    }

    @Override
    protected void rollbackTransaction() throws SQLException {
        throw new SQLFeatureNotSupportedException("Transactions against remote endpoint backed connections are not supported");
    }

    @Override
    protected boolean hasActiveTransaction() {
        return false;
    }
}

