/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.connections;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLRecoverableException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.jena.graph.Triple;
import org.apache.jena.jdbc.JdbcCompatibility;
import org.apache.jena.jdbc.postprocessing.ResultsPostProcessor;
import org.apache.jena.jdbc.preprocessing.CommandPreProcessor;
import org.apache.jena.jdbc.results.metadata.AskResultsMetadata;
import org.apache.jena.jdbc.results.metadata.SelectResultsMetadata;
import org.apache.jena.jdbc.results.metadata.TripleResultsMetadata;
import org.apache.jena.jdbc.statements.JenaPreparedStatement;
import org.apache.jena.jdbc.statements.JenaStatement;
import org.apache.jena.query.Query;
import org.apache.jena.query.ResultSet;
import org.apache.jena.update.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JenaConnection
implements Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger(JenaConnection.class);
    public static final int DEFAULT_HOLDABILITY = 2;
    public static final boolean DEFAULT_AUTO_COMMIT = true;
    public static final int DEFAULT_ISOLATION_LEVEL = 0;
    private Properties clientInfo = new Properties();
    private int holdability = 2;
    private SQLWarning warnings = null;
    private boolean autoCommit = true;
    private int isolationLevel = 0;
    private int compatibilityLevel = 5;
    private List<Statement> statements = new ArrayList<Statement>();
    private List<CommandPreProcessor> preProcessors = new ArrayList<CommandPreProcessor>();
    private List<ResultsPostProcessor> postProcessors = new ArrayList<ResultsPostProcessor>();

    public JenaConnection(int holdability, boolean autoCommit, int transactionLevel, int compatibilityLevel) throws SQLException {
        this.checkHoldability(holdability);
        this.holdability = holdability;
        this.setAutoCommit(autoCommit);
        this.setTransactionIsolation(transactionLevel);
        this.compatibilityLevel = JdbcCompatibility.normalizeLevel(compatibilityLevel);
    }

    public int getJdbcCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    public void setJdbcCompatibilityLevel(int level) {
        this.compatibilityLevel = JdbcCompatibility.normalizeLevel(level);
    }

    public final void addPreProcessor(CommandPreProcessor preProcessor) {
        if (preProcessor == null) {
            return;
        }
        this.preProcessors.add(preProcessor);
    }

    public final void addPostProcessor(ResultsPostProcessor postProcessor) {
        if (postProcessor == null) {
            return;
        }
        this.postProcessors.add(postProcessor);
    }

    public final void insertPreProcessor(int index, CommandPreProcessor preProcessor) {
        if (preProcessor == null) {
            return;
        }
        this.preProcessors.add(index, preProcessor);
    }

    public final void insertPostProcessor(int index, ResultsPostProcessor postProcessor) {
        if (postProcessor == null) {
            return;
        }
        this.postProcessors.add(index, postProcessor);
    }

    public final void removePreProcessor(CommandPreProcessor preProcessor) {
        if (preProcessor == null) {
            return;
        }
        this.preProcessors.remove(preProcessor);
    }

    public final void removePostProcessor(ResultsPostProcessor postProcessor) {
        if (postProcessor == null) {
            return;
        }
        this.postProcessors.remove(postProcessor);
    }

    public final void removePreProcessor(int index) {
        this.preProcessors.remove(index);
    }

    public final void removePostProcessor(int index) {
        this.postProcessors.remove(index);
    }

    public final void clearPreProcessors() {
        this.preProcessors.clear();
    }

    public final void clearPostProcessors() {
        this.postProcessors.clear();
    }

    public final Iterator<CommandPreProcessor> getPreProcessors() {
        return this.preProcessors.iterator();
    }

    public final Iterator<ResultsPostProcessor> getPostProcessors() {
        return this.postProcessors.iterator();
    }

    public final String applyPreProcessors(String text) throws SQLException {
        for (CommandPreProcessor preProcessor : this.preProcessors) {
            if (preProcessor == null) continue;
            text = preProcessor.preProcessCommandText(text);
        }
        return text;
    }

    public final Query applyPreProcessors(Query q) throws SQLException {
        for (CommandPreProcessor preProcessor : this.preProcessors) {
            if (preProcessor == null) continue;
            q = preProcessor.preProcessQuery(q);
        }
        return q;
    }

    public final UpdateRequest applyPreProcessors(UpdateRequest u) throws SQLException {
        for (CommandPreProcessor preProcessor : this.preProcessors) {
            if (preProcessor == null) continue;
            u = preProcessor.preProcessUpdate(u);
        }
        return u;
    }

    public final ResultSet applyPostProcessors(ResultSet results) throws SQLException {
        for (ResultsPostProcessor postProcessor : this.postProcessors) {
            if (postProcessor == null) continue;
            results = postProcessor.postProcessResults(results);
        }
        return results;
    }

    public final Iterator<Triple> applyPostProcessors(Iterator<Triple> triples) throws SQLException {
        for (ResultsPostProcessor postProcessor : this.postProcessors) {
            if (postProcessor == null) continue;
            triples = postProcessor.postProcessResults(triples);
        }
        return triples;
    }

    public final boolean applyPostProcessors(boolean result) throws SQLException {
        for (ResultsPostProcessor postProcessor : this.postProcessors) {
            if (postProcessor == null) continue;
            result = postProcessor.postProcessResults(result);
        }
        return result;
    }

    public final SelectResultsMetadata applyPostProcessors(SelectResultsMetadata metadata) throws SQLException {
        for (ResultsPostProcessor postProcessor : this.postProcessors) {
            if (postProcessor == null) continue;
            metadata = postProcessor.postProcessResultsMetadata(metadata);
        }
        return metadata;
    }

    public final TripleResultsMetadata applyPostProcessors(TripleResultsMetadata metadata) throws SQLException {
        for (ResultsPostProcessor postProcessor : this.postProcessors) {
            if (postProcessor == null) continue;
            metadata = postProcessor.postProcessResultsMetadata(metadata);
        }
        return metadata;
    }

    public final AskResultsMetadata applyPostProcessors(AskResultsMetadata metadata) throws SQLException {
        for (ResultsPostProcessor postProcessor : this.postProcessors) {
            if (postProcessor == null) continue;
            metadata = postProcessor.postProcessResultsMetadata(metadata);
        }
        return metadata;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public final void close() throws SQLException {
        try {
            LOGGER.info("Closing connection...");
            this.closeStatements();
        }
        finally {
            this.closeInternal();
            LOGGER.info("Connection was closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStatements() throws SQLException {
        List<Statement> list = this.statements;
        synchronized (list) {
            if (this.statements.size() > 0) {
                LOGGER.info("Attempting to close " + this.statements.size() + " open statements");
                for (Statement stmt : this.statements) {
                    stmt.close();
                }
                LOGGER.info("All open statements were closed");
                this.statements.clear();
            }
        }
    }

    protected abstract void closeInternal() throws SQLException;

    @Override
    public void commit() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot commit on a closed connection");
        }
        try {
            LOGGER.info("Attempting to commit a transaction...");
            this.commitInternal();
            LOGGER.info("Transaction was committed");
            if (this.holdability == 2) {
                LOGGER.info("Holdability set to CLOSE_CURSORS_AT_COMMIT so closing open statements");
                this.closeStatements();
            }
        }
        catch (SQLException e2) {
            throw e2;
        }
        catch (Exception e3) {
            LOGGER.error("Unexpected error in transaction commit", e3);
            throw new SQLException("Unexpected error committing transaction", e3);
        }
    }

    protected abstract void commitInternal() throws SQLException;

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public final Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot create a statement after the connection was closed");
        }
        return this.createStatement(1003, 1007);
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot create a statement after the connection was closed");
        }
        return this.createStatement(resultSetType, resultSetConcurrency, this.getHoldability());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot create a statement after the connection was closed");
        }
        JenaStatement stmt = this.createStatementInternal(resultSetType, resultSetConcurrency, resultSetHoldability);
        List<Statement> list = this.statements;
        synchronized (list) {
            this.statements.add(stmt);
        }
        return stmt;
    }

    protected abstract JenaStatement createStatementInternal(int var1, int var2, int var3) throws SQLException;

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() {
        return "RDF";
    }

    @Override
    public Properties getClientInfo() {
        return this.clientInfo;
    }

    @Override
    public String getClientInfo(String name) {
        return this.clientInfo.getProperty(name);
    }

    @Override
    public int getHoldability() {
        return this.holdability;
    }

    @Override
    public abstract DatabaseMetaData getMetaData() throws SQLException;

    @Override
    public int getTransactionIsolation() {
        return this.isolationLevel;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warnings;
    }

    @Override
    public abstract boolean isClosed() throws SQLException;

    @Override
    public abstract boolean isReadOnly() throws SQLException;

    @Override
    public abstract boolean isValid(int var1) throws SQLException;

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot create a statement after the connection was closed");
        }
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot create a statement after the connection was closed");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot create a statement after the connection was closed");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot create a statement after the connection was closed");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot create a statement after the connection was closed");
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.holdability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot create a statement after the connection was closed");
        }
        return this.createPreparedStatementInternal(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    protected abstract JenaPreparedStatement createPreparedStatementInternal(String var1, int var2, int var3, int var4) throws SQLException;

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot rollback on a closed connection");
        }
        try {
            LOGGER.info("Attempting to rollback a transaction...");
            this.rollbackInternal();
            LOGGER.info("Transaction was rolled back");
            if (this.holdability == 2) {
                LOGGER.info("Holdability is set to CLOSE_CURSORS_AT_COMMIT so closing open statements");
                this.closeStatements();
            }
        }
        catch (SQLException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new SQLException("Unexpected error rolling back transaction", e3);
        }
    }

    protected abstract void rollbackInternal() throws SQLException;

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClientInfo(Properties properties) {
        this.clientInfo = properties;
    }

    @Override
    public void setClientInfo(String name, String value) {
        this.clientInfo.put(name, value);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkHoldability(holdability);
        this.holdability = holdability;
    }

    protected void checkHoldability(int h) throws SQLException {
        switch (h) {
            case 1: 
            case 2: {
                return;
            }
        }
        throw new SQLRecoverableException(String.format("%d is not a valid holdability setting", h));
    }

    @Override
    public abstract void setReadOnly(boolean var1) throws SQLException;

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkTransactionIsolation(level);
        this.isolationLevel = level;
    }

    protected abstract void checkTransactionIsolation(int var1) throws SQLException;

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    protected void setWarning(SQLWarning warning) {
        LOGGER.warn("SQL Warning was issued", warning);
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            warning.setNextWarning(this.warnings);
            this.warnings = warning;
        }
    }

    protected void setWarning(String warning) {
        this.setWarning(new SQLWarning(warning));
    }

    protected void setWarning(String warning, Throwable cause) {
        this.setWarning(new SQLWarning(warning, cause));
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

