/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.test;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.jena.atlas.lib.RandomLib;

public class Gen {
    public static int[] rand(int numRand, int low, int high) {
        return Gen.rand(numRand, low, high, false);
    }

    public static int[] rand(int numRand, int low, int high, boolean allDifferent) {
        int[] k = new int[numRand];
        Arrays.fill(k, -1);
        for (int i = 0; i < numRand; ++i) {
            int x;
            if (allDifferent) {
                block1: while (true) {
                    x = RandomLib.random.nextInt(high - low) + low;
                    for (int j = 0; j < i; ++j) {
                        if (k[j] == x) continue block1;
                    }
                    break;
                }
                k[i] = x;
                continue;
            }
            k[i] = x = RandomLib.random.nextInt(high - low) + low;
        }
        return k;
    }

    public static int[] permute(int[] x) {
        int[] x2 = new int[x.length];
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i : x) {
            list.add(i);
        }
        for (int i = 0; i < x.length; ++i) {
            int idx = RandomLib.random.nextInt(list.size());
            x2[i] = (Integer)list.remove(idx);
        }
        return x2;
    }

    public static int[] shuffle(int[] x, int num) {
        int[] x2 = new int[x.length];
        System.arraycopy(x, 0, x2, 0, x.length);
        for (int i = 0; i < num; ++i) {
            int a = RandomLib.random.nextInt(x2.length);
            int b = RandomLib.random.nextInt(x2.length);
            int t = x2[a];
            x2[a] = x2[b];
            x2[b] = t;
        }
        for (int k : x) {
            boolean found = false;
            for (int k2 : x2) {
                if (k != k2) continue;
                found = true;
                break;
            }
            if (found) continue;
            System.err.printf("Corrupted permute: [%s] [%s]\n", Gen.strings(x), Gen.strings(x2));
        }
        return x2;
    }

    public static String strings(int[] keys) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int k : keys) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(k);
        }
        return sb.toString();
    }
}

