/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi.web;

import convex.core.cvm.State;
import convex.core.data.AArrayBlob;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.Keyword;
import convex.core.lang.RT;
import convex.core.util.Utils;
import convex.restapi.RESTServer;
import convex.restapi.api.ABaseAPI;
import convex.restapi.web.AWebSite;
import io.javalin.Javalin;
import io.javalin.http.Context;
import j2html.TagCreator;
import j2html.tags.DomContent;
import java.util.Collection;

public class WebApp
extends AWebSite {
    public WebApp(RESTServer restServer) {
        super(restServer);
    }

    @Override
    public void addRoutes(Javalin app) {
        app.get("/index.html", this::indexPage);
        app.get("/", this::indexPage);
        app.get("/404.html", this::missingPage);
        app.get("/llms.txt", this::llmsTxt);
        app.error(404, this::missingPage);
    }

    private void indexPage(Context ctx) {
        String host = ABaseAPI.getExternalBaseUrl(ctx, null);
        String peerKeyHex = this.server.getPeer().getPeerKey().toHexString();
        String peerLink = ABaseAPI.getExternalBaseUrl(ctx, "/explorer/peers/" + peerKeyHex);
        State state = this.server.getState();
        long accountCount = state.getAccounts().count();
        long issuedSupply = state.computeSupply();
        AMap statusMap = this.server.getStatusMap();
        this.returnPage(ctx, "Convex Peer Server", new DomContent[]{TagCreator.tag((String)"hgroup").with(new DomContent[]{TagCreator.h6((String)("Convex peer server at: " + host)), TagCreator.p((String)"This is an operational Convex peer, a running consensus node on a Convex network. Use this server to interact with the Convex network, deploy smart contracts, query chain states, and monitor transactions in real-time.")}), TagCreator.article((DomContent[])new DomContent[]{TagCreator.details((DomContent[])new DomContent[]{TagCreator.summary((String)"Peer Info"), TagCreator.table((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Version"), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)Utils.getVersion())})}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Peer Port"), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)(WebApp.getHostname(ctx) + ":" + this.server.getPort()))})}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Host"), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)host)})}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Peer Key"), TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((DomContent[])new DomContent[]{WebApp.showID((AArrayBlob)this.server.getPeer().getPeerKey())}).withHref(peerLink)})})})}).attr("open", (Object)true)}), TagCreator.article((DomContent[])new DomContent[]{TagCreator.details((DomContent[])new DomContent[]{TagCreator.summary((String)"Network Info"), TagCreator.table((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Genesis Hash"), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)this.server.getPeer().getGenesisState().getHash().toString())})}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Accounts"), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)Long.toString(accountCount))})}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Issued CVM"), TagCreator.td((DomContent[])new DomContent[]{this.showBalance(issuedSupply)})})})}).attr("open", (Object)true)}), TagCreator.article((DomContent[])new DomContent[]{TagCreator.details((DomContent[])new DomContent[]{TagCreator.summary((String)"Status"), TagCreator.table((DomContent[])new DomContent[]{TagCreator.each((Collection)statusMap.entryVector(), me -> TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)((Keyword)me.getKey()).getName().toString()), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)RT.toString((ACell)me.getValue()))})}))})})})});
    }

    protected void missingPage(Context ctx) {
        String type = ctx.header("Accept");
        if (type != null && type.contains("html")) {
            ctx.header("Content-Type", "text/html");
            this.returnPage(ctx, "404: Not Found: " + ctx.path(), new DomContent[]{TagCreator.h1((String)("404: not found: " + ctx.path())), TagCreator.p((String)"This is not the page you are looking for."), TagCreator.a((String)"Go back to index").withHref("/index.html")});
        } else {
            ctx.result("404 Not found: " + ctx.path());
        }
        ctx.status(404);
    }

    protected void llmsTxt(Context ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append("# Convex Peer Server");
        ctx.result(sb.toString());
        ctx.contentType("text/plain");
        ctx.status(200);
    }
}

