/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi.api;

import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.SourceCodes;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Keyword;
import convex.core.data.Strings;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.ParseException;
import convex.core.json.JSONReader;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.text.StringUtils;
import convex.core.util.JSON;
import io.javalin.Javalin;
import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public abstract class AGenericAPI {
    public abstract void addRoutes(Javalin var1);

    protected String calcResponseContentType(Context ctx) {
        Enumeration accepts = ctx.req().getHeaders("Accept");
        String type = "application/json";
        if (accepts != null) {
            for (String a : Collections.list(accepts)) {
                if (a.contains("application/cvx-raw")) {
                    type = "application/cvx-raw";
                    break;
                }
                if (a.contains("text/plain")) {
                    type = "text/plain";
                }
                if (a.contains("text/html")) {
                    type = "text/html";
                }
                if (!a.contains("application/cvx")) continue;
                type = "application/cvx";
            }
        }
        return type;
    }

    protected Map<String, Object> getJSONBody(Context ctx) {
        try {
            Map req = (Map)RT.jvm((ACell)JSON.parse((String)ctx.body()));
            return req;
        }
        catch (ParseException | IllegalArgumentException e) {
            throw new BadRequestResponse(AGenericAPI.jsonError("Invalid JSON body"));
        }
    }

    protected AMap<AString, ACell> readJSONBody(Context ctx) {
        try {
            AMap req = JSONReader.readObject((InputStream)ctx.bodyInputStream());
            return req;
        }
        catch (ParseException | IOException | IllegalArgumentException e) {
            throw new BadRequestResponse(AGenericAPI.jsonError("Invalid JSON body: " + e.getMessage()));
        }
    }

    protected <T extends ACell> T getCVXBody(Context ctx) {
        try {
            String contentType = ctx.contentType();
            ACell req = "application/json".equals(contentType) ? JSON.parse((String)ctx.body()) : Reader.read((String)ctx.body());
            return (T)req;
        }
        catch (Exception e) {
            throw new BadRequestResponse(AGenericAPI.jsonError("Invalid CVX body"));
        }
    }

    protected <T extends ACell> T getRawBody(Context ctx) {
        try {
            byte[] bs = ctx.bodyAsBytes();
            ACell result = Format.decodeMultiCell((Blob)Blob.wrap((byte[])bs));
            return (T)result;
        }
        catch (Exception e) {
            throw new BadRequestResponse(AGenericAPI.jsonError("Invalid Raw body"));
        }
    }

    protected static String jsonError(String string) {
        return "{\"error\":\"" + string + "\"}";
    }

    public void setResult(Context ctx, Result resultContent) {
        if (resultContent.getSource() == null) {
            resultContent = resultContent.withSource(SourceCodes.SERVER);
        }
        int status = this.statusForResult(resultContent);
        ctx.status(status);
        this.setContent(ctx, (ACell)resultContent);
    }

    public void setContent(Context ctx, ACell content) {
        String type = this.calcResponseContentType(ctx);
        if (type.equals("application/json")) {
            ctx.contentType("application/json");
            if (content instanceof Result) {
                Result r = (Result)content;
                HashMap jsonResult = r.toJSON();
                ctx.result(JSON.printPretty((Object)jsonResult).getInputStream());
            } else {
                ctx.result(JSON.printPretty((Object)content).getInputStream());
            }
        } else if (type.equals("application/cvx")) {
            ctx.contentType("application/cvx");
            AString rs = RT.print((ACell)content);
            if (rs == null) {
                this.setResult(ctx, Result.error((Keyword)ErrorCodes.LIMIT, (AString)Strings.PRINT_EXCEEDED).withSource(SourceCodes.PEER));
                ctx.status(403);
                return;
            }
            ctx.result(rs.toString());
        } else if (type.equals("application/cvx-raw")) {
            ctx.contentType("application/cvx-raw");
            Blob b = Format.encodeMultiCell((ACell)content, (boolean)true);
            ctx.result(b.getBytes());
        } else if (type.equals("text/html")) {
            ctx.contentType("text/html");
            AString htmlContent = this.formatAsHTML(content);
            ctx.result(htmlContent.toString());
        } else if (type.equals("text/plain")) {
            ctx.contentType("text/plain");
            ctx.result("Unsupported content type: " + type);
        } else {
            ctx.contentType("text/plain");
            ctx.status(415);
            ctx.result("Unsupported content type: " + type);
        }
    }

    public int statusForResult(Result r) {
        if (!r.isError()) {
            return 200;
        }
        Keyword source = r.getSource();
        ACell error = r.getErrorCode();
        if (SourceCodes.CVM.equals(source)) {
            return 200;
        }
        if (SourceCodes.CODE.equals(source)) {
            return 200;
        }
        if (SourceCodes.PEER.equals(source)) {
            if (ErrorCodes.SIGNATURE.equals(error)) {
                return 403;
            }
            if (ErrorCodes.FUNDS.equals(error)) {
                return 402;
            }
        }
        if (ErrorCodes.FORMAT.equals(error)) {
            return 400;
        }
        if (ErrorCodes.TIMEOUT.equals(error)) {
            return 408;
        }
        int status = 422;
        return status;
    }

    private AString formatAsHTML(ACell content) {
        BlobBuilder bb = new BlobBuilder();
        bb.append("<!DOCTYPE html>\n<html><head><title>Convex API Result</title><meta charset=\"UTF-8\"></head><body><pre>\n");
        try {
            AString jsonString = JSON.printPretty((Object)content);
            bb.append(StringUtils.escapeHtml((AString)jsonString));
        }
        catch (Exception e) {
            bb.append("Error formatting result: ");
            bb.append(StringUtils.escapeHtml((AString)Strings.create((String)e.getMessage())));
        }
        bb.append("\n</pre></body></html>");
        return bb.getCVMString();
    }
}

