/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi.api;

import convex.core.cvm.Address;
import convex.core.cvm.State;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.Symbol;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.peer.Server;
import convex.restapi.RESTServer;
import convex.restapi.api.AGenericAPI;
import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;

public abstract class ABaseAPI
extends AGenericAPI {
    protected final RESTServer restServer;
    protected final Server server;
    private static final long DEFAULT_LIMIT = 10L;

    public ABaseAPI(RESTServer restServer) {
        this.restServer = restServer;
        this.server = restServer.getServer();
    }

    public static String getHostname(Context ctx) {
        int colon;
        String host = ctx.header("X-Forwarded-Host");
        if (host == null) {
            host = ctx.host();
        }
        if ((colon = host.indexOf(58)) >= 0) {
            host = host.substring(0, colon);
        }
        return host;
    }

    public static String getExternalBaseUrl(Context ctx, String basePath) {
        String port;
        String proto = ctx.header("X-Forwarded-Proto");
        if (proto == null) {
            proto = ctx.scheme();
        }
        if ((port = ctx.header("X-Forwarded-Port")) == null) {
            port = Integer.toString(ctx.port());
        }
        String host = ABaseAPI.getHostname(ctx);
        Object prefix = ctx.header("X-Forwarded-Prefix");
        StringBuilder baseUrl = new StringBuilder();
        baseUrl.append(proto).append("://");
        baseUrl.append(host);
        if (!(host.contains(":") || "https".equalsIgnoreCase(proto) && "443".equals(port) || "http".equalsIgnoreCase(proto) && "80".equals(port))) {
            baseUrl.append(':').append(port);
        }
        if (basePath != null && !basePath.isEmpty()) {
            Object cleanedBasePath = basePath.startsWith("/") ? basePath : "/" + basePath;
            cleanedBasePath = ((String)cleanedBasePath).endsWith("/") ? ((String)cleanedBasePath).substring(0, ((String)cleanedBasePath).length() - 1) : cleanedBasePath;
            baseUrl.append((String)cleanedBasePath);
        }
        if (prefix != null && !((String)prefix).isEmpty()) {
            prefix = ((String)prefix).startsWith("/") ? prefix : "/" + (String)prefix;
            Object object = prefix = ((String)prefix).endsWith("/") ? ((String)prefix).substring(0, ((String)prefix).length() - 1) : prefix;
            if (!baseUrl.toString().endsWith((String)prefix)) {
                baseUrl.append((String)prefix);
            }
        }
        return baseUrl.toString();
    }

    protected long[] getPaginationRange(Context ctx, long maxIndex) {
        long[] range = new long[3];
        try {
            long limit;
            long offset;
            String offsetParam = ctx.queryParam("offset");
            long l = offset = offsetParam == null ? 0L : (long)Integer.parseInt(offsetParam);
            if (offset < 0L) {
                throw new BadRequestResponse("Negative offset parameter: " + offset);
            }
            if (offset > maxIndex) {
                throw new BadRequestResponse("Offset out of range: " + offset);
            }
            String limitParam = ctx.queryParam("limit");
            long l2 = limit = offsetParam == null ? 10L : (long)Integer.parseInt(limitParam);
            if (limit < 0L) {
                throw new BadRequestResponse("Negative limit parameter: " + limit);
            }
            range[0] = offset;
            range[1] = Math.min(maxIndex, offset + limit);
            range[2] = limit;
        }
        catch (BadRequestResponse e) {
            throw e;
        }
        catch (NumberFormatException e) {
            throw new BadRequestResponse("Unable to parse offset/limit");
        }
        return range;
    }

    protected Address resolveAddress(ACell o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Address) {
            Address a = (Address)o;
            return a;
        }
        if (o instanceof Symbol) {
            Symbol sym = (Symbol)o;
            State state = this.server.getState();
            ACell cnsValue = state.lookupCNS(sym);
            return this.resolveAddress(cnsValue);
        }
        if (o instanceof AVector) {
            AVector v = (AVector)o;
            if (v.count() != 2L) {
                return null;
            }
            return this.resolveAddress(v.get(0));
        }
        try {
            AString s = RT.ensureString((ACell)o);
            if (s != null) {
                if (s.startsWith("@")) {
                    s = s.slice(1L);
                }
                return this.resolveAddress(Reader.read((AString)s));
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to resolve address from object: " + String.valueOf(o) + " cause: " + e.getMessage(), e);
        }
    }
}

