/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi.api;

import convex.core.cpos.Order;
import convex.core.cvm.Peer;
import convex.core.cvm.State;
import convex.core.data.AVector;
import convex.core.data.SignedData;
import convex.peer.Server;
import convex.restapi.RESTServer;
import convex.restapi.api.ABaseAPI;
import io.javalin.Javalin;
import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;
import io.javalin.http.InternalServerErrorResponse;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.HtmlTag;
import j2html.tags.specialized.LinkTag;
import java.util.ArrayList;

public class ExplorerAPI
extends ABaseAPI {
    private static final String ROUTE = "/explorer/";
    private static final long DEFAULT_LIMIT = 100L;

    public ExplorerAPI(RESTServer restServer) {
        super(restServer);
    }

    @Override
    public void addRoutes(Javalin app) {
        String prefix = ROUTE;
        app.get(prefix, this::showExplorer);
        app.get(prefix + "blocks", this::showBlocks);
        app.get(prefix + "states", this::showStates);
    }

    private DomContent makeHeader(String title) {
        return TagCreator.head((DomContent[])new DomContent[]{TagCreator.title((String)title), ((LinkTag)TagCreator.link().withRel("stylesheet")).withHref("/css/pico.min.css")});
    }

    public void showExplorer(Context ctx) {
        HtmlTag result = TagCreator.html((DomContent[])new DomContent[]{this.makeHeader("Peer Explorer"), TagCreator.body((DomContent[])new DomContent[]{TagCreator.h1((String)"Convex Explorer"), TagCreator.article((DomContent[])new DomContent[]{TagCreator.h4((String)"Useful links: "), TagCreator.p((DomContent[])new DomContent[]{TagCreator.a((String)"Consensus Blocks").withHref("/explorer/blocks")}), TagCreator.p((DomContent[])new DomContent[]{TagCreator.a((String)"States").withHref("/explorer/states")})})})});
        ctx.result(result.render());
        ctx.contentType("text/html");
    }

    public void showStates(Context ctx) {
        Server s = this.restServer.getServer();
        Peer peer = s.getPeer();
        long nstates = peer.getStatePosition() + 1L;
        long[] range = this.getPaginationRange(ctx, nstates);
        long start = range[0];
        long end = range[1];
        ArrayList<DomContent[]> rows = new ArrayList<DomContent[]>();
        for (long i = start; i < end; ++i) {
            State state = i == 0L ? peer.getGenesisState() : peer.getBlockResult(i - 1L).getState();
            rows.add(new DomContent[]{TagCreator.td((String)Long.toString(i)), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)state.getHash().toString())})});
        }
        HtmlTag result = TagCreator.html((DomContent[])new DomContent[]{this.makeHeader("States"), TagCreator.body((DomContent[])new DomContent[]{TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Position"), TagCreator.th((String)"Hash")})}), TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.each(rows, row -> TagCreator.tr((DomContent[])row))})})})});
        ctx.result(result.render());
        ctx.contentType("text/html");
    }

    public void showBlocks(Context ctx) {
        Server s = this.restServer.getServer();
        Peer peer = s.getPeer();
        Order o = peer.getPeerOrder();
        AVector blocks = o.getBlocks();
        long nblocks = blocks.count();
        long[] range = this.getPaginationRange(ctx, nblocks);
        long start = range[0];
        long end = range[1];
        ArrayList<DomContent[]> rows = new ArrayList<DomContent[]>();
        for (long i = start; i < end; ++i) {
            SignedData sd = (SignedData)blocks.get(i);
            rows.add(new DomContent[]{TagCreator.td((String)Long.toString(i)), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)sd.getAccountKey().toString())}), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)sd.getHash().toString())})});
        }
        HtmlTag result = TagCreator.html((DomContent[])new DomContent[]{this.makeHeader("Blocks"), TagCreator.body((DomContent[])new DomContent[]{TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Block"), TagCreator.th((String)"Peer"), TagCreator.th((String)"Hash")})}), TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.each(rows, row -> TagCreator.tr((DomContent[])row))})})})});
        ctx.contentType("text/html");
        ctx.result(result.render());
    }

    private long[] getPaginationRange(Context ctx, long ns) {
        long[] range = new long[2];
        try {
            long limit;
            long offset;
            String offsetParam = ctx.queryParam("offset");
            long l = offset = offsetParam == null ? 0L : (long)Integer.parseInt(offsetParam);
            if (offset < 0L) {
                throw new BadRequestResponse("Negative offset parameter: " + offset);
            }
            if (offset > ns) {
                throw new BadRequestResponse("Offset out of range: " + offset);
            }
            String limitParam = ctx.queryParam("limit");
            long l2 = limit = offsetParam == null ? 100L : (long)Integer.parseInt(limitParam);
            if (limit < 0L) {
                throw new BadRequestResponse("Negative limit parameter: " + limit);
            }
            range[0] = offset;
            range[1] = Math.min(ns, offset + limit);
        }
        catch (BadRequestResponse e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorResponse("Error handling query parameter: " + String.valueOf(e));
        }
        return range;
    }
}

