/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi.api;

import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AVector;
import convex.core.lang.RT;
import convex.dlfs.DLFS;
import convex.dlfs.DLFSNode;
import convex.dlfs.DLFSProvider;
import convex.dlfs.DLFileSystem;
import convex.dlfs.DLPath;
import convex.restapi.RESTServer;
import convex.restapi.api.ABaseAPI;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.http.InternalServerErrorResponse;
import io.javalin.http.NotFoundResponse;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;

public class DLAPI
extends ABaseAPI {
    private static final String ROUTE = "/dlfs/";

    public DLAPI(RESTServer restServer) {
        super(restServer);
    }

    @Override
    public void addRoutes(Javalin app) {
        String prefix = ROUTE;
        app.get(prefix + "<path>", this::getFile);
    }

    public void getFile(Context ctx) {
        String pathParam = ctx.pathParam("path");
        System.err.println("DLFS Request: " + pathParam);
        DLFSProvider provider = DLFS.provider();
        Iterator fss = provider.getFileSystems().iterator();
        if (!fss.hasNext()) {
            throw new NotFoundResponse("No DLFS Filesystems available");
        }
        DLFileSystem fs = (DLFileSystem)fss.next();
        DLPath p = fs.getPath(pathParam, new String[0]);
        if (!Files.exists((Path)p, new LinkOption[0])) {
            throw new NotFoundResponse("Can't find file: " + pathParam);
        }
        try {
            if (Files.isDirectory((Path)p, new LinkOption[0])) {
                ctx.header("Content-type", "text/plain");
                AVector dir = fs.getNode(p);
                AHashMap ents = DLFSNode.getDirectoryEntries((AVector)dir);
                ACell[] names = ents.getKeys().toCellArray();
                StringBuilder sb = new StringBuilder();
                for (ACell a : names) {
                    sb.append(RT.str((ACell)a));
                }
                if (!sb.isEmpty()) {
                    ctx.result("Empty DLFS Directory");
                } else {
                    ctx.result(sb.toString());
                }
            } else {
                ctx.header("Content-type", "image");
                ctx.result(Files.newInputStream((Path)p, new OpenOption[0]));
            }
        }
        catch (IOException e) {
            throw new InternalServerErrorResponse("Can't read file");
        }
    }
}

