/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.core.cpos.Belief;
import convex.core.cvm.Peer;
import convex.core.exceptions.TODOException;
import convex.core.util.LatestUpdateQueue;
import convex.core.util.LoadMonitor;
import convex.peer.AThreadedComponent;
import convex.peer.Server;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CVMExecutor
extends AThreadedComponent {
    private static final Logger log = LoggerFactory.getLogger((String)CVMExecutor.class.getName());
    private Peer peer;
    private Consumer<Peer> updateHook = null;
    private LatestUpdateQueue<Belief> update = new LatestUpdateQueue();

    public CVMExecutor(Server server) {
        super(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loop() throws InterruptedException {
        LoadMonitor.down();
        Belief beliefUpdate = (Belief)this.update.poll(100L, TimeUnit.MILLISECONDS);
        LoadMonitor.up();
        try {
            CVMExecutor cVMExecutor = this;
            synchronized (cVMExecutor) {
                Peer updatedPeer;
                if (beliefUpdate != null) {
                    this.peer = this.peer.updateBelief(beliefUpdate);
                }
                if ((updatedPeer = this.peer.updateState()) != this.peer) {
                    this.peer = updatedPeer;
                    this.persistPeerData();
                    this.maybeCallHook(this.peer);
                }
            }
            this.server.transactionHandler.maybeReportTransactions(this.peer);
        }
        catch (Exception e) {
            log.error("Fatal exception encountered in CVM Executor", (Throwable)e);
            this.server.close();
        }
    }

    public void syncPeer(Server base) {
        throw new TODOException();
    }

    public synchronized void recalcState(long pos) {
        this.peer = this.peer.recalcState(pos);
    }

    public synchronized void persistPeerData() throws IOException {
        this.peer = this.server.persistPeerData();
    }

    private void maybeCallHook(Peer p) {
        Consumer<Peer> hook = this.updateHook;
        if (hook == null) {
            return;
        }
        hook.accept(p);
    }

    @Override
    protected String getThreadName() {
        return "CVM Executor thread on port " + this.server.getPort();
    }

    public synchronized void setPeer(Peer peer) {
        this.peer = peer;
    }

    public Peer getPeer() {
        return this.peer;
    }

    public void queueUpdate(Belief belief) {
        this.update.offer((Object)belief);
    }

    public void setUpdateHook(Consumer<Peer> hook) {
        this.updateHook = hook;
    }
}

