/*
 * Decompiled with CFR 0.152.
 */
package convex.net.impl.netty;

import convex.core.data.ACell;
import convex.core.data.Vectors;
import convex.core.message.Message;
import convex.core.message.MessageType;
import convex.core.util.Shutdown;
import convex.net.AConnection;
import convex.net.impl.netty.NettyInboundHandler;
import convex.net.impl.netty.NettyOutboundHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConnection
extends AConnection {
    static final Logger log = LoggerFactory.getLogger((String)NettyConnection.class.getName());
    static EventLoopGroup workerGroup = null;
    static Bootstrap clientBootstrap = null;
    private Channel channel;
    private NettyInboundHandler inboundHandler;

    private NettyConnection(Channel channel, NettyInboundHandler inbound) {
        this.channel = channel;
        this.inboundHandler = inbound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static EventLoopGroup getEventLoopGroup() {
        if (workerGroup != null) {
            return workerGroup;
        }
        Class<NettyConnection> clazz = NettyConnection.class;
        synchronized (NettyConnection.class) {
            if (workerGroup != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return workerGroup;
            }
            workerGroup = new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
            Shutdown.addHook((int)90, () -> {
                if (workerGroup != null) {
                    workerGroup.shutdownGracefully();
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return workerGroup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Bootstrap getClientBootstrap() {
        if (clientBootstrap != null) {
            return clientBootstrap;
        }
        Class<NettyConnection> clazz = NettyConnection.class;
        synchronized (NettyConnection.class) {
            if (clientBootstrap != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return clientBootstrap;
            }
            Bootstrap b = new Bootstrap();
            b.group(NettyConnection.getEventLoopGroup());
            b.channel(NioSocketChannel.class);
            b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)8000);
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                }
            });
            clientBootstrap = b;
            // ** MonitorExit[var0] (shouldn't be in output)
            return clientBootstrap;
        }
    }

    public static NettyConnection connect(SocketAddress sa, Consumer<Message> receiveAction) throws InterruptedException, IOException {
        Bootstrap b = NettyConnection.getClientBootstrap();
        ChannelFuture f = b.connect(sa);
        f.await();
        if (!f.isSuccess()) {
            throw new IOException("Failed to connect to peer at " + String.valueOf(sa), f.cause());
        }
        Channel chan = f.channel();
        NettyInboundHandler inbound = new NettyInboundHandler(receiveAction, null);
        f.channel().pipeline().addLast(new ChannelHandler[]{inbound, new NettyOutboundHandler()});
        NettyConnection client = new NettyConnection(chan, inbound);
        return client;
    }

    protected ChannelFuture send(Message m) {
        return this.channel.writeAndFlush((Object)m);
    }

    public static void main(String ... args) throws Exception {
        NettyConnection client = NettyConnection.connect(new InetSocketAddress("localhost", 8000), m -> System.err.println("Client received:" + String.valueOf(m)));
        client.send(Message.create((MessageType)MessageType.QUERY, (ACell)Vectors.of((Object[])new Object[]{1, 2, 3, 4}))).sync();
    }

    @Override
    public boolean sendMessage(Message m) {
        ChannelFuture cf = this.channel.writeAndFlush((Object)m);
        return true;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        if (this.channel == null) {
            return null;
        }
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    @Override
    public boolean isClosed() {
        if (this.channel == null) {
            return true;
        }
        return !this.channel.isOpen();
    }

    @Override
    public void close() {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    @Override
    public long getReceivedCount() {
        return this.inboundHandler.getReceivedCount();
    }
}

