/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import convex.core.util.Utils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class IPUtils {
    public static InetAddress tryGetIP() throws InterruptedException {
        String s = IPUtils.tryGetWTF().trim();
        if (s != null) {
            try {
                InetAddress i = InetAddress.getByName(s);
                return i;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String tryGetWTF() throws InterruptedException {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder(URI.create("https://wtfismyip.com/text")).header("accept", "text/plain").build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String text = response.body();
            return text;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static InetSocketAddress toInetSocketAddress(Object o) {
        if (o instanceof InetSocketAddress) {
            return (InetSocketAddress)o;
        }
        if (o instanceof String) {
            return IPUtils.toInetSocketAddress((String)o);
        }
        if (o instanceof URL) {
            return IPUtils.toInetSocketAddress((URL)o);
        }
        if (o instanceof URI) {
            return IPUtils.toInetSocketAddress((URI)o);
        }
        return null;
    }

    public static InetSocketAddress toInetSocketAddress(String s) {
        if (s == null) {
            return null;
        }
        s = s.trim();
        try {
            URI uri = new URI(s);
            InetSocketAddress sa = IPUtils.toInetSocketAddress(uri);
            return sa;
        }
        catch (IllegalArgumentException | URISyntaxException ex) {
            int colon = s.lastIndexOf(58);
            if (colon < 0) {
                return null;
            }
            try {
                String hostName = s.substring(0, colon);
                int port = Utils.toInt((Object)s.substring(colon + 1));
                InetSocketAddress addr = new InetSocketAddress(hostName, port);
                return addr;
            }
            catch (SecurityException e) {
                throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
            }
        }
    }

    public static InetSocketAddress toInetSocketAddress(URL url) {
        String host = url.getHost();
        int port = url.getPort();
        if (port < 0) {
            port = 18888;
        }
        return new InetSocketAddress(host, port);
    }

    public static InetSocketAddress toInetSocketAddress(URI uri) {
        String host = uri.getHost();
        int port = uri.getPort();
        if (port < 0) {
            port = 18888;
        }
        return new InetSocketAddress(host, port);
    }

    public static void main(String[] args) throws InterruptedException {
        System.out.println(IPUtils.tryGetIP());
        System.out.println(IPUtils.tryGetIP());
    }

    public static InetSocketAddress parseAddress(String hostname, Integer port) {
        InetSocketAddress sa = IPUtils.toInetSocketAddress(hostname);
        if (sa != null) {
            if (port == null || sa.getPort() == port.intValue()) {
                return sa;
            }
            hostname = sa.getHostName();
        }
        if (port == null) {
            port = 18888;
        }
        return new InetSocketAddress(hostname, (int)port);
    }
}

