/*
 * Decompiled with CFR 0.152.
 */
package convex.api;

import convex.api.Convex;
import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.SourceCodes;
import convex.core.crypto.AKeyPair;
import convex.core.cvm.AccountStatus;
import convex.core.cvm.Address;
import convex.core.cvm.State;
import convex.core.cvm.transactions.ATransaction;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.exceptions.MissingDataException;
import convex.core.message.Message;
import convex.core.message.MessageType;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.util.ThreadUtils;
import convex.peer.Server;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

public class ConvexLocal
extends Convex {
    private final Server server;

    protected ConvexLocal(Server server, Address address, AKeyPair keyPair) {
        super(address, keyPair);
        this.server = server;
        this.preCompile = true;
    }

    public static ConvexLocal create(Server server) {
        return new ConvexLocal(server, null, null);
    }

    public static ConvexLocal create(Server server, Address address, AKeyPair keyPair) {
        return new ConvexLocal(server, address, keyPair);
    }

    @Override
    public boolean isConnected() {
        return this.server.isLive();
    }

    @Override
    public <T extends ACell> CompletableFuture<T> acquire(Hash hash, AStore store) {
        CompletableFuture f = new CompletableFuture();
        ThreadUtils.runVirtual(() -> {
            AStore peerStore = this.server.getStore();
            Ref ref = peerStore.refForHash(hash);
            if (ref == null) {
                f.completeExceptionally(new MissingDataException(peerStore, hash));
            } else {
                try {
                    ref = store.storeTopRef(ref, 3, null);
                }
                catch (IOException e) {
                    f.completeExceptionally(e);
                }
                f.complete(ref.getValue());
            }
        });
        return f;
    }

    @Override
    public CompletableFuture<Result> requestStatus() {
        return this.makeMessageFuture(Message.createStatusRequest((long)this.getNextID()));
    }

    @Override
    public CompletableFuture<Result> transact(SignedData<ATransaction> signed) {
        this.maybeUpdateSequence(signed);
        CompletableFuture<Result> r = this.makeMessageFuture(Message.createTransaction((long)this.getNextID(), signed));
        return r;
    }

    @Override
    public CompletableFuture<Result> requestChallenge(SignedData<ACell> data) {
        return this.makeMessageFuture(MessageType.CHALLENGE, (ACell)data);
    }

    @Override
    public CompletableFuture<Result> query(ACell query, Address address) {
        return this.makeMessageFuture(Message.createQuery((long)this.getNextID(), (ACell)query, (Address)address));
    }

    private CompletableFuture<Result> makeMessageFuture(MessageType type, ACell payload) {
        Message ml = Message.create((MessageType)type, (ACell)payload);
        return this.makeMessageFuture(ml);
    }

    private CompletableFuture<Result> makeMessageFuture(Message message) {
        if (!this.isConnected()) {
            Result r = Result.error((Keyword)ErrorCodes.CONNECT, (String)"Disconnected").withSource(SourceCodes.CLIENT);
            return CompletableFuture.completedFuture(r);
        }
        CompletableFuture<Result> cf = new CompletableFuture<Result>();
        Predicate<Message> resultHandler = this.makeResultHandler(cf);
        Message ml = message.withResultHandler(resultHandler);
        this.server.getReceiveAction().accept(ml);
        return cf;
    }

    private Predicate<Message> makeResultHandler(CompletableFuture<Result> cf) {
        AStore senderStore = Stores.current();
        return m -> {
            AStore savedStore = Stores.current();
            try {
                Stores.setCurrent((AStore)senderStore);
                Result r = m.toResult();
                if (r.getErrorCode() != null) {
                    this.sequence = null;
                }
                cf.complete(r);
                boolean bl = true;
                return bl;
            }
            finally {
                Stores.setCurrent((AStore)savedStore);
            }
        };
    }

    @Override
    public CompletableFuture<Result> messageRaw(Blob rawData) {
        try {
            Message m = Message.create((Blob)rawData);
            return this.message(m);
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture(Result.fromException((Throwable)e).withSource(SourceCodes.CLIENT));
        }
    }

    @Override
    public CompletableFuture<Result> message(Message message) {
        ACell id = message.getRequestID();
        if (id == null) {
            this.server.getReceiveAction().accept(message);
            return CompletableFuture.completedFuture(Result.SENT_MESSAGE);
        }
        return this.makeMessageFuture(message);
    }

    @Override
    public void close() {
    }

    @Override
    public CompletableFuture<State> acquireState() {
        return CompletableFuture.completedFuture(this.getState());
    }

    public State getState() {
        return this.server.getPeer().getConsensusState();
    }

    @Override
    public Server getLocalServer() {
        return this.server;
    }

    @Override
    public long getSequence() {
        if (this.sequence == null) {
            AccountStatus as = this.getState().getAccount(this.address);
            if (as == null) {
                return 0L;
            }
            this.sequence = as.getSequence();
        }
        return this.sequence;
    }

    @Override
    public long getSequence(Address addr) {
        if (Cells.equals((ACell)this.address, (ACell)addr)) {
            return this.getSequence();
        }
        return this.getState().getAccount(addr).getSequence();
    }

    @Override
    public String toString() {
        return "Local Convex instance on " + String.valueOf(this.server.getHostAddress());
    }

    @Override
    public InetSocketAddress getHostAddress() {
        return this.server.getHostAddress();
    }

    @Override
    public Long getBalance() {
        return this.server.getPeer().getConsensusState().getBalance(this.address);
    }

    @Override
    public void reconnect() {
    }
}

