/*
 * Decompiled with CFR 0.152.
 */
package convex.api;

import convex.api.ConvexLocal;
import convex.api.ConvexRemote;
import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.SourceCodes;
import convex.core.crypto.AKeyPair;
import convex.core.cvm.AccountStatus;
import convex.core.cvm.Address;
import convex.core.cvm.State;
import convex.core.cvm.Symbols;
import convex.core.cvm.ops.Special;
import convex.core.cvm.transactions.ATransaction;
import convex.core.cvm.transactions.Invoke;
import convex.core.cvm.transactions.Transfer;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AList;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.List;
import convex.core.data.Lists;
import convex.core.data.SignedData;
import convex.core.data.Symbol;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.ResultException;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.message.Message;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.util.Utils;
import convex.net.IPUtils;
import convex.peer.Server;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Convex
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger((String)Convex.class.getName());
    protected long timeout = 8000L;
    protected AKeyPair keyPair;
    protected Address address;
    private boolean autoSequence = true;
    protected boolean preCompile = false;
    protected Long sequence = null;
    protected long idCounter = 0L;

    protected Convex(Address address, AKeyPair keyPair) {
        this.keyPair = keyPair;
        this.address = address;
    }

    public static Convex connect(Object host) throws IOException, TimeoutException, InterruptedException {
        if (host instanceof Convex) {
            return (Convex)host;
        }
        if (host instanceof Server) {
            return Convex.connect((Server)host);
        }
        InetSocketAddress sa = IPUtils.toInetSocketAddress(host);
        if (sa == null) {
            throw new IllegalArgumentException("Unrecognised connect type " + Utils.getClassName((Object)host));
        }
        return Convex.connect(sa);
    }

    public static ConvexRemote connect(InetSocketAddress hostAddress) throws IOException, TimeoutException, InterruptedException {
        return Convex.connect(hostAddress, (Address)null, (AKeyPair)null);
    }

    public static ConvexRemote connect(InetSocketAddress peerAddress, Address address, AKeyPair keyPair) throws IOException, TimeoutException, InterruptedException {
        ConvexRemote convex = ConvexRemote.connect(peerAddress);
        convex.setAddress(address);
        convex.setKeyPair(keyPair);
        return convex;
    }

    protected long getNextID() {
        return this.idCounter++;
    }

    public synchronized void setAddress(Address address) {
        if (this.address == address) {
            return;
        }
        this.address = address;
        this.sequence = null;
    }

    public synchronized void setAddress(Address address, AKeyPair kp) {
        this.setAddress(address);
        this.setKeyPair(kp);
    }

    public synchronized void setKeyPair(AKeyPair kp) {
        this.keyPair = kp;
    }

    public void setNextSequence(long nextSequence) {
        this.sequence = nextSequence - 1L;
    }

    public long getSequence() throws ResultException, InterruptedException {
        if (this.sequence == null) {
            this.sequence = this.lookupSequence(this.getAddress());
        }
        return this.sequence;
    }

    public long getSequence(Address addr) throws InterruptedException, ResultException {
        if (Cells.equals((ACell)this.getAddress(), (ACell)addr)) {
            return this.getSequence();
        }
        return this.lookupSequence(addr);
    }

    public long lookupSequence(Address origin) throws InterruptedException, ResultException {
        Special code = Special.forSymbol((Symbol)Symbols.STAR_SEQUENCE);
        Result r = this.querySync((ACell)code, origin);
        if (r.isError()) {
            throw new ResultException(r);
        }
        ACell rv = r.getValue();
        if (!(rv instanceof CVMLong)) {
            throw new ResultException(ErrorCodes.FORMAT, "Unexpected sequence result type: " + Utils.getClassName((Object)rv));
        }
        long seq = ((CVMLong)rv).longValue();
        return seq;
    }

    protected void maybeUpdateSequence(SignedData<ATransaction> signed) {
        try {
            ATransaction trans = (ATransaction)signed.getValue();
            if (!this.isAutoSequence()) {
                return;
            }
            if (!Cells.equals((ACell)trans.getOrigin(), (ACell)this.address)) {
                return;
            }
            Long seq = this.sequence;
            if (seq == null) {
                return;
            }
            Long l = seq;
            seq = seq + 1L;
            if (seq.longValue() == trans.getSequence()) {
                this.sequence = seq;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T extends ACell> SignedData<T> signData(T value) {
        return this.keyPair.signData(value);
    }

    public Address createAccountSync(AccountKey publicKey) throws InterruptedException, ResultException {
        Address address;
        try {
            address = this.createAccount(publicKey).get();
        }
        catch (ExecutionException e) {
            throw new ResultException(Result.fromException((Throwable)e));
        }
        return address;
    }

    public CompletableFuture<Address> createAccount(AccountKey publicKey) {
        Invoke trans = Invoke.create((Address)this.address, (long)0L, (ACell)Lists.of((Object[])new Object[]{Symbols.CREATE_ACCOUNT, publicKey}));
        CompletableFuture<Result> fr = this.transact((ATransaction)trans);
        return fr.thenCompose(r -> {
            if (r.isError()) {
                return CompletableFuture.failedFuture((Throwable)new ResultException(r));
            }
            ACell a = r.getValue();
            return CompletableFuture.completedFuture((Address)a);
        });
    }

    public abstract boolean isConnected();

    private synchronized long getNextSequence(ATransaction t) throws ResultException, InterruptedException {
        if (this.sequence != null) {
            return this.sequence + 1L;
        }
        return this.getSequence() + 1L;
    }

    public CompletableFuture<Result> preCompile(ACell code) {
        List compileStep = List.of((Object[])new Object[]{Symbols.COMPILE, List.of((Object[])new Object[]{Symbols.QUOTE, code})});
        return this.query((ACell)compileStep);
    }

    public final synchronized CompletableFuture<Result> transact(ATransaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("null transaction");
        }
        try {
            SignedData<ATransaction> signed = this.prepareTransaction(transaction);
            CompletableFuture<Result> r = this.transact(signed);
            return r;
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture(Result.fromException((Throwable)e));
        }
    }

    public SignedData<ATransaction> prepareTransaction(ACell code) throws ResultException, InterruptedException {
        ATransaction transaction;
        if (code instanceof ATransaction) {
            transaction = (ATransaction)code;
        } else {
            if (code instanceof SignedData) {
                SignedData signed = (SignedData)code;
                ACell val = signed.getValue();
                if (val instanceof ATransaction) {
                    return signed;
                }
                code = val;
            }
            if (this.isPreCompile()) {
                Result compResult = this.preCompile(code).join();
                if (compResult.isError()) {
                    throw new ResultException(compResult);
                }
                code = compResult.getValue();
            }
            if (this.address == null) {
                throw new ResultException(Result.error((Keyword)ErrorCodes.STATE, (String)"No origin address for transaction"));
            }
            transaction = Invoke.create((Address)this.address, (long)0L, (ACell)code);
        }
        return this.prepareTransaction(transaction);
    }

    public SignedData<ATransaction> prepareTransaction(ATransaction transaction) throws ResultException, InterruptedException {
        long originalSeq;
        Address origin = transaction.getOrigin();
        if (origin == null) {
            origin = this.address;
            if (origin == null) {
                throw new ResultException(Result.error((Keyword)ErrorCodes.NOBODY, (String)"No address set for transaction").withSource(SourceCodes.CLIENT));
            }
            transaction = transaction.withOrigin(origin);
        }
        long seq = originalSeq = transaction.getSequence();
        if (this.autoSequence || originalSeq <= 0L) {
            if (seq <= 0L && Cells.equals((ACell)origin, (ACell)this.address)) {
                seq = this.getNextSequence(transaction);
            }
            if (this.sequence != null) {
                seq = this.sequence + 1L;
            } else {
                long expected;
                State state;
                AccountStatus as;
                Server s = this.getLocalServer();
                if (s != null && (as = (state = s.getPeer().getConsensusState()).getAccount(origin)) != null && (expected = as.getSequence() + 1L) > seq) {
                    seq = expected;
                }
            }
        }
        if (seq <= 0L) {
            seq = this.lookupSequence(origin);
        }
        if (seq != originalSeq) {
            transaction = transaction.withSequence(seq);
        }
        if (Cells.equals((ACell)origin, (ACell)this.address)) {
            this.sequence = seq;
        }
        if (this.keyPair == null) {
            throw new ResultException(Result.error((Keyword)ErrorCodes.SIGNATURE, (String)"No key pair set"));
        }
        SignedData signed = this.keyPair.signData((ACell)transaction);
        return signed;
    }

    public CompletableFuture<Result> transact(String code) {
        ACell cmd = this.buildCodeForm(code);
        return this.transact(cmd);
    }

    public synchronized CompletableFuture<Result> transact(ACell code) {
        if (code instanceof ATransaction) {
            return this.transact((ATransaction)code);
        }
        if (this.isPreCompile()) {
            return this.preCompile(code).thenCompose(r -> {
                if (r.isError()) {
                    return CompletableFuture.completedFuture(r);
                }
                ACell compiledCode = r.getValue();
                Invoke trans = Invoke.create((Address)this.getAddress(), (long)0L, (ACell)compiledCode);
                return this.transact((ATransaction)trans);
            });
        }
        Invoke trans = Invoke.create((Address)this.getAddress(), (long)0L, (ACell)code);
        return this.transact((ATransaction)trans);
    }

    private ACell buildCodeForm(String code) {
        AList forms = Reader.readAll((String)code);
        Object form = forms.count() == 1L ? forms.get(0) : forms.cons((ACell)Symbols.DO);
        return form;
    }

    public synchronized Result transactSync(String code) throws InterruptedException {
        ACell form = this.buildCodeForm(code);
        Invoke trans = Invoke.create((Address)this.getAddress(), (long)0L, (ACell)form);
        return this.transactSync((ACell)trans);
    }

    public abstract CompletableFuture<Result> transact(SignedData<ATransaction> var1);

    public CompletableFuture<Result> transfer(Address target, long amount) {
        Transfer trans = Transfer.create((Address)this.getAddress(), (long)0L, (Address)target, (long)amount);
        return this.transact((ATransaction)trans);
    }

    public Result transferSync(Address target, long amount) throws InterruptedException {
        Transfer trans = Transfer.create((Address)this.getAddress(), (long)0L, (Address)target, (long)amount);
        return this.transactSync((ACell)trans);
    }

    public Result transactSync(SignedData<ATransaction> transaction) throws InterruptedException {
        return this.transactSync(transaction, this.timeout);
    }

    public final Result transactSync(ACell transaction) throws InterruptedException {
        return this.transactSync(transaction, this.timeout);
    }

    public final Result transactSync(ACell transaction, long timeout) throws InterruptedException {
        long start = Utils.getTimeMillis();
        CompletableFuture<Result> cf = this.transact(transaction);
        long now = Utils.getTimeMillis();
        timeout = Math.max(0L, timeout - (now - start));
        try {
            Result result = (Result)cf.get(timeout, TimeUnit.MILLISECONDS);
            if (result.getErrorCode() != null) {
                this.sequence = null;
            }
            return result;
        }
        catch (ExecutionException | TimeoutException e) {
            return Result.fromException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result transactSync(SignedData<ATransaction> signedTransaction, long timeout) throws InterruptedException {
        long start = Utils.getTimeMillis();
        CompletableFuture<Result> cf = this.transact(signedTransaction);
        long now = Utils.getTimeMillis();
        timeout = Math.max(0L, timeout - (now - start));
        try {
            Result result;
            Result result2 = result = (Result)cf.get(timeout, TimeUnit.MILLISECONDS);
            return result2;
        }
        catch (ExecutionException | TimeoutException e) {
            Result result = Result.fromException((Throwable)e);
            return result;
        }
        finally {
            cf.cancel(true);
        }
    }

    public CompletableFuture<Result> query(ACell query) {
        return this.query(query, this.getAddress());
    }

    public CompletableFuture<Result> query(String query) {
        ACell form = this.buildCodeForm(query);
        return this.query(form, this.getAddress());
    }

    public abstract CompletableFuture<Result> messageRaw(Blob var1);

    public abstract CompletableFuture<Result> message(Message var1);

    public CompletableFuture<ACell> resolve(String cnsName) {
        ACell form = this.buildCodeForm("(resolve " + cnsName + ")");
        return this.query(form).thenApply(r -> {
            if (r.isError()) {
                throw new RuntimeException("Resolve failed " + String.valueOf(r));
            }
            return r.getValue();
        });
    }

    public <T extends ACell> CompletableFuture<T> acquire(Hash hash) {
        return this.acquire(hash, Stores.current());
    }

    public abstract <T extends ACell> CompletableFuture<T> acquire(Hash var1, AStore var2);

    public Result requestStatusSync(long timeoutMillis) throws InterruptedException {
        CompletableFuture<Result> statusFuture = this.requestStatus();
        try {
            return statusFuture.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            return Result.fromException((Throwable)e);
        }
    }

    public Result requestStatusSync() throws InterruptedException {
        return this.requestStatusSync(this.getTimeout());
    }

    protected long getTimeout() {
        return this.timeout;
    }

    public abstract CompletableFuture<Result> requestStatus();

    public abstract CompletableFuture<Result> requestChallenge(SignedData<ACell> var1);

    public abstract CompletableFuture<Result> query(ACell var1, Address var2);

    public Result querySync(ACell query) throws InterruptedException {
        return this.querySync(query, this.getAddress());
    }

    public Result querySync(String query) throws InterruptedException {
        ACell form = this.buildCodeForm(query);
        return this.querySync(form, this.getAddress());
    }

    public Result querySync(ACell query, Address address) throws InterruptedException {
        return this.querySync(query, address, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result querySync(ACell query, Address address, long timeoutMillis) throws InterruptedException {
        Result result;
        CompletableFuture<Result> cf = this.query(query, address);
        try {
            result = (Result)cf.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            Result result2 = Result.fromException((Throwable)e);
            return result2;
        }
        finally {
            cf.cancel(true);
        }
        return result;
    }

    public AccountKey getAccountKey() {
        if (this.keyPair == null) {
            return null;
        }
        return this.keyPair.getAccountKey();
    }

    public AccountKey getAccountKey(Address a) throws InterruptedException {
        if (a == null) {
            return null;
        }
        Result r = this.querySync(Reader.read((String)("(:key (account " + String.valueOf(a) + "))")));
        if (r.isError()) {
            return null;
        }
        ABlob b = RT.ensureBlob((ACell)r.getValue());
        return AccountKey.create((ABlob)b);
    }

    public Address getAddress() {
        return this.address;
    }

    @Override
    public abstract void close();

    public void finalize() {
        this.close();
    }

    protected boolean isAutoSequence() {
        return this.autoSequence;
    }

    protected void setAutoSequence(boolean autoSequence) {
        this.autoSequence = autoSequence;
    }

    public Long getBalance() throws ResultException {
        Address a = this.getAddress();
        if (a == null) {
            throw new IllegalStateException("No address set for balance query");
        }
        return this.getBalance(a);
    }

    public Long getBalance(Address address) throws ResultException {
        try {
            Object code = Utils.equals((ACell)this.address, (ACell)address) ? Special.forSymbol((Symbol)Symbols.STAR_BALANCE) : Lists.of((Object[])new Object[]{Symbols.BALANCE, address});
            CompletableFuture<Result> future = this.query((ACell)code);
            Result result = (Result)future.get(this.timeout, TimeUnit.MILLISECONDS);
            if (result.isError()) {
                throw new ResultException(result);
            }
            CVMLong bal = (CVMLong)result.getValue();
            return bal.longValue();
        }
        catch (Exception ex) {
            throw new ResultException(ex);
        }
    }

    public static ConvexLocal connect(Server server, Address address, AKeyPair keyPair) {
        return ConvexLocal.create(server, address, keyPair);
    }

    public static ConvexLocal connect(Server server) {
        ConvexLocal convex = ConvexLocal.create(server, null, null);
        return convex;
    }

    public CompletableFuture<State> acquireState() {
        AStore store = Stores.current();
        return this.requestStatus().thenCompose(status -> {
            Hash stateHash = RT.ensureHash((ACell)status.get(4L));
            if (stateHash == null) {
                return CompletableFuture.failedStage((Throwable)new ResultException(ErrorCodes.FORMAT, "Bad status response from Peer"));
            }
            return this.acquire(stateHash, store);
        });
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public abstract String toString();

    public AKeyPair getKeyPair() {
        return this.keyPair;
    }

    public Server getLocalServer() {
        return null;
    }

    public abstract InetSocketAddress getHostAddress();

    public boolean isPreCompile() {
        return this.preCompile;
    }

    public void setPreCompile(boolean preCompile) {
        this.preCompile = preCompile;
    }

    public void clearSequence() {
        this.sequence = null;
    }

    public abstract void reconnect() throws IOException, TimeoutException, InterruptedException;
}

