/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSender {
    public static final int SEND_BUFFER_SIZE = 81930;
    private final ByteChannel channel;
    private final ByteBuffer buffer = ByteBuffer.allocate(81930).flip();
    protected static final Logger log = LoggerFactory.getLogger((String)MessageSender.class.getName());

    public MessageSender(ByteChannel channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bufferMessage(ByteBuffer messageFrame) {
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            this.buffer.compact();
            if (this.buffer.remaining() < messageFrame.remaining()) {
                this.buffer.flip();
                return false;
            }
            this.buffer.put(messageFrame);
            this.buffer.flip();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean maybeSendBytes() throws IOException {
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            if (!this.buffer.hasRemaining()) {
                return true;
            }
            this.channel.write(this.buffer);
            if (this.buffer.hasRemaining()) {
                log.debug("Send buffer full!");
                return false;
            }
            return true;
        }
    }
}

