/*
 * Decompiled with CFR 0.152.
 */
package convex.api;

import convex.api.Convex;
import convex.core.Result;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.Address;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.MissingDataException;
import convex.core.store.AStore;
import convex.core.transactions.ATransaction;
import convex.net.MessageType;
import convex.net.message.MessageLocal;
import convex.peer.Server;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class ConvexLocal
extends Convex {
    private final Server server;
    private long idCounter = 0L;

    protected ConvexLocal(Server server, Address address, AKeyPair keyPair) {
        super(address, keyPair);
        this.server = server;
    }

    public static ConvexLocal create(Server server, Address address, AKeyPair keyPair) {
        return new ConvexLocal(server, address, keyPair);
    }

    @Override
    public boolean isConnected() {
        return this.server.isLive();
    }

    @Override
    public <T extends ACell> CompletableFuture<T> acquire(final Hash hash, final AStore store) {
        final CompletableFuture f = new CompletableFuture();
        new Thread(new Runnable(){

            @Override
            public void run() {
                AStore remoteStore = ConvexLocal.this.server.getStore();
                Ref ref = remoteStore.refForHash(hash);
                if (ref == null) {
                    f.completeExceptionally((Throwable)new MissingDataException(remoteStore, hash));
                } else {
                    ref = store.storeTopRef(ref, 2, null);
                    f.complete(ref.getValue());
                }
            }
        }).run();
        return f;
    }

    @Override
    public CompletableFuture<Result> requestStatus() {
        return this.makeMessageFuture(MessageType.STATUS, (ACell)CVMLong.create((long)this.makeID()));
    }

    @Override
    public CompletableFuture<Result> transact(SignedData<ATransaction> signed) {
        return this.makeMessageFuture(MessageType.TRANSACT, (ACell)Vectors.of((Object[])new Object[]{this.makeID(), signed}));
    }

    @Override
    public CompletableFuture<Result> requestChallenge(SignedData<ACell> data) {
        return this.makeMessageFuture(MessageType.CHALLENGE, (ACell)data);
    }

    @Override
    public CompletableFuture<Result> query(ACell query, Address address) {
        return this.makeMessageFuture(MessageType.QUERY, (ACell)Vectors.of((Object[])new Object[]{this.makeID(), query, address}));
    }

    private long makeID() {
        return this.idCounter++;
    }

    private CompletableFuture<Result> makeMessageFuture(MessageType type, ACell payload) {
        CompletableFuture<Result> cf = new CompletableFuture<Result>();
        Consumer<Result> resultHandler = this.makeResultHandler(cf);
        MessageLocal ml = MessageLocal.create(type, payload, this.server, resultHandler);
        try {
            this.server.queueMessage(ml);
        }
        catch (InterruptedException e) {
            cf.completeExceptionally(e);
        }
        return cf;
    }

    private Consumer<Result> makeResultHandler(CompletableFuture<Result> cf) {
        return r -> cf.complete((Result)r);
    }

    @Override
    public void close() {
    }

    @Override
    public CompletableFuture<State> acquireState() throws TimeoutException {
        return CompletableFuture.completedFuture(this.server.getPeer().getConsensusState());
    }
}

