/*
 * Decompiled with CFR 0.152.
 */
package convex.api;

import convex.api.ConvexLocal;
import convex.api.ConvexRemote;
import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.AList;
import convex.core.data.AccountKey;
import convex.core.data.Address;
import convex.core.data.Hash;
import convex.core.data.Lists;
import convex.core.data.SignedData;
import convex.core.data.Symbol;
import convex.core.data.prim.CVMLong;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.lang.Symbols;
import convex.core.lang.ops.Special;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Invoke;
import convex.core.transactions.Transfer;
import convex.core.util.Utils;
import convex.net.ResultConsumer;
import convex.net.message.Message;
import convex.peer.Server;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Convex {
    private static final Logger log = LoggerFactory.getLogger((String)Convex.class.getName());
    protected long timeout = 6000L;
    protected AKeyPair keyPair;
    protected Address address;
    private boolean autoSequence = true;
    protected Long sequence = null;
    protected HashMap<Long, CompletableFuture<Result>> awaiting = new HashMap();
    protected final Consumer<Message> internalHandler = new ResultConsumer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized void handleResult(long id, Result v) {
            if (v != null && ErrorCodes.SEQUENCE.equals(v.getErrorCode())) {
                Convex.this.sequence = null;
            }
            HashMap<Long, CompletableFuture<Result>> hashMap = Convex.this.awaiting;
            synchronized (hashMap) {
                CompletableFuture<Result> cf = Convex.this.awaiting.get(id);
                if (cf != null) {
                    Convex.this.awaiting.remove(id);
                    cf.complete(v);
                    log.debug("Completed Result received for message ID: {}", (Object)id);
                } else {
                    log.warn("Ignored Result received for unexpected message ID: {}", (Object)id);
                }
            }
        }

        @Override
        public void accept(Message m) {
            super.accept(m);
            if (Convex.this.delegatedHandler != null) {
                try {
                    Convex.this.delegatedHandler.accept(m);
                }
                catch (Throwable t) {
                    log.warn("Exception thrown in user-supplied handler function: {}", t);
                }
            }
        }
    };
    private Consumer<Message> delegatedHandler = null;

    protected Convex(Address address, AKeyPair keyPair) {
        this.keyPair = keyPair;
        this.address = address;
    }

    public static ConvexRemote connect(InetSocketAddress hostAddress) throws IOException, TimeoutException {
        return Convex.connect(hostAddress, (Address)null, (AKeyPair)null);
    }

    public static ConvexRemote connect(InetSocketAddress peerAddress, Address address, AKeyPair keyPair) throws IOException, TimeoutException {
        return Convex.connect(peerAddress, address, keyPair, Stores.current());
    }

    public static ConvexRemote connectRemote(Server server) throws IOException, TimeoutException {
        return Convex.connect(server.getHostAddress(), server.getPeerController(), server.getKeyPair());
    }

    public static ConvexRemote connect(InetSocketAddress peerAddress, Address address, AKeyPair keyPair, AStore store) throws IOException, TimeoutException {
        ConvexRemote convex = new ConvexRemote(address, keyPair);
        convex.connectToPeer(peerAddress, store);
        return convex;
    }

    public synchronized void setAddress(Address address) {
        if (this.address == address) {
            return;
        }
        this.address = address;
        this.sequence = null;
    }

    public synchronized void setAddress(Address addr, AKeyPair kp) {
        this.setAddress(addr);
        this.setKeyPair(kp);
    }

    public synchronized void setKeyPair(AKeyPair kp) {
        this.keyPair = kp;
    }

    private long getIncrementedSequence() {
        long next = this.getSequence() + 1L;
        this.sequence = next;
        return next;
    }

    public void setNextSequence(long nextSequence) {
        this.sequence = nextSequence - 1L;
    }

    public void setHandler(Consumer<Message> handler) {
        this.delegatedHandler = handler;
    }

    public long getSequence() {
        if (this.sequence == null) {
            try {
                CompletableFuture<Result> f = this.query((ACell)Special.forSymbol((Symbol)Symbols.STAR_SEQUENCE));
                Result r = (Result)f.get();
                if (r.isError()) {
                    throw new Error("Error querying *sequence*: " + r.getErrorCode() + " " + r.getValue());
                }
                ACell result = r.getValue();
                if (!(result instanceof CVMLong)) {
                    throw new Error("*sequence* query did not return Long, got: " + result);
                }
                this.sequence = (Long)RT.jvm((ACell)result);
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw new Error("Error trying to get sequence number", e);
            }
        }
        return this.sequence;
    }

    public <T extends ACell> SignedData<T> signData(T value) {
        return this.keyPair.signData(value);
    }

    public Address createAccountSync(AccountKey publicKey) throws TimeoutException, IOException {
        Invoke trans = Invoke.create((Address)this.address, (long)0L, (ACell)Lists.of((Object[])new Object[]{Symbols.CREATE_ACCOUNT, publicKey}));
        Result r = this.transactSync((ATransaction)trans);
        if (r.isError()) {
            throw new Error("Error creating account: " + r.getErrorCode() + " " + r.getValue());
        }
        return (Address)r.getValue();
    }

    public CompletableFuture<Address> createAccount(AccountKey publicKey) throws TimeoutException, IOException {
        Invoke trans = Invoke.create((Address)this.address, (long)0L, (ACell)Lists.of((Object[])new Object[]{Symbols.CREATE_ACCOUNT, publicKey}));
        CompletableFuture<Result> fr = this.transact((ATransaction)trans);
        return fr.thenApply(r -> (Address)r.getValue());
    }

    public abstract boolean isConnected();

    private synchronized ATransaction applyNextSequence(ATransaction t) {
        if (this.sequence != null) {
            this.sequence = this.sequence + 1L;
            return t.withSequence(this.sequence.longValue());
        }
        return t.withSequence(this.getIncrementedSequence());
    }

    public synchronized CompletableFuture<Result> transact(ATransaction transaction) throws IOException {
        if (transaction.getAddress() == null) {
            transaction = transaction.withAddress(this.address);
        }
        if (this.autoSequence && transaction.getSequence() <= 0L && Utils.equals((ACell)transaction.getAddress(), (ACell)this.address)) {
            transaction = this.applyNextSequence(transaction);
        }
        SignedData signed = this.keyPair.signData((ACell)transaction);
        return this.transact((SignedData<ATransaction>)signed);
    }

    public synchronized CompletableFuture<Result> transact(String code) throws IOException {
        ATransaction trans = this.buildTransaction(code);
        return this.transact(trans);
    }

    private ATransaction buildTransaction(String code) {
        ACell form = this.buildCodeForm(code);
        return Invoke.create((Address)this.getAddress(), (long)this.getIncrementedSequence(), (ACell)form);
    }

    private ACell buildCodeForm(String code) {
        AList forms = Reader.readAll((String)code);
        Object form = forms.count() == 1L ? forms.get(0) : forms.cons((ACell)Symbols.DO);
        return form;
    }

    public synchronized Result transactSync(String code) throws IOException, TimeoutException {
        ATransaction trans = this.buildTransaction(code);
        return this.transactSync(trans);
    }

    public abstract CompletableFuture<Result> transact(SignedData<ATransaction> var1) throws IOException;

    public CompletableFuture<Result> transfer(Address target, long amount) throws IOException {
        Transfer trans = Transfer.create((Address)this.getAddress(), (long)0L, (Address)target, (long)amount);
        return this.transact((ATransaction)trans);
    }

    public Result transferSync(Address target, long amount) throws IOException, TimeoutException {
        Transfer trans = Transfer.create((Address)this.getAddress(), (long)0L, (Address)target, (long)amount);
        return this.transactSync((ATransaction)trans);
    }

    public Result transactSync(SignedData<ATransaction> transaction) throws TimeoutException, IOException {
        return this.transactSync(transaction, this.timeout);
    }

    public Result transactSync(ATransaction transaction) throws TimeoutException, IOException {
        return this.transactSync(transaction, this.timeout);
    }

    public Result transactSync(ATransaction transaction, long timeout) throws TimeoutException, IOException {
        Result result;
        long start = Utils.getTimeMillis();
        CompletableFuture<Result> cf = this.transact(transaction);
        long now = Utils.getTimeMillis();
        timeout = Math.max(0L, timeout - (now - start));
        try {
            result = (Result)cf.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new Error("Not possible? Since there is no Thread for the future....", e);
        }
        return result;
    }

    public Result transactSync(SignedData<ATransaction> transaction, long timeout) throws TimeoutException, IOException {
        Result result;
        long start = Utils.getTimeMillis();
        CompletableFuture<Result> cf = this.transact(transaction);
        long now = Utils.getTimeMillis();
        timeout = Math.max(0L, timeout - (now - start));
        try {
            result = (Result)cf.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new Error("Not possible? Since there is no Thread for the future....", e);
        }
        return result;
    }

    public CompletableFuture<Result> query(ACell query) throws IOException {
        return this.query(query, this.getAddress());
    }

    public CompletableFuture<Result> query(String query) throws IOException {
        ACell form = this.buildCodeForm(query);
        return this.query(form, this.getAddress());
    }

    public <T extends ACell> CompletableFuture<T> acquire(Hash hash) {
        return this.acquire(hash, Stores.current());
    }

    public abstract <T extends ACell> CompletableFuture<T> acquire(Hash var1, AStore var2);

    public Result requestStatusSync(long timeoutMillis) throws IOException, TimeoutException {
        CompletableFuture<Result> statusFuture = this.requestStatus();
        try {
            return (Result)statusFuture.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new Error("Unable to get network status ", e);
        }
    }

    public abstract CompletableFuture<Result> requestStatus();

    protected CompletableFuture<Result> awaitResult(long id) {
        CompletableFuture<Result> cf = new CompletableFuture<Result>();
        this.awaiting.put(id, cf);
        return cf;
    }

    public abstract CompletableFuture<Result> requestChallenge(SignedData<ACell> var1) throws IOException;

    public abstract CompletableFuture<Result> query(ACell var1, Address var2) throws IOException;

    public Result querySync(ACell query) throws TimeoutException, IOException {
        return this.querySync(query, this.getAddress());
    }

    public Result querySync(String query) throws TimeoutException, IOException {
        ACell form = this.buildCodeForm(query);
        return this.querySync(form, this.getAddress());
    }

    public Result querySync(ACell query, long timeoutMillis) throws IOException, TimeoutException {
        return this.querySync(query, this.getAddress(), timeoutMillis);
    }

    public Result querySync(ACell query, Address address) throws IOException, TimeoutException {
        return this.querySync(query, address, this.timeout);
    }

    public Result querySync(ACell query, Address address, long timeoutMillis) throws TimeoutException, IOException {
        Result result;
        CompletableFuture<Result> cf = this.query(query, address);
        try {
            result = (Result)cf.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new Error("Not possible? Since there is no Thread for the future....", e);
        }
        return result;
    }

    public AccountKey getAccountKey() {
        return this.keyPair.getAccountKey();
    }

    public Address getAddress() {
        return this.address;
    }

    public abstract void close();

    public void finalize() {
        this.close();
    }

    protected boolean isAutoSequence() {
        return this.autoSequence;
    }

    protected void setAutoSequence(boolean autoSequence) {
        this.autoSequence = autoSequence;
    }

    public Long getBalance(Address address) throws IOException {
        try {
            CompletableFuture<Result> future = this.query((ACell)Lists.of((Object[])new Object[]{Symbols.BALANCE, address}));
            Result result = (Result)future.get(this.timeout, TimeUnit.MILLISECONDS);
            if (result.isError()) {
                throw new Error(result.toString());
            }
            CVMLong bal = (CVMLong)result.getValue();
            return bal.longValue();
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            throw new IOException("Unable to query balance", ex);
        }
    }

    public static ConvexLocal connect(Server server, Address address, AKeyPair keyPair) {
        return ConvexLocal.create(server, address, keyPair);
    }

    public abstract CompletableFuture<State> acquireState() throws TimeoutException;
}

