/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.core.Belief;
import convex.core.Peer;
import convex.core.util.LatestUpdateQueue;
import convex.core.util.LoadMonitor;
import convex.peer.AThreadedComponent;
import convex.peer.Server;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CVMExecutor
extends AThreadedComponent {
    private static final Logger log = LoggerFactory.getLogger((String)CVMExecutor.class.getName());
    private Peer peer;
    private Consumer<Peer> updateHook = null;
    private LatestUpdateQueue<Belief> update = new LatestUpdateQueue();

    public CVMExecutor(Server server) {
        super(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loop() throws InterruptedException {
        LoadMonitor.down();
        Belief beliefUpdate = (Belief)this.update.poll(100L, TimeUnit.MILLISECONDS);
        LoadMonitor.up();
        CVMExecutor cVMExecutor = this;
        synchronized (cVMExecutor) {
            Peer updatedPeer;
            if (beliefUpdate != null) {
                this.peer = this.peer.updateBelief(beliefUpdate);
            }
            if ((updatedPeer = this.peer.updateState()) != this.peer) {
                this.peer = updatedPeer;
                try {
                    this.persistPeerData();
                }
                catch (IOException e) {
                    log.debug("IO Exception (" + e.getMessage() + ") while persisting peer data", (Throwable)e);
                    throw new InterruptedException("IO Exception while persisting peer data");
                }
                this.maybeCallHook(this.peer);
            }
        }
        this.server.transactionHandler.maybeReportTransactions(this.peer);
    }

    public synchronized void persistPeerData() throws IOException {
        this.peer = this.server.persistPeerData();
    }

    private void maybeCallHook(Peer p) {
        Consumer<Peer> hook = this.updateHook;
        if (hook == null) {
            return;
        }
        try {
            hook.accept(p);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected String getThreadName() {
        return "CVM Executor thread on port " + this.server.getPort();
    }

    public synchronized void setPeer(Peer peer) {
        this.peer = peer;
    }

    public Peer getPeer() {
        return this.peer;
    }

    public void queueUpdate(Belief belief) {
        this.update.offer((Object)belief);
    }

    public void setUpdateHook(Consumer<Peer> hook) {
        this.updateHook = hook;
    }
}

