/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSender {
    private final ByteChannel channel;
    private ByteBuffer buffer = null;
    protected static final Logger log = LoggerFactory.getLogger((String)MessageSender.class.getName());

    public MessageSender(ByteChannel channel) {
        this.channel = channel;
    }

    public synchronized boolean bufferMessage(ByteBuffer messageFrame) throws IOException {
        if (this.buffer != null) {
            return false;
        }
        this.buffer = messageFrame;
        this.maybeSendBytes();
        return true;
    }

    public synchronized boolean maybeSendBytes() throws IOException {
        if (this.buffer == null) {
            return true;
        }
        if (!this.buffer.hasRemaining()) {
            this.buffer = null;
            return true;
        }
        this.channel.write(this.buffer);
        if (this.buffer.hasRemaining()) {
            return false;
        }
        this.buffer = null;
        return true;
    }

    public boolean canSendMessage() {
        return this.buffer == null;
    }
}

