/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import convex.core.Belief;
import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.MissingDataException;
import convex.core.lang.RT;
import convex.core.store.AStore;
import convex.net.Connection;
import convex.net.MessageType;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message {
    protected static final Logger log = LoggerFactory.getLogger((String)Message.class.getName());
    protected ACell payload;
    protected Blob messageData;
    protected MessageType type;
    protected Predicate<Message> returnHandler;

    protected Message(MessageType type, ACell payload, Blob data, Predicate<Message> handler) {
        this.type = type;
        this.messageData = data;
        this.payload = payload;
        this.returnHandler = handler;
    }

    public static Message create(Connection conn, MessageType type, Blob data) {
        Predicate<Message> handler = conn::sendMessage;
        return new Message(type, null, data, handler);
    }

    public static Message create(MessageType type, ACell payload) {
        return new Message(type, payload, null, null);
    }

    public static Message create(MessageType type, ACell payload, Blob data) {
        return new Message(type, payload, data, null);
    }

    public static Message createDataResponse(CVMLong id, ACell ... cells) {
        int n = cells.length;
        ACell[] cs = new ACell[n + 1];
        cs[0] = id;
        for (int i = 0; i < n; ++i) {
            cs[i + 1] = cells[i];
        }
        return Message.create(MessageType.DATA, (ACell)Vectors.create((ACell[])cs));
    }

    public static Message createDataRequest(CVMLong id, Hash ... hashes) {
        int n = hashes.length;
        ACell[] cs = new ACell[n + 1];
        cs[0] = id;
        for (int i = 0; i < n; ++i) {
            cs[i + 1] = hashes[i];
        }
        return Message.create(MessageType.REQUEST_DATA, (ACell)Vectors.create((ACell[])cs));
    }

    public static Message createBelief(Belief belief) {
        return Message.create(MessageType.BELIEF, (ACell)belief);
    }

    public static Message createBeliefRequest() {
        return Message.create(MessageType.REQUEST_BELIEF, null);
    }

    public static Message createChallenge(SignedData<ACell> challenge) {
        return Message.create(MessageType.CHALLENGE, challenge);
    }

    public static Message createResponse(SignedData<ACell> response) {
        return Message.create(MessageType.RESPONSE, response);
    }

    public static Message createGoodBye() {
        return Message.create(MessageType.GOODBYE, null);
    }

    public <T extends ACell> T getPayload() throws BadFormatException {
        if (this.payload != null) {
            return (T)this.payload;
        }
        if (this.messageData == null) {
            return null;
        }
        if (this.messageData.count() == 1L && this.messageData.byteAt(0L) == 0) {
            return null;
        }
        switch (this.type) {
            case DATA: {
                ACell[] cells = Format.decodeCells((Blob)this.messageData);
                this.payload = Vectors.create((ACell[])cells);
                break;
            }
            default: {
                this.payload = Format.decodeMultiCell((Blob)this.messageData);
            }
        }
        return (T)this.payload;
    }

    public Blob getMessageData() {
        if (this.messageData != null) {
            return this.messageData;
        }
        switch (this.type) {
            case RESULT: 
            case QUERY: 
            case TRANSACT: 
            case REQUEST_DATA: {
                this.messageData = Format.encodeMultiCell((ACell)this.payload, (boolean)true);
                break;
            }
            case DATA: {
                AVector v = (AVector)this.payload;
                this.messageData = Format.encodeCells((List)v);
                break;
            }
            default: {
                this.messageData = Format.encodedBlob((ACell)this.payload);
            }
        }
        return this.messageData;
    }

    public MessageType getType() {
        return this.type;
    }

    public String toString() {
        try {
            Object payload = this.getPayload();
            AString ps = RT.print(this.getPayload(), (long)10000L);
            if (ps == null) {
                ps = Strings.create((String)("<" + RT.count((ACell)this.messageData) + " bytes as " + String.valueOf(RT.getType(payload)) + ">"));
            }
            return "#message {:type " + String.valueOf((Object)this.getType()) + " :payload " + String.valueOf(ps) + "}";
        }
        catch (MissingDataException e) {
            return "#message {:type " + String.valueOf((Object)this.getType()) + " :payload <partial, some still missing>}";
        }
        catch (Exception e) {
            return "#message <CORRUPED " + String.valueOf((Object)this.getType()) + ": " + e.getMessage();
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (this.getType() != other.getType()) {
            return false;
        }
        return this.getMessageData().equals(other.getMessageData());
    }

    public CVMLong getID() {
        try {
            switch (this.type) {
                case QUERY: 
                case TRANSACT: {
                    return (CVMLong)((AVector)this.getPayload()).get(0);
                }
                case RESULT: {
                    return (CVMLong)((Result)this.getPayload()).getID();
                }
                case STATUS: {
                    return (CVMLong)this.getPayload();
                }
                case DATA: {
                    Object o = this.getPayload();
                    if (!(o instanceof AVector)) break;
                    AVector v = (AVector)o;
                    if (v.count() == 0L) {
                        return null;
                    }
                    return RT.ensureLong((ACell)v.get(0));
                }
            }
            return null;
        }
        catch (BadFormatException e) {
            return null;
        }
    }

    public boolean returnResult(Result res) {
        CVMLong id = this.getID();
        if (id != null) {
            res = res.withID((ACell)id);
        }
        Message msg = Message.createResult(res);
        return this.returnMessage(msg);
    }

    public boolean returnMessage(Message m) {
        Predicate<Message> handler = this.returnHandler;
        if (handler == null) {
            return false;
        }
        return handler.test(m);
    }

    public boolean hasData() {
        return this.messageData != null;
    }

    public static Message createResult(Result res) {
        return Message.create(MessageType.RESULT, (ACell)res);
    }

    public static Message createResult(CVMLong id, ACell value, ACell error) {
        Result r = Result.create((CVMLong)id, (ACell)value, (ACell)error);
        return Message.createResult(r);
    }

    public void closeConnection() {
        this.returnHandler = null;
    }

    public Message makeDataResponse(AStore store) throws BadFormatException {
        AVector v = RT.ensureVector(this.getPayload());
        if (v == null || v.isEmpty()) {
            throw new BadFormatException("Invalid data request payload");
        }
        long n = v.count();
        int i = 1;
        while ((long)i < n) {
            Hash h = RT.ensureHash((ACell)v.get(i));
            if (h == null) {
                throw new BadFormatException("Invalid data request hash");
            }
            Ref r = store.refForHash(h);
            if (r != null) {
                ACell data = r.getValue();
                v = v.assoc((long)i, data);
            } else {
                v = v.assoc((long)i, null);
            }
            ++i;
        }
        Message resp = Message.create(MessageType.DATA, (ACell)v);
        return resp;
    }

    public Result toResult() {
        try {
            MessageType type = this.getType();
            switch (type) {
                case RESULT: {
                    Result result = (Result)this.getPayload();
                    return result;
                }
            }
            return Result.create((CVMLong)this.getID(), (ACell)Strings.create((String)("Unexpected message type for Result: " + String.valueOf((Object)type))), (ACell)ErrorCodes.UNEXPECTED);
        }
        catch (Exception e) {
            return Result.create(null, (ACell)Strings.create((String)("Error building Result: " + e.getMessage())), (ACell)ErrorCodes.FATAL);
        }
    }

    public static Message create(MessageType type, ACell payload, Predicate<Message> handler) {
        return new Message(type, payload, null, handler);
    }
}

