/*
 * Decompiled with CFR 0.152.
 */
package convex.api;

import convex.api.Convex;
import convex.core.Result;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.MissingDataException;
import convex.core.store.AStore;
import convex.core.transactions.ATransaction;
import convex.core.util.ThreadUtils;
import convex.net.Message;
import convex.net.MessageType;
import convex.peer.Server;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;

public class ConvexLocal
extends Convex {
    private final Server server;
    private long idCounter = 0L;

    protected ConvexLocal(Server server, Address address, AKeyPair keyPair) {
        super(address, keyPair);
        this.server = server;
    }

    public static ConvexLocal create(Server server, Address address, AKeyPair keyPair) {
        return new ConvexLocal(server, address, keyPair);
    }

    @Override
    public boolean isConnected() {
        return this.server.isLive();
    }

    @Override
    public <T extends ACell> CompletableFuture<T> acquire(Hash hash, AStore store) {
        CompletableFuture f = new CompletableFuture();
        ThreadUtils.runVirtual(() -> {
            AStore peerStore = this.server.getStore();
            Ref ref = peerStore.refForHash(hash);
            if (ref == null) {
                f.completeExceptionally(new MissingDataException(peerStore, hash));
            } else {
                ref = store.storeTopRef(ref, 2, null);
                f.complete(ref.getValue());
            }
        });
        return f;
    }

    @Override
    public CompletableFuture<Result> requestStatus() {
        return this.makeMessageFuture(MessageType.STATUS, (ACell)CVMLong.create((long)this.makeID()));
    }

    @Override
    public CompletableFuture<Result> transact(SignedData<ATransaction> signed) {
        this.maybeUpdateSequence(signed);
        CompletableFuture<Result> r = this.makeMessageFuture(MessageType.TRANSACT, (ACell)Vectors.of((Object[])new Object[]{this.makeID(), signed}));
        return r;
    }

    @Override
    public CompletableFuture<Result> requestChallenge(SignedData<ACell> data) {
        return this.makeMessageFuture(MessageType.CHALLENGE, (ACell)data);
    }

    @Override
    public CompletableFuture<Result> query(ACell query, Address address) {
        return this.makeMessageFuture(MessageType.QUERY, (ACell)Vectors.of((Object[])new Object[]{this.makeID(), query, address}));
    }

    private long makeID() {
        return this.idCounter++;
    }

    private CompletableFuture<Result> makeMessageFuture(MessageType type, ACell payload) {
        CompletableFuture<Result> cf = new CompletableFuture<Result>();
        Predicate<Message> resultHandler = this.makeResultHandler(cf);
        Message ml = Message.create(type, payload, resultHandler);
        this.server.getReceiveAction().accept(ml);
        return cf;
    }

    private Predicate<Message> makeResultHandler(CompletableFuture<Result> cf) {
        return m -> {
            Result r = m.toResult();
            if (r.getErrorCode() != null) {
                this.sequence = null;
            }
            cf.complete(r);
            return true;
        };
    }

    @Override
    public void close() {
    }

    @Override
    public CompletableFuture<State> acquireState() throws TimeoutException {
        return CompletableFuture.completedFuture(this.getState());
    }

    public State getState() {
        return this.server.getPeer().getConsensusState();
    }

    @Override
    public Server getLocalServer() {
        return this.server;
    }

    @Override
    public long getSequence() {
        if (this.sequence == null) {
            AccountStatus as = this.getState().getAccount(this.address);
            if (as == null) {
                return 0L;
            }
            this.sequence = as.getSequence();
        }
        return this.sequence;
    }

    @Override
    public long getSequence(Address addr) {
        if (Cells.equals((ACell)this.address, (ACell)addr)) {
            return this.getSequence();
        }
        return this.getState().getAccount(addr).getSequence();
    }

    @Override
    public String toString() {
        return "Local Convex instance on " + String.valueOf(this.server.getHostAddress());
    }

    @Override
    public InetSocketAddress getHostAddress() {
        return this.server.getHostAddress();
    }

    @Override
    public Long getBalance() {
        return this.server.getPeer().getConsensusState().getBalance(this.address);
    }
}

