/*
 * Decompiled with CFR 0.152.
 */
package convex.api;

import convex.api.ConvexLocal;
import convex.api.ConvexRemote;
import convex.core.Result;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AList;
import convex.core.data.AccountKey;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.Lists;
import convex.core.data.SignedData;
import convex.core.data.Symbol;
import convex.core.data.prim.CVMLong;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.lang.Symbols;
import convex.core.lang.ops.Special;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Invoke;
import convex.core.transactions.Transfer;
import convex.core.util.Utils;
import convex.net.Message;
import convex.net.ResultConsumer;
import convex.peer.Server;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Convex {
    private static final Logger log = LoggerFactory.getLogger((String)Convex.class.getName());
    protected long timeout = 8000L;
    protected AKeyPair keyPair;
    protected Address address;
    private boolean autoSequence = true;
    protected Long sequence = null;
    protected HashMap<Long, CompletableFuture<Message>> awaiting = new HashMap();
    protected final Consumer<Message> messageHandler = new ResultConsumer(){

        @Override
        protected synchronized void handleResult(long id, Result v) {
            ACell ec = v.getErrorCode();
            if (ec != null) {
                Convex.this.sequence = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Message m) {
            HashMap<Long, CompletableFuture<Message>> hashMap = Convex.this.awaiting;
            synchronized (hashMap) {
                CompletableFuture<Message> cf;
                CVMLong id = m.getID();
                CompletableFuture<Message> completableFuture = cf = id == null ? null : Convex.this.awaiting.remove(id.longValue());
                if (cf != null && cf.complete(m)) {
                    return;
                }
            }
            if (Convex.this.delegatedHandler != null) {
                Convex.this.delegatedHandler.accept(m);
            } else {
                super.accept(m);
            }
        }
    };
    private Consumer<Message> delegatedHandler = null;

    protected Convex(Address address, AKeyPair keyPair) {
        this.keyPair = keyPair;
        this.address = address;
    }

    public static ConvexRemote connect(InetSocketAddress hostAddress) throws IOException, TimeoutException {
        return Convex.connect(hostAddress, (Address)null, (AKeyPair)null);
    }

    public static ConvexRemote connect(InetSocketAddress peerAddress, Address address, AKeyPair keyPair) throws IOException, TimeoutException {
        return Convex.connect(peerAddress, address, keyPair, Stores.current());
    }

    public static ConvexRemote connect(InetSocketAddress peerAddress, Address address, AKeyPair keyPair, AStore store) throws IOException, TimeoutException {
        ConvexRemote convex = new ConvexRemote(address, keyPair);
        convex.connectToPeer(peerAddress, store);
        return convex;
    }

    public synchronized void setAddress(Address address) {
        if (this.address == address) {
            return;
        }
        this.address = address;
        this.sequence = null;
    }

    public synchronized void setAddress(Address address, AKeyPair kp) {
        this.setAddress(address);
        this.setKeyPair(kp);
    }

    public synchronized void setKeyPair(AKeyPair kp) {
        this.keyPair = kp;
    }

    public void setNextSequence(long nextSequence) {
        this.sequence = nextSequence - 1L;
    }

    public void setHandler(Consumer<Message> handler) {
        this.delegatedHandler = handler;
    }

    public long getSequence() throws IOException, TimeoutException {
        if (this.sequence == null) {
            this.sequence = this.lookupSequence(this.getAddress());
        }
        return this.sequence;
    }

    public long getSequence(Address addr) throws TimeoutException, IOException {
        if (Cells.equals((ACell)this.getAddress(), (ACell)addr)) {
            return this.getSequence();
        }
        return this.lookupSequence(addr);
    }

    public long lookupSequence(Address origin) throws IOException, TimeoutException {
        Special code = Special.forSymbol((Symbol)Symbols.STAR_SEQUENCE);
        Result r = this.querySync((ACell)code, origin);
        if (r.isError()) {
            throw new RuntimeException("Error trying to get sequence number: " + String.valueOf(r));
        }
        ACell rv = r.getValue();
        if (!(rv instanceof CVMLong)) {
            throw new RuntimeException("Unexpected sequence result type: " + Utils.getClassName((Object)rv));
        }
        long seq = ((CVMLong)rv).longValue();
        return seq;
    }

    protected void maybeUpdateSequence(SignedData<ATransaction> signed) {
        try {
            ATransaction trans = (ATransaction)signed.getValue();
            if (!this.isAutoSequence()) {
                return;
            }
            if (!Cells.equals((ACell)trans.getOrigin(), (ACell)this.address)) {
                return;
            }
            Long seq = this.sequence;
            if (seq == null) {
                return;
            }
            Long l = seq;
            seq = seq + 1L;
            if (seq.longValue() == trans.getSequence()) {
                this.sequence = seq;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T extends ACell> SignedData<T> signData(T value) {
        return this.keyPair.signData(value);
    }

    public Address createAccountSync(AccountKey publicKey) throws TimeoutException, IOException {
        Invoke trans = Invoke.create((Address)this.address, (long)0L, (ACell)Lists.of((Object[])new Object[]{Symbols.CREATE_ACCOUNT, publicKey}));
        Result r = this.transactSync((ATransaction)trans);
        if (r.isError()) {
            throw new Error("Error creating account: " + String.valueOf(r.getErrorCode()) + " " + String.valueOf(r.getValue()));
        }
        return (Address)r.getValue();
    }

    public CompletableFuture<Address> createAccount(AccountKey publicKey) throws TimeoutException, IOException {
        Invoke trans = Invoke.create((Address)this.address, (long)0L, (ACell)Lists.of((Object[])new Object[]{Symbols.CREATE_ACCOUNT, publicKey}));
        CompletableFuture<Result> fr = this.transact((ATransaction)trans);
        return fr.thenApply(r -> (Address)r.getValue());
    }

    public abstract boolean isConnected();

    private synchronized long getNextSequence(ATransaction t) throws IOException, TimeoutException {
        if (this.sequence != null) {
            return this.sequence + 1L;
        }
        return this.getSequence() + 1L;
    }

    public final synchronized CompletableFuture<Result> transact(ATransaction transaction) throws IOException, TimeoutException {
        SignedData<ATransaction> signed = this.prepareTransaction(transaction);
        CompletableFuture<Result> r = this.transact(signed);
        return r;
    }

    public SignedData<ATransaction> prepareTransaction(ATransaction transaction) throws TimeoutException, IOException {
        long originalSeq;
        Address origin = transaction.getOrigin();
        if (origin == null) {
            origin = this.address;
            transaction = transaction.withOrigin(origin);
        }
        long seq = originalSeq = transaction.getSequence();
        if (this.autoSequence || originalSeq <= 0L) {
            long expected;
            State state;
            AccountStatus as;
            Server s;
            if (seq <= 0L && Cells.equals((ACell)origin, (ACell)this.address)) {
                seq = this.getNextSequence(transaction);
            }
            if ((s = this.getLocalServer()) != null && (as = (state = s.getPeer().getConsensusState()).getAccount(origin)) != null && (expected = as.getSequence() + 1L) > seq) {
                seq = expected;
            }
        }
        if (seq <= 0L) {
            seq = this.lookupSequence(origin);
        }
        if (seq != originalSeq) {
            transaction = transaction.withSequence(seq);
        }
        if (Cells.equals((ACell)origin, (ACell)this.address)) {
            this.sequence = seq;
        }
        SignedData signed = this.keyPair.signData((ACell)transaction);
        return signed;
    }

    public synchronized CompletableFuture<Result> transact(String code) throws IOException, TimeoutException {
        return this.transact(Reader.read((String)code));
    }

    public synchronized CompletableFuture<Result> transact(ACell code) throws IOException, TimeoutException {
        Invoke trans = Invoke.create((Address)this.getAddress(), (long)0L, (ACell)code);
        return this.transact((ATransaction)trans);
    }

    private ACell buildCodeForm(String code) {
        AList forms = Reader.readAll((String)code);
        Object form = forms.count() == 1L ? forms.get(0) : forms.cons((ACell)Symbols.DO);
        return form;
    }

    public synchronized Result transactSync(String code) throws IOException, TimeoutException {
        Invoke trans = Invoke.create((Address)this.getAddress(), (long)0L, (String)code);
        return this.transactSync((ATransaction)trans);
    }

    public abstract CompletableFuture<Result> transact(SignedData<ATransaction> var1) throws IOException;

    public CompletableFuture<Result> transfer(Address target, long amount) throws IOException, TimeoutException {
        Transfer trans = Transfer.create((Address)this.getAddress(), (long)0L, (Address)target, (long)amount);
        return this.transact((ATransaction)trans);
    }

    public Result transferSync(Address target, long amount) throws IOException, TimeoutException {
        Transfer trans = Transfer.create((Address)this.getAddress(), (long)0L, (Address)target, (long)amount);
        return this.transactSync((ATransaction)trans);
    }

    public Result transactSync(SignedData<ATransaction> transaction) throws TimeoutException, IOException {
        return this.transactSync(transaction, this.timeout);
    }

    public Result transactSync(ATransaction transaction) throws TimeoutException, IOException {
        return this.transactSync(transaction, this.timeout);
    }

    public synchronized Result transactSync(ATransaction transaction, long timeout) throws TimeoutException, IOException {
        long start = Utils.getTimeMillis();
        CompletableFuture<Result> cf = this.transact(transaction);
        long now = Utils.getTimeMillis();
        timeout = Math.max(0L, timeout - (now - start));
        try {
            Result result = (Result)cf.get(timeout, TimeUnit.MILLISECONDS);
            if (result.getErrorCode() != null) {
                this.sequence = null;
            }
            return result;
        }
        catch (InterruptedException e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
        catch (ExecutionException e) {
            return Result.fromException((Throwable)e.getCause());
        }
    }

    public Result transactSync(SignedData<ATransaction> transaction, long timeout) throws TimeoutException, IOException {
        long start = Utils.getTimeMillis();
        CompletableFuture<Result> cf = this.transact(transaction);
        long now = Utils.getTimeMillis();
        timeout = Math.max(0L, timeout - (now - start));
        try {
            Result result;
            Result result2 = result = (Result)cf.get(timeout, TimeUnit.MILLISECONDS);
            return result2;
        }
        catch (InterruptedException e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
        catch (ExecutionException e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
        finally {
            cf.cancel(true);
        }
    }

    public CompletableFuture<Result> query(ACell query) throws IOException {
        return this.query(query, this.getAddress());
    }

    public CompletableFuture<Result> query(String query) throws IOException {
        ACell form = this.buildCodeForm(query);
        return this.query(form, this.getAddress());
    }

    public CompletableFuture<ACell> resolve(String cnsName) throws IOException {
        ACell form = this.buildCodeForm("(import " + cnsName + ")");
        return this.query(form).thenApply(r -> {
            if (r.isError()) {
                throw new RuntimeException("Resolve failed " + String.valueOf(r));
            }
            return r.getValue();
        });
    }

    public <T extends ACell> CompletableFuture<T> acquire(Hash hash) {
        return this.acquire(hash, Stores.current());
    }

    public abstract <T extends ACell> CompletableFuture<T> acquire(Hash var1, AStore var2);

    public Result requestStatusSync(long timeoutMillis) throws IOException, TimeoutException {
        CompletableFuture<Result> statusFuture = this.requestStatus();
        try {
            Result result = (Result)statusFuture.get(timeoutMillis, TimeUnit.MILLISECONDS);
            return result;
        }
        catch (InterruptedException | ExecutionException e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
        finally {
            statusFuture.cancel(true);
        }
    }

    public abstract CompletableFuture<Result> requestStatus();

    protected CompletableFuture<Result> awaitResult(long id, long timeout) {
        CompletionStage cf = new CompletableFuture();
        if (timeout > 0L) {
            cf = ((CompletableFuture)cf).orTimeout(timeout, TimeUnit.MILLISECONDS);
        }
        cf = ((CompletableFuture)cf).whenComplete((m, e) -> {
            HashMap<Long, CompletableFuture<Message>> hashMap = this.awaiting;
            synchronized (hashMap) {
                this.awaiting.remove(id);
            }
        });
        this.awaiting.put(id, (CompletableFuture<Message>)cf);
        CompletionStage cr = ((CompletableFuture)cf).thenApply(m -> {
            Result r = m.toResult();
            if (r.getErrorCode() != null) {
                this.sequence = null;
            }
            return r;
        });
        return cr;
    }

    public abstract CompletableFuture<Result> requestChallenge(SignedData<ACell> var1) throws IOException;

    public abstract CompletableFuture<Result> query(ACell var1, Address var2) throws IOException;

    public Result querySync(ACell query) throws TimeoutException, IOException {
        return this.querySync(query, this.getAddress());
    }

    public Result querySync(String query) throws TimeoutException, IOException {
        ACell form = this.buildCodeForm(query);
        return this.querySync(form, this.getAddress());
    }

    public Result querySync(ACell query, long timeoutMillis) throws IOException, TimeoutException {
        return this.querySync(query, this.getAddress(), timeoutMillis);
    }

    public Result querySync(ACell query, Address address) throws IOException, TimeoutException {
        return this.querySync(query, address, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result querySync(ACell query, Address address, long timeoutMillis) throws TimeoutException, IOException {
        Result result;
        CompletableFuture<Result> cf = this.query(query, address);
        try {
            result = (Result)cf.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
        catch (ExecutionException e) {
            Result result2 = Result.fromException((Throwable)e.getCause());
            return result2;
        }
        finally {
            cf.cancel(true);
        }
        return result;
    }

    public AccountKey getAccountKey() {
        if (this.keyPair == null) {
            return null;
        }
        return this.keyPair.getAccountKey();
    }

    public AccountKey getAccountKey(Address a) {
        if (a == null) {
            return null;
        }
        try {
            Result r = this.querySync(Reader.read((String)("(:key (account " + String.valueOf(a) + "))")));
            if (r.isError()) {
                return null;
            }
            ABlob b = RT.ensureBlob((ACell)r.getValue());
            return AccountKey.create((ABlob)b);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Address getAddress() {
        return this.address;
    }

    public abstract void close();

    public void finalize() {
        this.close();
    }

    protected boolean isAutoSequence() {
        return this.autoSequence;
    }

    protected void setAutoSequence(boolean autoSequence) {
        this.autoSequence = autoSequence;
    }

    public Long getBalance() throws IOException {
        Address a = this.getAddress();
        if (a == null) {
            throw new IllegalStateException("No address set for balance query");
        }
        return this.getBalance(a);
    }

    public Long getBalance(Address address) throws IOException {
        try {
            Object code = Utils.equals((ACell)this.address, (ACell)address) ? Special.forSymbol((Symbol)Symbols.STAR_BALANCE) : Lists.of((Object[])new Object[]{Symbols.BALANCE, address});
            CompletableFuture<Result> future = this.query((ACell)code);
            Result result = (Result)future.get(this.timeout, TimeUnit.MILLISECONDS);
            if (result.isError()) {
                return null;
            }
            CVMLong bal = (CVMLong)result.getValue();
            return bal.longValue();
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            throw new IOException("Unable to query balance", ex);
        }
    }

    public static ConvexLocal connect(Server server, Address address, AKeyPair keyPair) {
        return ConvexLocal.create(server, address, keyPair);
    }

    public static ConvexLocal connect(Server server) {
        return ConvexLocal.create(server, null, null);
    }

    public abstract CompletableFuture<State> acquireState() throws TimeoutException;

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public abstract String toString();

    public AKeyPair getKeyPair() {
        return this.keyPair;
    }

    public abstract Server getLocalServer();

    public abstract InetSocketAddress getHostAddress();
}

