/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.utils;

import convex.core.lang.reader.AntlrReader;
import convex.gui.components.BalanceLabel;
import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;

public class CVXHighlighter {
    static StyleContext sc = StyleContext.getDefaultStyleContext();
    static AttributeSet BASE = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Italic, false);
    static AttributeSet ITALIC = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Italic, true);
    static AttributeSet NORMAL = sc.addAttribute(BASE, StyleConstants.Foreground, Color.LIGHT_GRAY);
    static AttributeSet STRING = sc.addAttribute(ITALIC, StyleConstants.Foreground, Color.CYAN);
    static AttributeSet KEYWORD = sc.addAttribute(BASE, StyleConstants.Foreground, Color.PINK);
    static AttributeSet SYMBOL = NORMAL;
    static AttributeSet NUMBER = sc.addAttribute(BASE, StyleConstants.Foreground, Color.ORANGE);
    static AttributeSet GOLD = sc.addAttribute(BASE, StyleConstants.Foreground, BalanceLabel.GOLD);
    static AttributeSet SILVER = sc.addAttribute(BASE, StyleConstants.Foreground, BalanceLabel.SILVER);
    static AttributeSet BRONZE = sc.addAttribute(BASE, StyleConstants.Foreground, BalanceLabel.BRONZE);
    static AttributeSet COPPER = sc.addAttribute(BASE, StyleConstants.Foreground, BalanceLabel.COPPER);
    private static final AttributeSet[] PARENS = new AttributeSet[10];

    public static void highlight(JTextPane inputArea, int start, int end) {
        try {
            StyledDocument d = inputArea.getStyledDocument();
            int dlen = d.getLength();
            end = Math.min(end, dlen);
            String input = d.getText(start, end - start);
            CodePointCharStream cs = CharStreams.fromString((String)input);
            Lexer lexer = AntlrReader.getLexer((CharStream)cs);
            lexer.removeErrorListeners();
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            tokens.fill();
            int tcount = tokens.size();
            int nest = 0;
            block15: for (int i = 0; i < tcount; ++i) {
                Token tok = tokens.get(i);
                int tstart = start + tok.getStartIndex();
                int tend = start + tok.getStopIndex() + 1;
                int tlen = tend - tstart;
                if (tlen <= 0) continue;
                char c = input.charAt(tstart - start);
                AttributeSet aset = NORMAL;
                switch (c) {
                    case '\"': {
                        aset = STRING;
                        break;
                    }
                    case ':': {
                        aset = KEYWORD;
                        break;
                    }
                    case '(': {
                        aset = CVXHighlighter.getParen(nest++);
                        break;
                    }
                    case ')': {
                        aset = CVXHighlighter.getParen(--nest);
                        break;
                    }
                    case '[': {
                        nest += 2;
                        aset = CVXHighlighter.getParen(nest++);
                        break;
                    }
                    case ']': {
                        aset = CVXHighlighter.getParen(--nest);
                        nest -= 2;
                        break;
                    }
                    case '{': {
                        nest += 4;
                        aset = CVXHighlighter.getParen(nest++);
                        break;
                    }
                    case '}': {
                        aset = CVXHighlighter.getParen(--nest);
                        nest -= 4;
                        break;
                    }
                    case '\t': 
                    case ' ': 
                    case ',': {
                        aset = CVXHighlighter.getParen(nest);
                        break;
                    }
                    default: {
                        if (Character.isDigit(c)) {
                            aset = NUMBER;
                        }
                        if (tlen <= 3) break;
                        try {
                            String fullNum = d.getText(tstart, tlen);
                            Long.parseLong(fullNum);
                            if (tlen > 9) {
                                d.setCharacterAttributes(tstart, tlen - 9, GOLD, true);
                            }
                            if (tlen > 6) {
                                d.setCharacterAttributes(tstart + Math.max(0, tlen - 9), Math.min(3, tlen - 6), SILVER, true);
                            }
                            if (tlen > 3) {
                                d.setCharacterAttributes(tstart + Math.max(0, tlen - 6), Math.min(3, tlen - 3), BRONZE, false);
                            }
                            d.setCharacterAttributes(tstart + tlen - 3, tlen, COPPER, false);
                            continue block15;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                d.setCharacterAttributes(tstart, tlen, aset, false);
            }
        }
        catch (Exception t) {
            t.printStackTrace();
        }
    }

    private static AttributeSet getParen(int i) {
        if (++i < 0) {
            i = 0;
        }
        return PARENS[i % PARENS.length];
    }

    static {
        for (int i = 0; i < PARENS.length; ++i) {
            AttributeSet aset;
            Color c = Color.getHSBColor(0.1f * (float)i, 1.0f, 1.0f);
            c = c.brighter();
            CVXHighlighter.PARENS[i] = aset = sc.addAttribute(BASE, StyleConstants.Foreground, c);
        }
    }
}

