/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.tools;

import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.Ref;
import convex.core.data.Refs;
import convex.core.exceptions.MissingDataException;
import convex.core.exceptions.ParseException;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.text.PrintUtils;
import convex.core.util.Utils;
import convex.gui.components.ActionPanel;
import convex.gui.components.CodeLabel;
import convex.gui.components.CodePane;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class MessageFormatPanel
extends JPanel {
    final CodePane dataArea;
    final CodeLabel messageArea;
    private JPanel buttonPanel;
    private JButton clearButton;
    private JPanel instructionsPanel;
    private JLabel lblNewLabel;
    private JTextArea hashLabel;

    public MessageFormatPanel() {
        this.setLayout(new BorderLayout(0, 0));
        this.instructionsPanel = new JPanel();
        this.add((Component)this.instructionsPanel, "North");
        this.lblNewLabel = new JLabel("Convert data values to encoded binary representations, and vice versa");
        this.instructionsPanel.add(this.lblNewLabel);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.5);
        splitPane.setOrientation(0);
        this.add((Component)splitPane, "Center");
        this.dataArea = new CodePane();
        this.dataArea.setToolTipText("Enter data objects here");
        this.dataArea.setEditable(true);
        this.dataArea.setMaxColumns(128);
        this.dataArea.setFont(Toolkit.MONO_FONT);
        this.dataArea.getDocument().addDocumentListener(Toolkit.createDocumentListener(() -> this.updateData()));
        splitPane.setLeftComponent(new JScrollPane(this.dataArea));
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new BorderLayout(0, 0));
        this.messageArea = new CodeLabel();
        this.messageArea.setEditable(true);
        this.messageArea.setToolTipText("Enter binary hex representation here");
        this.messageArea.setFont(Toolkit.MONO_FONT);
        this.messageArea.setBackground(Color.BLACK);
        this.messageArea.setLineWrap(true);
        this.messageArea.setMaxColumns(65);
        JScrollPane messageScroll = new JScrollPane(this.messageArea);
        messageScroll.getViewport().setBackground(Color.BLACK);
        lowerPanel.add((Component)messageScroll, "Center");
        splitPane.setRightComponent(lowerPanel);
        this.hashLabel = new JTextArea();
        this.hashLabel.setRows(2);
        this.hashLabel.setToolTipText("Hash code of the data object's serilaised representation = Data Object ID");
        this.hashLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createRaisedBevelBorder()));
        this.hashLabel.setBackground(null);
        this.hashLabel.setFont(Toolkit.MONO_FONT);
        lowerPanel.add((Component)this.hashLabel, "South");
        this.messageArea.getDocument().addDocumentListener(Toolkit.createDocumentListener(() -> this.updateMessage()));
        this.buttonPanel = new ActionPanel();
        this.add((Component)this.buttonPanel, "South");
        this.clearButton = new JButton("Clear", Toolkit.menuIcon(59445));
        this.clearButton.setToolTipText("Press to clear the input areas");
        this.clearButton.addActionListener(e -> {
            this.dataArea.setText("");
            this.messageArea.setText("");
        });
        this.buttonPanel.add(this.clearButton);
        this.updateHashLabel(null, null);
    }

    private void updateMessage() {
        Object data;
        block6: {
            if (!this.messageArea.isFocusOwner()) {
                return;
            }
            data = "";
            String msg = this.messageArea.getText();
            Blob b = null;
            ACell o = null;
            try {
                b = Blob.parse((String)Utils.stripWhiteSpace((String)msg));
                if (b == null) {
                    data = "Invalid hex";
                } else {
                    o = Format.decodeMultiCell((Blob)b);
                    data = Utils.print((Object)o);
                    this.updateHashLabel(o, b);
                }
            }
            catch (ParseException e) {
                data = "Unable to interpret message: " + e.getMessage();
                this.clearHashLabel();
            }
            catch (Exception e) {
                data = "Message decoding failed: " + e.getMessage();
                this.clearHashLabel();
                if (!(e instanceof MissingDataException)) break block6;
                String refTree = PrintUtils.printRefTree((Ref)Ref.get((ACell)o));
                data = (String)data + "\n\n" + refTree;
            }
        }
        this.dataArea.setText((String)data);
    }

    private void clearHashLabel() {
        this.updateHashLabel(null, null);
    }

    private void updateData() {
        if (!this.dataArea.isFocusOwner()) {
            return;
        }
        Object msg = "";
        String data = this.dataArea.getText();
        this.clearHashLabel();
        if (!data.isBlank()) {
            try {
                this.messageArea.setEnabled(false);
                ACell o = Reader.read((String)data);
                Blob b = Format.encodeMultiCell((ACell)o, (boolean)true);
                this.updateHashLabel(o, b);
                msg = b.toHexString();
                this.messageArea.setEnabled(true);
            }
            catch (Exception e) {
                msg = e.getClass().getSimpleName() + ": " + e.getMessage();
            }
        }
        this.messageArea.setText((String)msg);
    }

    private void updateHashLabel(ACell v, Blob b) {
        StringBuilder sb = new StringBuilder();
        boolean empty = b == null;
        sb.append("Hash:          " + (empty ? "<none>" : b.getContentHash().toString()));
        sb.append("\n");
        sb.append("Type:          " + (empty ? "<none>" : RT.getType((ACell)v).toString()));
        sb.append("\n");
        sb.append("Encoding Size: " + String.valueOf(empty ? "<none>" : Long.valueOf(b.count())));
        sb.append("\n");
        sb.append("Memory Size:   " + String.valueOf(empty ? "<none>" : Long.valueOf(Cells.storageSize((ACell)v))));
        sb.append("\n");
        sb.append("Cell Count:    " + String.valueOf(empty ? "<none>" : Long.valueOf(Refs.totalRefCount((ACell)v))));
        sb.append("\n");
        sb.append("Branch Count:  " + String.valueOf(empty ? "<none>" : Integer.valueOf(Cells.branchCount((ACell)v))));
        this.hashLabel.setText(sb.toString());
    }
}

