/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.state;

import convex.core.data.ACell;
import convex.core.data.Cells;
import convex.core.data.Ref;
import convex.core.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class StateTreeNode<T extends ACell>
extends DefaultMutableTreeNode {
    private final T object;
    private final boolean isContainer;

    public StateTreeNode(T o) {
        this.object = o;
        this.isContainer = Cells.refCount(o) > 0;
    }

    private static <R extends ACell> StateTreeNode<R> create(R value) {
        return new StateTreeNode<R>(value);
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (this.isContainer) {
            ACell child = this.object.getRef(childIndex).getValue();
            return StateTreeNode.create(child);
        }
        return null;
    }

    @Override
    public int getChildCount() {
        return this.isContainer ? this.object.getRefCount() : 0;
    }

    @Override
    public TreeNode getParent() {
        return null;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.isContainer;
    }

    @Override
    public Enumeration<TreeNode> children() {
        Ref[] childRefs = this.isContainer ? this.object.getChildRefs() : new Ref[]{};
        ArrayList<StateTreeNode<ACell>> tns = new ArrayList<StateTreeNode<ACell>>();
        for (Ref r : childRefs) {
            tns.add(StateTreeNode.create(r.getValue()));
        }
        return Collections.enumeration(tns);
    }

    @Override
    public String toString() {
        return Utils.getClassName(this.object);
    }
}

