/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.server;

import convex.observer.LogObserver;
import convex.observer.StrimziKafka;
import convex.peer.Server;
import convex.peer.TransactionHandler;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;

public class ObserverPanel
extends JPanel {
    protected Server server;
    private HashMap<String, ButtonGroup> bgroups = new HashMap();

    public ObserverPanel(Server server) {
        this.server = server;
        this.setLayout((LayoutManager)new MigLayout("wrap 2"));
        this.add((Component)new JLabel("Transactions"), "span 2");
        JRadioButton noneButton = this.addButton("Transactions", new JLabel("None"), () -> {
            server.getTransactionHandler().setRequestObserver(null);
            server.getTransactionHandler().setResponseObserver(null);
        });
        noneButton.setSelected(true);
        this.add(noneButton);
        this.add(new JLabel("None"));
        JRadioButton strmButton = this.addButton("Transactions", new JLabel("Strimzi"), () -> {
            StrimziKafka obs = StrimziKafka.get((Server)server);
            TransactionHandler th = server.getTransactionHandler();
            th.setRequestObserver(obs.getTransactionRequestObserver(server));
            th.setResponseObserver(obs.getTransactionResponseObserver(server));
        });
        this.add(strmButton);
        this.add(new JLabel("Strimzi"));
        JRadioButton tlogButton = this.addButton("Transactions", new JLabel("Logs"), () -> {
            TransactionHandler th = server.getTransactionHandler();
            LogObserver ob = new LogObserver(server);
            th.setRequestObserver(ob.getTransactionRequestObserver());
            th.setResponseObserver(ob.getTransactionResponseObserver());
        });
        this.add(tlogButton);
        this.add(new JLabel("SLF4J Logging"));
    }

    private JRadioButton addButton(String bgName, JLabel jLabel, Runnable action) {
        ButtonGroup buttonGroup = this.getGroup(bgName);
        JRadioButton button = new JRadioButton();
        buttonGroup.add(button);
        button.addActionListener(e -> action.run());
        return button;
    }

    private ButtonGroup getGroup(String bgName) {
        ButtonGroup bg = this.bgroups.get(bgName);
        if (bg == null) {
            bg = new ButtonGroup();
            this.bgroups.put(bgName, bg);
        }
        return bg;
    }
}

