/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.peer;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.wallet.AWalletEntry;
import convex.core.crypto.wallet.HotWalletEntry;
import convex.core.data.AMap;
import convex.core.util.FileUtils;
import convex.gui.components.FilePicker;
import convex.gui.components.HostCombo;
import convex.gui.components.Toast;
import convex.gui.components.account.KeyPairCombo;
import convex.gui.keys.UnlockWalletDialog;
import convex.gui.peer.PeerGUI;
import convex.gui.utils.SymbolIcon;
import convex.gui.utils.Toolkit;
import convex.net.IPUtils;
import convex.peer.Server;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;

public class PeerLaunchDialog {
    public static void runLaunchDialog(JComponent parent) {
        JPanel testNetPanel = new JPanel();
        testNetPanel.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "", "[fill]10[fill][40]"));
        testNetPanel.add(new JLabel("Number of Peers:"));
        JSpinner peerCountSpinner = new JSpinner();
        peerCountSpinner.setModel(new SpinnerNumberModel(3, 1, 100, 1));
        testNetPanel.add(peerCountSpinner);
        testNetPanel.add(Toolkit.makeHelp("Select a number of peers to include in the genesis state and launch initially. More can be added later. 3-5 recommended for local devnet testing"));
        testNetPanel.add(new JLabel("Genesis Key:   "));
        KeyPairCombo keyField = KeyPairCombo.create();
        testNetPanel.add(keyField);
        testNetPanel.add(Toolkit.makeHelp("Select genesis key for the network. The genesis key will be the key used for the first peer and initial governance accounts."));
        testNetPanel.add(new JPanel());
        JButton randomise = new JButton("Randomise", SymbolIcon.get(59491, Toolkit.SMALL_ICON_SIZE));
        randomise.addActionListener(e -> {
            AKeyPair newKP = AKeyPair.generate();
            keyField.getModel().setSelectedItem(HotWalletEntry.create((AKeyPair)newKP, (String)"Random genesis key pair for testing"));
        });
        testNetPanel.add(randomise);
        testNetPanel.add(Toolkit.makeHelp("Randomise the genesis key. Fine for testing purposes."));
        JPanel joinPanel = new JPanel();
        joinPanel.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "", "[fill]10[fill][40]"));
        joinPanel.add(new JLabel("Source Peer:"));
        HostCombo hostField = new HostCombo();
        hostField.setToolTipText("Enter a peer address to join e.g. peer.convex.live:18888");
        joinPanel.add(hostField);
        joinPanel.add(Toolkit.makeHelp("Select an existing peer to join with the new peer. Should be a trusted source for the global state and current consensus ordering."));
        joinPanel.add(new JLabel("Peer Key:   "));
        KeyPairCombo peerKeyField = KeyPairCombo.create();
        joinPanel.add(peerKeyField);
        joinPanel.add(Toolkit.makeHelp("Select peer key for the new peer."));
        joinPanel.add(new JLabel("Etch Store:   "));
        FilePicker filePicker = new FilePicker(FileUtils.getFile((String)"~/.convex/etch.db").getAbsolutePath());
        joinPanel.add(filePicker);
        joinPanel.add(Toolkit.makeHelp("Select Etch database file for peer operation."));
        JPanel loadPanel = new JPanel();
        FilePicker backupPicker = new FilePicker(null);
        loadPanel.add(backupPicker);
        JTabbedPane tabs = new JTabbedPane();
        tabs.add((Component)testNetPanel, "Local Testnet");
        tabs.add((Component)joinPanel, "Join Network");
        tabs.add((Component)loadPanel, "Restore Backup");
        int result = JOptionPane.showConfirmDialog(parent, tabs, "Peer Launch Details", 2, 3, SymbolIcon.get(60315, Toolkit.ICON_SIZE));
        if (result == 0) {
            try {
                Component selected = tabs.getSelectedComponent();
                if (selected == testNetPanel) {
                    boolean unlocked;
                    int numPeers = (Integer)peerCountSpinner.getValue();
                    AWalletEntry we = keyField.getWalletEntry();
                    if (we == null) {
                        throw new IllegalStateException("No key pair selected");
                    }
                    if (we.isLocked() && !(unlocked = UnlockWalletDialog.offerUnlock(parent, we))) {
                        Toast.display(parent, "Launch cancelled: Locked genesis key", Color.RED);
                        return;
                    }
                    AKeyPair kp = we.getKeyPair();
                    PeerGUI.launchPeerGUI(numPeers, kp);
                } else if (selected == joinPanel) {
                    boolean unlocked;
                    String host = hostField.getText();
                    InetSocketAddress sa = IPUtils.toInetSocketAddress((String)host);
                    if (sa == null) {
                        throw new IllegalArgumentException("Invalid host address for joining");
                    }
                    AWalletEntry we = peerKeyField.getWalletEntry();
                    if (we == null) {
                        throw new IllegalArgumentException("No peer key selected");
                    }
                    if (we.isLocked() && !(unlocked = UnlockWalletDialog.offerUnlock(parent, we))) {
                        Toast.display(parent, "Launch cancelled: Locked peer key", Color.RED);
                        return;
                    }
                    PeerGUI.launchPeerGUI(sa, we.getKeyPair());
                } else if (selected == loadPanel) {
                    File f = backupPicker.getFile();
                    AKeyPair kp = null;
                    AMap peerData = (AMap)FileUtils.loadCAD3((Path)f.toPath());
                    Server server = Server.fromPeerData(kp, (AMap)peerData);
                    PeerGUI.launchPeerGUI(server);
                }
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e3) {
                e3.printStackTrace();
                JOptionPane.showMessageDialog(parent, "Peer launch failed\n\nReason : " + e3.getMessage());
            }
        }
    }
}

