/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.peer;

import convex.api.Convex;
import convex.api.ConvexLocal;
import convex.core.Result;
import convex.core.cpos.Order;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.wallet.AWalletEntry;
import convex.core.crypto.wallet.HotWalletEntry;
import convex.core.cvm.Address;
import convex.core.cvm.Keywords;
import convex.core.cvm.Peer;
import convex.core.cvm.State;
import convex.core.data.AccountKey;
import convex.core.data.Keyword;
import convex.core.init.Init;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.util.ThreadUtils;
import convex.gui.components.AbstractGUI;
import convex.gui.components.Toast;
import convex.gui.components.account.AccountsPanel;
import convex.gui.keys.KeyGenPanel;
import convex.gui.keys.KeyRingPanel;
import convex.gui.models.StateModel;
import convex.gui.peer.AboutPanel;
import convex.gui.peer.ServerListPanel;
import convex.gui.peer.TorusPanel;
import convex.gui.tools.MessageFormatPanel;
import convex.gui.utils.Toolkit;
import convex.peer.API;
import convex.peer.PeerException;
import convex.peer.Server;
import convex.restapi.RESTServer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerGUI
extends AbstractGUI {
    private static final Logger log = LoggerFactory.getLogger((String)PeerGUI.class.getName());
    protected JFrame frame;
    public static final int DEFAULT_NUM_PEERS = 3;
    public State genesisState;
    private StateModel<State> latestState;
    public StateModel<Long> tickState;
    protected DefaultListModel<ConvexLocal> peerList;
    ServerListPanel serverPanel;
    KeyRingPanel keyRingPanel;
    KeyGenPanel keyGenPanel;
    MessageFormatPanel messagePanel;
    JPanel accountsPanel;
    JTabbedPane tabs;
    RESTServer restServer;
    public static Integer REST_PORT = null;
    private boolean updateRunning;
    private long cp;
    private Runnable updateThread;
    private static HashMap<Server, StateModel<Peer>> models = new HashMap();
    private static long maxBlock = 0L;

    public static void main(String[] args) throws Exception {
        Toolkit.init();
        PeerGUI gui = PeerGUI.launchPeerGUI(3, AKeyPair.generate());
        gui.waitForClose();
        System.exit(0);
    }

    public static PeerGUI launchPeerGUI(int peerNum, AKeyPair genesisKey) throws InterruptedException, PeerException {
        PeerGUI manager = PeerGUI.create(peerNum, genesisKey);
        manager.run();
        return manager;
    }

    public static PeerGUI launchPeerGUI(InetSocketAddress sa, AKeyPair kp) throws InterruptedException, PeerException {
        DefaultListModel<ConvexLocal> peerList = new DefaultListModel<ConvexLocal>();
        HashMap<Keyword, Object> config = new HashMap<Keyword, Object>();
        config.put(Keywords.KEYPAIR, kp);
        config.put(Keywords.SOURCE, sa);
        Server server = API.launchPeer(config);
        ConvexLocal convex = ConvexLocal.connect((Server)server);
        peerList.addElement(convex);
        PeerGUI manager = new PeerGUI(peerList);
        manager.run();
        return manager;
    }

    public static PeerGUI launchPeerGUI(Server server) throws InterruptedException, PeerException {
        DefaultListModel<ConvexLocal> peerList = new DefaultListModel<ConvexLocal>();
        server.launch();
        ConvexLocal convex = ConvexLocal.connect((Server)server);
        peerList.addElement(convex);
        PeerGUI manager = new PeerGUI(peerList);
        manager.run();
        return manager;
    }

    public static PeerGUI create(int peerCount, AKeyPair genesisKey) throws PeerException {
        DefaultListModel<ConvexLocal> peerList = PeerGUI.launchAllPeers(peerCount, genesisKey);
        return new PeerGUI(peerList);
    }

    private static DefaultListModel<ConvexLocal> launchAllPeers(int peerCount, AKeyPair genesisKey) throws PeerException {
        ArrayList<AKeyPair> KEYPAIRS = new ArrayList<AKeyPair>();
        for (int i = 0; i < peerCount; ++i) {
            KEYPAIRS.add(AKeyPair.generate());
        }
        HotWalletEntry gwe = HotWalletEntry.create((AKeyPair)genesisKey, (String)"Genesis key pair (temp)");
        KeyRingPanel.addWalletEntry((AWalletEntry)gwe);
        AccountKey genPK = genesisKey.getAccountKey();
        List PEERKEYS = KEYPAIRS.stream().map(kp -> kp.getAccountKey()).collect(Collectors.toList());
        State genesisState = Init.createState((AccountKey)genPK, (AccountKey)genPK, PEERKEYS);
        try {
            DefaultListModel<ConvexLocal> peerList = new DefaultListModel<ConvexLocal>();
            List serverList = API.launchLocalPeers(KEYPAIRS, (State)genesisState);
            for (Server server : serverList) {
                Address controller = server.getPeerController();
                AKeyPair kp2 = server.getControllerKey();
                ConvexLocal convex = Convex.connect((Server)server, (Address)controller, (AKeyPair)kp2);
                if (kp2 == null) {
                    kp2 = KeyRingPanel.findWalletEntry((Convex)convex).getKeyPair();
                    convex.setKeyPair(kp2);
                }
                peerList.addElement(convex);
                HotWalletEntry we = HotWalletEntry.create((AKeyPair)server.getKeyPair(), (String)"Peer key pair (temp)");
                KeyRingPanel.addWalletEntry((AWalletEntry)we);
            }
            return peerList;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PeerException("Peer launch interrupted", (Throwable)e);
        }
    }

    private PeerGUI(DefaultListModel<ConvexLocal> peerList) throws PeerException {
        super("Peer Manager");
        this.latestState = StateModel.create(this.genesisState);
        this.tickState = StateModel.create(0L);
        this.peerList = new DefaultListModel();
        this.updateRunning = true;
        this.cp = 0L;
        this.updateThread = new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("PeerGUI update thread");
                while (PeerGUI.this.updateRunning) {
                    try {
                        Thread.sleep(100L);
                        PeerGUI.this.tickState.setValue(PeerGUI.this.tickState.getValue() + 1L);
                        List<ConvexLocal> peerViews = PeerGUI.this.serverPanel.getPeerViews();
                        PeerGUI.this.serverPanel.repaint();
                        State latest = PeerGUI.this.latestState.getValue();
                        for (ConvexLocal s : peerViews) {
                            Order order;
                            Peer p;
                            Server serv = s.getLocalServer();
                            if (serv == null || (p = serv.getPeer()) == null || (order = p.getPeerOrder()) == null) continue;
                            maxBlock = Math.max(maxBlock, order.getBlockCount());
                            long pcp = p.getFinalityPoint();
                            if (pcp <= PeerGUI.this.cp) continue;
                            PeerGUI.this.cp = pcp;
                            latest = p.getConsensusState();
                        }
                        PeerGUI.this.latestState.setValue(latest);
                    }
                    catch (InterruptedException e) {
                        PeerGUI.this.updateRunning = false;
                        Thread.currentThread().interrupt();
                        log.trace("Update thread interrupted, presumably shutting down");
                    }
                }
                log.debug("GUI Peer Manager update thread ending");
            }
        };
        this.peerList = peerList;
        Server firstServer = peerList.get(0).getLocalServer();
        this.genesisState = firstServer.getPeer().getGenesisState();
        this.latestState = StateModel.create(this.genesisState);
        this.tickState = StateModel.create(0L);
        this.serverPanel = new ServerListPanel(this);
        this.keyRingPanel = new KeyRingPanel();
        Server first = peerList.firstElement().getLocalServer();
        ConvexLocal convex = Convex.connect((Server)first);
        try {
            this.restServer = RESTServer.create((Server)first);
            this.restServer.start();
            REST_PORT = this.restServer.getPort();
        }
        catch (Exception t) {
            log.warn("Unable to start REST Server: ", (Throwable)t);
        }
        this.keyGenPanel = new KeyGenPanel(this);
        this.messagePanel = new MessageFormatPanel();
        this.accountsPanel = new AccountsPanel(convex, this.latestState);
        this.setLayout(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.tabs.setPreferredSize(new Dimension(1000, 800));
        this.add((Component)this.tabs, "Center");
        this.tabs.add("Peer Servers", this.serverPanel);
        this.tabs.add("Accounts", this.accountsPanel);
        this.tabs.add("Keyring", this.keyRingPanel);
        this.tabs.add("KeyGen", this.keyGenPanel);
        this.tabs.add("Message", this.messagePanel);
        this.tabs.add("Torus", new TorusPanel(this));
        this.tabs.add("About", new AboutPanel(convex));
        this.tabs.setSelectedComponent(this.serverPanel);
        ThreadUtils.runVirtual((Runnable)this.updateThread);
    }

    public DefaultListModel<ConvexLocal> getPeerList() {
        return this.peerList;
    }

    public void finalize() {
        this.updateRunning = false;
    }

    public void switchPanel(String title) {
        int n = this.tabs.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!this.tabs.getTitleAt(i).contentEquals(title)) continue;
            this.tabs.setSelectedIndex(i);
            return;
        }
        log.info("Missing tab: " + title);
    }

    public KeyRingPanel getWalletPanel() {
        return this.keyRingPanel;
    }

    public Convex makeConnection(Address address, AKeyPair kp) throws IOException, TimeoutException, InterruptedException {
        InetSocketAddress host = this.getDefaultConvex().getHostAddress();
        return Convex.connect((InetSocketAddress)host, (Address)address, (AKeyPair)kp);
    }

    public State getLatestState() {
        return this.latestState.getValue();
    }

    public StateModel<State> getStateModel() {
        return this.latestState;
    }

    public ConvexLocal getDefaultConvex() {
        int n = this.peerList.size();
        for (int i = 0; i < n; ++i) {
            ConvexLocal c = this.peerList.get(i);
            if (!c.getLocalServer().isLive()) continue;
            return c;
        }
        throw new IllegalStateException("No live peers we control!");
    }

    public Convex getClientConvex(Address contract) {
        return Convex.connect((Server)this.getPrimaryServer(), (Address)contract, null);
    }

    public Convex connectClient(Address address, AKeyPair keyPair) throws IOException, TimeoutException, InterruptedException {
        return this.makeConnection(address, keyPair);
    }

    public static StateModel<Peer> getStateModel(Convex peer) {
        Server s = peer.getLocalServer();
        if (s != null) {
            StateModel<Peer> model = models.get(s);
            if (model != null) {
                return model;
            }
            StateModel<Peer> newModel = StateModel.create(s.getPeer());
            s.getCVMExecutor().setUpdateHook(p -> {
                AStore tempStore = Stores.current();
                try {
                    Stores.setCurrent((AStore)s.getStore());
                    newModel.setValue((Peer)p);
                }
                finally {
                    Stores.setCurrent((AStore)tempStore);
                }
            });
            models.put(s, newModel);
            return newModel;
        }
        return null;
    }

    public static long getMaxBlockCount() {
        return maxBlock;
    }

    public Server getRandomServer() {
        Server result = null;
        int n = this.peerList.getSize();
        int found = 0;
        for (int i = 0; i < n; ++i) {
            ConvexLocal c = this.peerList.elementAt(i);
            Server s = c.getLocalServer();
            if (s == null || !s.isLive()) continue;
            ++found;
            if (!(Math.random() * (double)found <= 1.0)) continue;
            result = s;
        }
        return result;
    }

    public Server getPrimaryServer() {
        int n = this.peerList.getSize();
        for (int i = 0; i < n; ++i) {
            ConvexLocal c = this.peerList.elementAt(i);
            Server s = c.getLocalServer();
            if (s == null || !s.isLive()) continue;
            return s;
        }
        return null;
    }

    public void launchExtraPeer(ConvexLocal source) {
        AKeyPair kp = AKeyPair.generate();
        try {
            Server base = source.getLocalServer();
            Address a = source.createAccountSync(kp.getAccountKey());
            long amt = source.getBalance() / 10L;
            source.transferSync(a, amt);
            KeyRingPanel.addWalletEntry((AWalletEntry)HotWalletEntry.create((AKeyPair)kp, (String)"Generated peer key"));
            ConvexLocal convex = Convex.connect((Server)base, (Address)a, (AKeyPair)kp);
            AccountKey key = kp.getAccountKey();
            Result rcr = convex.transactSync("(create-peer " + String.valueOf(key) + " " + amt / 2L + ")");
            if (rcr.isError()) {
                throw new Exception(rcr.toString());
            }
            HashMap<Keyword, Object> config = new HashMap<Keyword, Object>();
            config.put(Keywords.KEYPAIR, kp);
            config.put(Keywords.CONTROLLER, a);
            config.put(Keywords.SOURCE, convex);
            Server server = API.launchPeer(config);
            server.getCVMExecutor().setPeer(server.syncPeer(kp, (Convex)convex));
            server.getConnectionManager().connectToPeer(base.getHostAddress());
            server.setHostname("localhost:" + server.getPort());
            base.getConnectionManager().connectToPeer(server.getHostAddress());
            convex = Convex.connect((Server)server, (Address)a, (AKeyPair)kp);
            this.peerList.addElement(convex);
        }
        catch (Exception e) {
            Toast.display((JComponent)this, "Error launching extra peer: " + e.getMessage(), Color.RED);
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        this.updateRunning = false;
        DefaultListModel<ConvexLocal> peerList = this.getPeerList();
        int n = peerList.getSize();
        for (int i = 0; i < n; ++i) {
            Convex p = (Convex)peerList.getElementAt(i);
            try {
                p.getLocalServer().close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.close();
    }

    public void addPeer(ConvexLocal cvl) {
        this.peerList.addElement(cvl);
    }

    @Override
    public void setupFrame(JFrame frame) {
        frame.getContentPane().setLayout((LayoutManager)new MigLayout());
        frame.getContentPane().add((Component)this, "dock center");
    }
}

