/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.keys;

import convex.api.Convex;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.PFXTools;
import convex.core.crypto.wallet.AWalletEntry;
import convex.core.crypto.wallet.HotWalletEntry;
import convex.core.crypto.wallet.KeystoreWalletEntry;
import convex.core.cvm.Address;
import convex.core.cvm.Symbols;
import convex.core.cvm.ops.Special;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Symbol;
import convex.core.lang.RT;
import convex.core.util.FileUtils;
import convex.core.util.Utils;
import convex.gui.components.ActionButton;
import convex.gui.components.ActionPanel;
import convex.gui.components.ScrollyList;
import convex.gui.components.Toast;
import convex.gui.keys.WalletComponent;
import convex.gui.utils.Toolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyRingPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger((String)KeyRingPanel.class.getName());
    private static DefaultListModel<AWalletEntry> listModel = new DefaultListModel();
    ScrollyList<AWalletEntry> walletList;

    public static void addWalletEntry(AWalletEntry we) {
        listModel.addElement(we);
        log.debug("Wallet entry added to KeyRing: ", (Object)we.getPublicKey());
    }

    public KeyRingPanel() {
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.walletList = new ScrollyList<AWalletEntry>(listModel, we -> new WalletComponent((AWalletEntry)we));
        this.add(this.walletList, "dock center");
        ActionPanel toolBar = new ActionPanel();
        ActionButton btnNew = new ActionButton("New Keypair", 57669, e -> {
            AKeyPair newKP = AKeyPair.generate();
            try {
                listModel.addElement((AWalletEntry)HotWalletEntry.create((AKeyPair)newKP, (String)"Generated key (in memory)"));
                Toolkit.scrollToBottom(this.walletList);
            }
            catch (Exception t) {
                Toast.display((JComponent)this, "Error creating key pair: " + t.getMessage(), Color.RED);
                t.printStackTrace();
            }
        });
        btnNew.setToolTipText("Create a new random hot wallet keypair. Remember to save the key if you want to re-use!");
        toolBar.add(btnNew);
        ActionButton btnImportSeed = new ActionButton("Import Seed....", 59536, e -> {
            String sd = (String)JOptionPane.showInputDialog(this, "Enter Ed25519 Seed", "Import private key", 3, Toolkit.menuIcon(59536), null, "");
            if (sd == null) {
                return;
            }
            Blob seed = Blob.parse((String)sd);
            if (seed == null) {
                return;
            }
            try {
                AKeyPair newKP = AKeyPair.create((Blob)seed);
                listModel.addElement((AWalletEntry)HotWalletEntry.create((AKeyPair)newKP, (String)"Imported from Ed25519 seed"));
            }
            catch (Exception t) {
                Toast.display((JComponent)this, "Exception importing seed: " + t.getMessage(), Color.RED);
                t.printStackTrace();
            }
        });
        btnImportSeed.setToolTipText("Import a key pair using an Ed25519 seed");
        toolBar.add(btnImportSeed);
        ActionButton btnLoadKeys = new ActionButton("Load Keys....", 59536, this::loadStore);
        btnLoadKeys.setToolTipText("Load keys from a Keystore file");
        toolBar.add(btnLoadKeys);
        this.add((Component)toolBar, "dock south");
    }

    private void loadStore(ActionEvent e) {
        try {
            File f = KeyRingPanel.chooseKeyStore(this, "Load");
            if (f == null) {
                return;
            }
            if (f.exists()) {
                KeyStore ks = PFXTools.loadStore((File)f, null);
                int num = KeyRingPanel.loadKeys(ks, "Loaded from " + f.getCanonicalPath());
                Toolkit.showMessge(this, num + " new keys loaded.");
            }
        }
        catch (IOException | GeneralSecurityException e1) {
            e1.printStackTrace();
        }
    }

    private static File chooseKeyStore(Component parent, String action) {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("PKCS #12 Keystore", "p12", "pfx");
        chooser.setFileFilter(filter);
        File defaultDir = FileUtils.getFile((String)"~/.convex/keystore.pfx");
        if (defaultDir.isDirectory()) {
            chooser.setCurrentDirectory(defaultDir);
        } else {
            chooser.setCurrentDirectory(defaultDir.getParentFile());
        }
        int returnVal = chooser.showDialog(parent, action);
        if (returnVal != 0) {
            return null;
        }
        File f = chooser.getSelectedFile();
        return f;
    }

    private static int loadKeys(File f) {
        if (!f.exists()) {
            return -1;
        }
        try {
            KeyStore ks = PFXTools.loadStore((File)f, null);
            return KeyRingPanel.loadKeys(ks, "Default KeyStore: " + f.getCanonicalPath());
        }
        catch (IOException e) {
            log.debug("Can't load key store: " + e.getMessage());
            return -1;
        }
        catch (GeneralSecurityException e) {
            log.debug("Can't load key store: " + e.getMessage());
            return -1;
        }
    }

    private static int loadKeys(KeyStore keyStore, String source) throws KeyStoreException {
        int numImports = 0;
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            KeystoreWalletEntry we = KeystoreWalletEntry.create((KeyStore)keyStore, (String)alias, (String)source);
            we.tryUnlock(null);
            AWalletEntry existing = KeyRingPanel.getKeyRingEntry(we.getPublicKey());
            if (existing != null) continue;
            listModel.addElement((AWalletEntry)we);
            ++numImports;
        }
        return numImports;
    }

    public static DefaultListModel<AWalletEntry> getListModel() {
        return listModel;
    }

    public static AWalletEntry findWalletEntry(Convex convex) {
        Address a = convex.getAddress();
        if (a == null) {
            return null;
        }
        try {
            CompletionStage cf = convex.query((ACell)Special.forSymbol((Symbol)Symbols.STAR_KEY)).thenApply(r -> r.getValue());
            AccountKey key = RT.ensureAccountKey((ACell)((ACell)((CompletableFuture)cf).get()));
            AWalletEntry we = KeyRingPanel.getKeyRingEntry(key);
            return we;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static AWalletEntry getKeyRingEntry(AccountKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        DefaultListModel<AWalletEntry> list = KeyRingPanel.getListModel();
        Iterator<AWalletEntry> it = list.elements().asIterator();
        while (it.hasNext()) {
            AWalletEntry we = it.next();
            if (!Utils.equals((ACell)we.getPublicKey(), (ACell)publicKey)) continue;
            return we;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveKey(Component parent, AWalletEntry walletEntry) {
        boolean locked = walletEntry.isLocked();
        try {
            boolean unlock;
            File f = KeyRingPanel.chooseKeyStore(parent, "Save Key");
            if (f == null) {
                boolean bl = false;
                return bl;
            }
            KeyStore ks = f.exists() ? PFXTools.loadStore((File)f, null) : PFXTools.createStore((File)f, null);
            String s = JOptionPane.showInputDialog(parent, (Object)"Enter key encryption password");
            if (s == null) {
                boolean bl = false;
                return bl;
            }
            if (locked && !(unlock = walletEntry.tryUnlock(s.toCharArray()))) {
                Toolkit.showMessge(parent, "Could not unlock key with this password");
                boolean bl = false;
                return bl;
            }
            PFXTools.setKeyPair((KeyStore)ks, (AKeyPair)walletEntry.getKeyPair(), (char[])s.toCharArray());
            PFXTools.saveStore((KeyStore)ks, (File)f, null);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Toolkit.showErrorMessage(parent, "Failed to save to KeyStore", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (locked) {
                walletEntry.lock();
            }
        }
    }

    static {
        try {
            File f = FileUtils.getFile((String)"~/.convex/keystore.pfx");
            KeyRingPanel.loadKeys(f);
        }
        catch (Exception e) {
            log.warn("Failed to load default key store: " + e.getMessage());
        }
    }
}

