/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.keys;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.BIP39;
import convex.core.crypto.Passwords;
import convex.core.crypto.SLIP10;
import convex.core.crypto.wallet.AWalletEntry;
import convex.core.crypto.wallet.HotWalletEntry;
import convex.core.data.AArrayBlob;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Blobs;
import convex.core.util.Utils;
import convex.gui.components.ActionButton;
import convex.gui.components.ActionPanel;
import convex.gui.components.Identicon;
import convex.gui.components.RightCopyMenu;
import convex.gui.keys.KeyRingPanel;
import convex.gui.peer.PeerGUI;
import convex.gui.utils.Toolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;

public class KeyGenPanel
extends JPanel {
    private static final String NOTE_CONSTRAINT = "align 25%,span,width 100:800:1000";
    private static final String TEXTAREA_CONSTRAINT = "grow,width 10:500:800";
    JTextArea mnemonicArea;
    JPasswordField passArea;
    JTextArea seedArea;
    JTextArea warningArea;
    JTextArea masterKeyArea;
    JTextArea derivationArea;
    JTextArea derivedKeyArea;
    JTextArea privateKeyArea;
    JTextArea publicKeyArea;
    JSpinner numSpinner;
    ActionButton addWalletButton;
    JPanel formPanel;
    static Font HEX_FONT = Toolkit.MONO_FONT;
    static final int CC = 864;
    static final String DEAFULT_BIP32_PATH = "m/44/864/0/0/0";
    int[] derivationPath = null;
    private Identicon identicon;

    protected String hexKeyFormat(String pk) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pk.length() / 32; ++i) {
            if (i > 0) {
                sb.append('\n');
            }
            for (int j = 0; j < 4; ++j) {
                if (j > 0) {
                    sb.append(' ');
                }
                int ix = 8 * (j + i * 4);
                sb.append(pk.substring(ix, ix + 8));
            }
        }
        return sb.toString();
    }

    private void updateMnemonic() {
        this.generateBIP39Seed();
    }

    private void updatePass() {
        this.generateBIP39Seed();
    }

    private void generateBIP39Seed() {
        String p;
        String s = this.mnemonicArea.getText();
        String warn = this.checkWarnings(s, p = new String(this.passArea.getPassword()));
        if (warn.isBlank()) {
            this.warningArea.setForeground(Color.GREEN);
            this.warningArea.setText("OK: Reasonable mnemonic and passphrase");
        } else {
            this.warningArea.setForeground(Color.ORANGE);
            this.warningArea.setText("WARNING: " + warn);
        }
        try {
            Blob bipSeed = BIP39.getSeed((String)s, (String)p);
            this.seedArea.setText(bipSeed.toHexString());
            this.deriveSeed();
        }
        catch (Exception ex) {
            String pks = "<mnemonic not valid>";
            if (s.isBlank()) {
                pks = "<enter valid private key or mnemonic>";
            }
            this.masterKeyArea.setText(pks);
            this.warningArea.setText("");
            this.derivedKeyArea.setText(pks);
            this.privateKeyArea.setText(pks);
        }
    }

    private String checkWarnings(String s, String p) {
        Object warn = "";
        if (s.equals("sing bomb stay manual powder hard north mixture sausage lunch retreat desert")) {
            warn = (String)warn + "Demo mnemonic (for testing only). ";
        }
        if (p.equals("hello1234567890ZZ")) {
            warn = (String)warn + "Demo passphrase (for testing only). ";
        }
        List words = BIP39.getWords((String)s);
        String badWord = BIP39.checkWords((List)words);
        int numWords = words.size();
        if (numWords < 12) {
            warn = (String)warn + "Only " + numWords + " words. ";
        } else if (numWords != numWords / 3 * 3 || numWords > 24) {
            warn = (String)warn + "Unusual number of words (" + numWords + "). ";
        } else if (badWord != null) {
            warn = BIP39.extendWord((String)badWord) != null ? (String)warn + "Should normalise abbreviated word: " + badWord + ". " : (String)warn + "Not in standard word list: " + badWord.toUpperCase() + ". ";
        } else if (!s.equals(BIP39.normaliseFormat((String)s))) {
            warn = (String)warn + "Not normalised! ";
        } else if (!BIP39.checkSum((String)s)) {
            warn = (String)warn + "Invalid checksum! ";
        }
        if (p.isBlank()) {
            warn = (String)warn + "Passphrase is blank! ";
        } else {
            int entropy = Passwords.estimateEntropy((String)p);
            if (entropy < 10) {
                warn = (String)warn + "Very weak passphrase! ";
            } else if (entropy < 20) {
                warn = (String)warn + "Weak passphrase. ";
            } else if (entropy < 30) {
                warn = (String)warn + "Moderate passphrase. ";
            }
        }
        return warn;
    }

    private void updatePath() {
        try {
            String path = this.derivationArea.getText();
            this.derivationPath = BIP39.parsePath((String)path);
            this.deriveSeed();
        }
        catch (Exception ex) {
            this.privateKeyArea.setText(ex.getMessage());
            this.publicKeyArea.setText(ex.getMessage());
            this.derivationPath = null;
            return;
        }
    }

    private void updateSeed() {
        this.mnemonicArea.setText("<can't recreate from BIP39 seed>");
        this.deriveSeed();
    }

    private void deriveSeed() {
        try {
            Blob b = Blobs.parse((String)this.seedArea.getText()).toFlatBlob();
            if (b == null) {
                throw new IllegalArgumentException("<invalid BIP39 seed>");
            }
            Blob mb = SLIP10.getMaster((Blob)b);
            this.masterKeyArea.setText(mb.toHexString());
            this.derivationPath = BIP39.parsePath((String)this.derivationArea.getText());
            Blob db = this.derivationPath == null ? mb : SLIP10.derive((Blob)mb, (int[])this.derivationPath);
            this.derivedKeyArea.setText(db.toHexString());
            this.privateKeyArea.setText(db.slice(0L, 32L).toHexString());
            this.generatePublicKey();
        }
        catch (Exception ex) {
            this.privateKeyArea.setText(ex.getMessage());
            this.publicKeyArea.setText(ex.getMessage());
            return;
        }
    }

    private void updatePrivateKey() {
        try {
            String msg = "<can't recreate from private seed>";
            this.mnemonicArea.setText(msg);
            this.seedArea.setText(msg);
            this.masterKeyArea.setText(msg);
            this.derivedKeyArea.setText(msg);
            this.generatePublicKey();
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            return;
        }
    }

    private void generatePublicKey() {
        String s = this.privateKeyArea.getText().trim();
        try {
            if (s.startsWith("0x")) {
                s = s.substring(2);
            }
            Blob b = Blob.fromHex((String)Utils.stripWhiteSpace((String)s));
            AKeyPair kp = AKeyPair.create((byte[])b.getBytes());
            AccountKey publicKey = kp.getAccountKey();
            this.publicKeyArea.setText("0x" + publicKey.toChecksumHex());
            this.addWalletButton.setEnabled(true);
            this.identicon.setKey((AArrayBlob)publicKey);
        }
        catch (Exception ex) {
            this.publicKeyArea.setText("<enter valid private key>");
            this.addWalletButton.setEnabled(false);
            return;
        }
    }

    public KeyGenPanel(PeerGUI manager) {
        this.setLayout((LayoutManager)new MigLayout());
        this.formPanel = new JPanel();
        this.formPanel.setLayout((LayoutManager)new MigLayout("wrap 3", "[][40]10[grow,fill]", ""));
        this.add((Component)this.formPanel, "dock center");
        this.addNote("Seed Phrase", "Press 'Generate' to create a Mnemonic seed phrase (normally 12 words) or enter words you have already created elsewhere. You should also use a good passphrase. Keep a safe backup.");
        this.addLabel("Mnemonic Phrase", "BIP39 Mnemonic phrase. These should be 12, 15, 18, 21 or 24 random words from the BIP39 standard word list.\n\nKeep a secure offline backup of this along with the passphrase so that you can re-generate your key pairs if required. If you are serious about your key security, engraving on metal plates and locking in a safe is a reasonable idea.");
        this.mnemonicArea = this.makeTextArea();
        this.mnemonicArea.setWrapStyleWord(true);
        this.mnemonicArea.setLineWrap(true);
        this.mnemonicArea.setRows(2);
        this.mnemonicArea.setBackground(Color.BLACK);
        this.formPanel.add((Component)this.mnemonicArea, TEXTAREA_CONSTRAINT);
        this.mnemonicArea.getDocument().addDocumentListener(Toolkit.createDocumentListener(() -> {
            if (!this.mnemonicArea.isFocusOwner()) {
                return;
            }
            this.updateMnemonic();
        }));
        this.addLabel("Passphrase", "BIP39 secret passphrase. This acts as a secret 'extra word' to generate the BIP39 seed alongside the mnemonic. Strong passphrase recommended.\n\nYou can leave this blank, but then anyone with access to the mnemonic words can easily re-create and use your keys.");
        this.passArea = new JPasswordField();
        this.passArea.setBackground(Color.BLACK);
        this.formPanel.add(Toolkit.wrapPasswordField(this.passArea));
        this.passArea.getDocument().addDocumentListener(Toolkit.createDocumentListener(() -> {
            if (!this.passArea.isFocusOwner()) {
                return;
            }
            this.updatePass();
        }));
        this.formPanel.add(new JPanel());
        this.formPanel.add(new JPanel());
        this.warningArea = this.makeTextArea();
        this.warningArea.setLineWrap(true);
        this.warningArea.setWrapStyleWord(true);
        this.warningArea.setEditable(false);
        this.warningArea.setToolTipText("This is a quick heuristic check of mnemonic and passphrase.\nHeeding any warnings is advised, but you can ignore them if you know what you are doing (or don't care).");
        this.formPanel.add((Component)this.warningArea, TEXTAREA_CONSTRAINT);
        this.addNote("Key Derivation", "Below are the BIP39 / SLIP-10 key derivation steps. You can usually ignore these, but they are available in case you want to verify or modify the key derivation steps.");
        this.addLabel("BIP39 Seed", "This is the BIP39 seed generated from the mnemonic and passphrase. You can also enter this directly.");
        this.seedArea = this.makeTextArea();
        this.seedArea.setRows(2);
        this.seedArea.setLineWrap(true);
        this.seedArea.setWrapStyleWord(false);
        this.seedArea.setBackground(Color.BLACK);
        this.formPanel.add((Component)this.seedArea, TEXTAREA_CONSTRAINT);
        this.seedArea.setText("(mnemonic not ready)");
        this.seedArea.getDocument().addDocumentListener(Toolkit.createDocumentListener(() -> {
            if (!this.seedArea.isFocusOwner()) {
                return;
            }
            this.updateSeed();
        }));
        this.addLabel("SLIP-10 Master Key", "SLIP-10 creates a Master Key from the BIP39 seed, which acts as the root of key generation for a heirarchical deterministic wallet.");
        this.masterKeyArea = this.makeTextArea();
        this.masterKeyArea.setLineWrap(true);
        this.masterKeyArea.setWrapStyleWord(false);
        this.masterKeyArea.setEditable(false);
        this.formPanel.add((Component)this.masterKeyArea, TEXTAREA_CONSTRAINT);
        this.masterKeyArea.setText("(not ready)");
        this.addLabel("BIP32 Path", "This is the hierarchical path for key generation as defined in BIP32. \n - 'm' specifies the master key. \n - 44 is the purpose defined as BIP-44. \n - 864 is the Convex SLIP-0044 chain code. \n - The other numbers (account, change, index) may be set at the user's discretion, but are zero by default. \n\nIf you want multiple keys for the same mnemomic, is is recommended to increment the account number. \n\nWARNING: if you change these values, you will need to retain them in order to recover the specified key.");
        this.derivationArea = this.makeTextArea();
        this.derivationArea.setLineWrap(true);
        this.derivationArea.setWrapStyleWord(false);
        this.derivationArea.setBackground(Color.BLACK);
        this.formPanel.add((Component)this.derivationArea, TEXTAREA_CONSTRAINT);
        this.derivationArea.setText(DEAFULT_BIP32_PATH);
        this.derivationArea.getDocument().addDocumentListener(Toolkit.createDocumentListener(() -> {
            if (!this.derivationArea.isFocusOwner()) {
                return;
            }
            this.updatePath();
        }));
        this.addLabel("SLIP-10 Ext. Priv. Key", "This is the extended private key produced by SLIP-10 after applying the BIP32 derivation path. \nThe first 32 bytes of the SLIP-10 extended private key are used as the Ed25519 seed.");
        this.derivedKeyArea = this.makeTextArea();
        this.derivedKeyArea.setLineWrap(true);
        this.derivedKeyArea.setWrapStyleWord(false);
        this.derivedKeyArea.setEditable(false);
        this.formPanel.add((Component)this.derivedKeyArea, TEXTAREA_CONSTRAINT);
        this.derivedKeyArea.setText("(not ready)");
        this.addNote("Ed5519 Key Pair", "Below is the Ed25519 Key Pair that is actually used by Convex. You can safely share the public key and Identicon image. Keep the private seed secret!");
        this.addLabel("Private Ed25519 seed", "This is the Ed25519 private seed you need to sign transactions in Convex. \nAny 32-byte hex value will work: you can enter this directly if you obtained a good secret random seed from another source.", true);
        this.privateKeyArea = this.makeTextArea();
        this.privateKeyArea.setBackground(Color.BLACK);
        this.formPanel.add((Component)this.privateKeyArea, TEXTAREA_CONSTRAINT);
        this.privateKeyArea.setText("(mnemonic not ready)");
        this.privateKeyArea.getDocument().addDocumentListener(Toolkit.createDocumentListener(() -> {
            if (!this.privateKeyArea.isFocusOwner()) {
                return;
            }
            this.updatePrivateKey();
        }));
        this.addLabel("Ed25519 Public Key", "This is the Ed25519 public key, which can be shared publicly and may be used as the account key for a Convex account.", true);
        this.publicKeyArea = this.makeTextArea();
        this.publicKeyArea.setEditable(false);
        this.publicKeyArea.setRows(1);
        this.publicKeyArea.setText("(private key not ready)");
        this.publicKeyArea.setFont(HEX_FONT);
        this.formPanel.add((Component)this.publicKeyArea, TEXTAREA_CONSTRAINT);
        this.identicon = new Identicon(null, Toolkit.IDENTICON_SIZE_LARGE);
        this.addLabel("Identicon", "This is a visual representation of the public key. It can be used to visually identify different keys.");
        this.formPanel.add((Component)this.identicon, "growx 0");
        ActionPanel actionPanel = new ActionPanel();
        this.add((Component)actionPanel, "dock south");
        ActionButton btnRecreate = new ActionButton("Generate", 58837, e -> {
            Integer wc = (Integer)this.numSpinner.getValue();
            this.mnemonicArea.setText(BIP39.createSecureMnemonic((int)wc));
            this.updateMnemonic();
        });
        btnRecreate.setToolTipText("Press to generate a new random mnemonic and derive all subsequent keys.");
        actionPanel.add(btnRecreate);
        this.numSpinner = new JSpinner();
        this.numSpinner.setModel(new SpinnerNumberModel(12, 12, 24, 3));
        this.numSpinner.setEditor(new JSpinner.DefaultEditor(this.numSpinner));
        this.numSpinner.setFocusable(false);
        actionPanel.add(this.numSpinner);
        ActionButton btnNormalise = new ActionButton("Normalise Mnemonic", 61695, e -> {
            String s = this.mnemonicArea.getText();
            String s2 = BIP39.normaliseAll((String)s);
            this.mnemonicArea.setText(s2);
            this.updateMnemonic();
        });
        btnNormalise.setToolTipText("Press to normalise mnemonic text according to BIP39. Removes irregular whitespace, sets characters to lowercase, highlights faulty words.");
        actionPanel.add(btnNormalise);
        this.addWalletButton = new ActionButton("Add to keyring", 57669, e -> {
            String pks = this.privateKeyArea.getText();
            pks = Utils.stripWhiteSpace((String)pks);
            Blob privateSeed = Blob.parse((String)pks);
            HotWalletEntry we = HotWalletEntry.create((AKeyPair)AKeyPair.create((Blob)privateSeed), (String)"Generated via KeyGen");
            KeyRingPanel.addWalletEntry((AWalletEntry)we);
            if (manager != null) {
                manager.switchPanel("Keyring");
            }
        });
        this.addWalletButton.setToolTipText("Press to add this public / private key pair to the Keyring.");
        actionPanel.add(this.addWalletButton);
        this.addWalletButton.setEnabled(false);
    }

    private void addLabel(String labelText, String helpText, boolean bold) {
        JLabel lblMnemonic = new JLabel(labelText);
        if (bold) {
            lblMnemonic.setFont(lblMnemonic.getFont().deriveFont(1));
        }
        this.formPanel.add(lblMnemonic);
        this.formPanel.add(Toolkit.makeHelp(helpText));
    }

    private void addNote(String title, String s) {
        JComponent ta = Toolkit.makeNote(title, s);
        this.formPanel.add((Component)ta, NOTE_CONSTRAINT);
    }

    private JTextArea makeTextArea() {
        JTextArea ta = new JTextArea(0, 64);
        ta.setFont(HEX_FONT);
        RightCopyMenu.addTo(ta);
        return ta;
    }

    private void addLabel(String labelText, String helpText) {
        this.addLabel(labelText, helpText, false);
    }
}

