/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.dlfs;

import convex.core.util.ThreadUtils;
import convex.gui.components.CodeLabel;
import convex.gui.dlfs.DirectoryTree;
import convex.gui.dlfs.DnDTransferHandler;
import convex.gui.dlfs.FileList;
import convex.gui.dlfs.PreviewPanel;
import convex.lattice.fs.DLFileSystem;
import convex.lattice.fs.DLPath;
import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.file.Path;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import net.miginfocom.swing.MigLayout;

public class DLFSPanel
extends JPanel {
    protected DLFileSystem fileSystem;
    JLabel pathLabel;
    DirectoryTree directoryTree;
    FileList fileList;
    CodeLabel infoLabel = new CodeLabel("READY");
    private DLPath selectedPath;
    private PreviewPanel previewPanel;

    public DLFSPanel(DLFileSystem dlfs) {
        this.fileSystem = dlfs;
        this.selectedPath = dlfs.getRoot();
        this.setLayout((LayoutManager)new MigLayout());
        this.directoryTree = new DirectoryTree(dlfs);
        this.directoryTree.setTransferHandler(new DnDTransferHandler(this){

            @Override
            protected Path getTargetPath() {
                return DLFSPanel.this.getSelectedPath();
            }
        });
        this.directoryTree.addTreeSelectionListener(e -> {
            DirectoryTree.Node node = (DirectoryTree.Node)this.directoryTree.getLastSelectedPathComponent();
            if (node == null) {
                this.setSelectedPath(null);
            } else {
                Path p = node.getFilePath();
                this.setSelectedPath(p);
            }
        });
        this.fileList = new FileList((Path)this.selectedPath, p -> this.setSelectedPath((Path)p));
        this.fileList.setTransferHandler(new DnDTransferHandler(this){

            @Override
            protected Path getTargetPath() {
                return DLFSPanel.this.getSelectedPath();
            }
        });
        this.fileList.addListSelectionListener(e -> {
            Path p = this.fileList.getSelectedPath();
            this.previewPanel.setPath(p);
        });
        JScrollPane listScrollPane = new JScrollPane(this.fileList);
        JSplitPane filesSplitPane = new JSplitPane(1, new JScrollPane(this.directoryTree), listScrollPane);
        filesSplitPane.setResizeWeight(0.5);
        this.previewPanel = new PreviewPanel();
        JScrollPane scrollPreview = new JScrollPane(this.previewPanel);
        JSplitPane splitPane = new JSplitPane(1, filesSplitPane, scrollPreview);
        splitPane.setResizeWeight(0.5);
        this.add((Component)splitPane, "dock center");
        this.pathLabel = new JLabel("/");
        this.add((Component)this.pathLabel, "dock north");
        this.add((Component)this.infoLabel, "dock south");
        this.directoryTree.setSelectionPath(this.directoryTree.getPathForRow(0));
        ThreadUtils.runVirtual(() -> {
            try {
                while (this.fileSystem.isOpen()) {
                    this.fileSystem.updateTimestamp();
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    public DLFileSystem getFileSystem() {
        return this.fileSystem;
    }

    void setSelectedPath(Path newPath) {
        if (!(newPath instanceof DLPath)) {
            this.pathLabel.setText("No path selected");
            this.selectedPath = null;
            return;
        }
        this.selectedPath = (DLPath)newPath;
        this.fileList.setDirectory(newPath);
        this.infoLabel.setText("ROOT HASH: " + String.valueOf(this.fileSystem.getRootHash()) + "\nNODE HASH: " + String.valueOf(this.fileSystem.getNodeHash(this.selectedPath)) + "\n");
        this.pathLabel.setText(newPath.toUri().toString());
        this.previewPanel.setPath(newPath);
    }

    public DLPath getSelectedPath() {
        return this.selectedPath;
    }

    public void refreshView() {
        this.setSelectedPath((Path)this.selectedPath);
    }
}

