/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components.account;

import convex.api.Convex;
import convex.api.ConvexLocal;
import convex.core.cvm.AccountStatus;
import convex.core.cvm.Address;
import convex.core.cvm.State;
import convex.core.lang.RT;
import convex.gui.actor.AccountWindow;
import convex.gui.components.ActionButton;
import convex.gui.components.ActionPanel;
import convex.gui.components.ConvexTable;
import convex.gui.components.renderer.AccountKeyRenderer;
import convex.gui.components.renderer.AddressRenderer;
import convex.gui.components.renderer.BalanceRenderer;
import convex.gui.components.renderer.CellRenderer;
import convex.gui.components.renderer.StringRenderer;
import convex.gui.models.AccountsTableModel;
import convex.gui.models.StateModel;
import convex.gui.wallet.WalletApp;
import convex.peer.Server;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class AccountsPanel
extends JPanel {
    AccountsTableModel tableModel;
    JTable table;

    public AccountsPanel(ConvexLocal convex, StateModel<State> model) {
        this.setLayout(new BorderLayout());
        this.tableModel = new AccountsTableModel(model.getValue());
        this.table = new ConvexTable(this.tableModel);
        model.addPropertyChangeListener(pc -> {
            State newState = (State)pc.getNewValue();
            this.tableModel.setState(newState);
        });
        JComponent cr = new AddressRenderer();
        cr.setToolTipText("Address of the Convex account. This is the unique ID for the account");
        ((DefaultTableCellRenderer)cr).setForeground(Color.WHITE);
        this.table.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)((Object)cr));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(80);
        CellRenderer actorRenderer = new CellRenderer(2){

            @Override
            public void setValue(Object o) {
                super.setValue(RT.bool((Object)o) ? "Actor" : "User");
            }
        };
        actorRenderer.setToolTipText("An Actor account is an autonomous agent or code library on the CVM. A User account can be controlled by a user with the correct key pair.");
        this.table.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(1).setCellRenderer(actorRenderer);
        cr = new StringRenderer(4);
        cr.setToolTipText("Sequence number of the account. This is the total number of user transactions executed.");
        this.table.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)((Object)cr));
        this.table.getColumnModel().getColumn(2).setPreferredWidth(60);
        cr = new BalanceRenderer();
        cr.setToolTipText("Balance of the account in Convex Coins");
        this.table.getColumnModel().getColumn(3).setCellRenderer((TableCellRenderer)((Object)cr));
        this.table.getColumnModel().getColumn(3).setPreferredWidth(180);
        cr = new StringRenderer(2);
        cr.setToolTipText("Name of the account in the Convex Registry");
        this.table.getColumnModel().getColumn(4).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(4).setCellRenderer((TableCellRenderer)((Object)cr));
        cr = new StringRenderer(4);
        cr.setToolTipText("Size of the account environment");
        this.table.getColumnModel().getColumn(5).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(5).setCellRenderer((TableCellRenderer)((Object)cr));
        cr = new StringRenderer(4);
        cr.setToolTipText("Unused memory allowance of the account");
        this.table.getColumnModel().getColumn(6).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(6).setCellRenderer((TableCellRenderer)((Object)cr));
        cr = new AddressRenderer();
        cr.setToolTipText("Account Controller. The controller may recover, modify or update the controlled account.\n\nIf set to 'nil', there is no way to recover the account without the correct private key, or if the account has existing actor code that enables recover/upgrade.");
        ((DefaultTableCellRenderer)cr).setForeground(Color.WHITE);
        this.table.getColumnModel().getColumn(7).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(7).setCellRenderer((TableCellRenderer)((Object)cr));
        cr = new AccountKeyRenderer();
        cr.setToolTipText("Ed25519 Public key of the account. Used to validate transactions from users.\n\nIf not set, then the account is an actor and can only be controlled/modified with on-chain code.");
        this.table.getColumnModel().getColumn(8).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(8).setCellRenderer((TableCellRenderer)((Object)cr));
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem copyItem = new JMenuItem("Copy Value");
        copyItem.setIcon(convex.gui.utils.Toolkit.menuIcon(57677));
        copyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountsPanel.this.copyValue();
            }
        });
        popupMenu.add(copyItem);
        convex.gui.utils.Toolkit.addPopupMenu(this.table, popupMenu);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                int r = AccountsPanel.this.table.rowAtPoint(p);
                int c = AccountsPanel.this.table.columnAtPoint(p);
                if (r >= 0 && r < AccountsPanel.this.table.getRowCount() && c >= 0 && c < AccountsPanel.this.table.getColumnCount()) {
                    AccountsPanel.this.table.setRowSelectionInterval(r, r);
                    AccountsPanel.this.table.setColumnSelectionInterval(c, c);
                } else {
                    AccountsPanel.this.table.clearSelection();
                }
            }
        });
        ActionPanel actionPanel = new ActionPanel();
        this.add((Component)actionPanel, "South");
        ActionButton btnActor = new ActionButton("Examine Account...", 62945, e -> {
            long ix = this.table.getSelectedRow();
            if (ix < 0L) {
                return;
            }
            AccountStatus as = this.tableModel.getEntry(ix);
            if (as == null) {
                return;
            }
            Address addr = Address.create((long)ix);
            AccountWindow pw = new AccountWindow((Convex)convex, model, addr);
            pw.run();
        });
        btnActor.setToolTipText("Opens a windows with utilities for examining an account");
        actionPanel.add(btnActor);
        ActionButton btnWallet = new ActionButton("Launch Wallet", 59550, e -> {
            ConvexLocal cv = Convex.connect((Server)convex.getLocalServer());
            long ix = this.table.getSelectedRow();
            if (ix < 0L) {
                return;
            }
            cv.setAddress(Address.create((long)ix));
            new WalletApp((Convex)cv).run();
        });
        btnWallet.setToolTipText("Opens a Wallet interface for this account");
        actionPanel.add(btnWallet);
        this.table.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setBackground(null);
        this.add((Component)scrollPane, "Center");
    }

    private void copyValue() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        int col = this.table.getSelectedColumn();
        if (col < 0) {
            return;
        }
        Object o = this.tableModel.getValueAt(row, col);
        String s = o == null ? "nil" : o.toString();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(s);
        clipboard.setContents(stringSelection, null);
    }
}

