/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import convex.gui.utils.Toolkit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.function.Function;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.Scrollable;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.miginfocom.swing.MigLayout;

public class ScrollyList<E>
extends JScrollPane {
    public static final int VIEWPORT_HEIGHT = 660;
    private final Function<E, Component> builder;
    private final ListModel<E> model;
    private final ScrollablePanel listPanel = new ScrollablePanel();
    private final MigLayout listLayout;

    public void refreshList() {
        boolean bottom = this.isAtBottom();
        EventQueue.invokeLater(() -> {
            this.listPanel.removeAll();
            int n = this.model.getSize();
            for (int i = 0; i < n; ++i) {
                E we = this.model.getElementAt(i);
                this.listPanel.add(this.builder.apply(we), "span");
            }
            this.revalidate();
            if (bottom) {
                EventQueue.invokeLater(() -> Toolkit.scrollToBottom(this));
            }
        });
    }

    private boolean isAtBottom() {
        JScrollBar bar = this.getVerticalScrollBar();
        int pos = bar.getValue();
        if (pos == 0) {
            return false;
        }
        return pos == bar.getMaximum();
    }

    public ScrollyList(final ListModel<E> model, final Function<E, Component> builder) {
        this.builder = builder;
        this.model = model;
        this.listLayout = new MigLayout("wrap");
        this.listPanel.setLayout((LayoutManager)this.listLayout);
        this.setViewportView(this.listPanel);
        this.getViewport().setBackground(null);
        model.addListDataListener(new ListDataListener(){
            final /* synthetic */ ScrollyList this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                int start = e.getIndex0();
                int last = e.getIndex1();
                for (int i = start; i <= last; ++i) {
                    this.this$0.listPanel.add((Component)builder.apply(model.getElementAt(i)), "wrap");
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                int start = e.getIndex0();
                int last = e.getIndex1();
                for (int i = start; i <= last; ++i) {
                    this.this$0.listPanel.remove(start);
                }
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                this.this$0.refreshList();
            }
        });
        this.refreshList();
    }

    public Component[] getListComponents() {
        return this.listPanel.getComponents();
    }

    private static class ScrollablePanel
    extends JPanel
    implements Scrollable {
        private static final int MAX_PREFERRED_HEIGHT = 800;

        private ScrollablePanel() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Dimension d = this.getPreferredSize();
            int h = d.height;
            if (h > 660) {
                h = Math.min(h, 800);
                d = new Dimension(d.width, 660);
            }
            return d;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 60;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 180;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

