/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import convex.core.util.FileUtils;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class FilePicker
extends JPanel {
    private String fileName;
    private JTextField fileField;
    private JButton button;
    private JFileChooser fileChooser;

    public FilePicker(String filename) {
        this.fileName = filename;
        this.fileChooser = new JFileChooser();
        this.setLayout((LayoutManager)new MigLayout());
        this.fileField = new JTextField(this.fileName);
        this.add(this.fileField);
        this.button = new JButton("...");
        this.button.addActionListener(this::selectFile);
        this.add(this.button);
    }

    public void setFileChooser(JFileChooser chooser) {
        this.fileChooser = chooser;
    }

    public void selectFile(ActionEvent e) {
        int selected = this.fileChooser.showDialog(this, "Select");
        if (selected == 0) {
            this.fileField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    public File getFile() {
        try {
            return FileUtils.getFile((String)this.fileField.getText());
        }
        catch (Exception e) {
            return null;
        }
    }
}

