/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import convex.core.data.prim.AInteger;
import convex.core.text.Text;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class DecimalAmountField
extends JTextField {
    protected final int decimals;

    public DecimalAmountField(int decimals) {
        super("0");
        this.decimals = decimals;
        this.setHorizontalAlignment(4);
    }

    public static DecimalFormat getNumberFormat(int decimals) {
        DecimalFormat df = new DecimalFormat("#,###" + (String)(decimals > 0 ? "." + Text.repeat((char)'#', (int)decimals) : ""));
        return df;
    }

    @Override
    protected Document createDefaultModel() {
        return new DecimalDocument();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        FontMetrics font = this.getFontMetrics(this.getFont());
        int pw = font.charWidth('0') * (10 + this.decimals);
        if (d.width < pw) {
            d.width = pw;
        }
        return d;
    }

    public AInteger getAmount() {
        String text = this.getText();
        if (text.isBlank()) {
            return null;
        }
        return DecimalAmountField.parse(text, this.decimals, true);
    }

    @Override
    public void setText(String text) {
        super.setText(text.trim());
    }

    public static AInteger parse(String text, int decimals, boolean exact) {
        try {
            text = text.trim();
            BigDecimal dec = new BigDecimal(text);
            if (decimals > 0) {
                dec = dec.multiply(new BigDecimal(BigInteger.TEN.pow(decimals)));
            }
            BigInteger bi = exact ? dec.toBigIntegerExact() : dec.toBigInteger();
            return AInteger.create((BigInteger)bi);
        }
        catch (NumberFormatException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public class DecimalDocument
    extends PlainDocument {
        @Override
        public void insertString(int offset, String s, AttributeSet a) throws BadLocationException {
            int digits;
            if (s == null) {
                return;
            }
            char[] newChars = s.toCharArray();
            int n = newChars.length;
            if (n == 0) {
                return;
            }
            String text = super.getText(0, super.getLength());
            int tlen = text.length();
            int dotPos = text.indexOf(46);
            for (int i = 0; i < n; ++i) {
                char c = newChars[i];
                if (Text.isASCIIDigit((char)c) || i == 0 && c == '.') continue;
                if (c == '.' && dotPos < 0) {
                    dotPos = i;
                    continue;
                }
                n = i;
                break;
            }
            if (n == 0) {
                return;
            }
            if (newChars[0] == '.') {
                if (dotPos >= 0) {
                    super.remove(dotPos, tlen - dotPos);
                    offset = dotPos;
                } else {
                    offset = tlen;
                    dotPos = 0;
                }
            }
            if (dotPos >= 0 && (digits = offset + n - dotPos - 1) > DecimalAmountField.this.decimals) {
                n = n - digits + DecimalAmountField.this.decimals;
            }
            String insertS = new String(newChars);
            if (n < newChars.length) {
                insertS = insertS.substring(0, n);
            }
            super.insertString(offset, insertS, a);
            DecimalAmountField.this.setCaretPosition(offset + n);
        }
    }
}

