/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import convex.gui.components.BaseTextPane;
import convex.gui.components.RightCopyMenu;
import convex.gui.utils.Toolkit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;

public class CodePane
extends BaseTextPane {
    private int maxColumns;
    private int columnWidth;

    public CodePane() {
        RightCopyMenu.addTo(this);
        this.setFont(Toolkit.MONO_FONT);
        this.setFocusTraversalKeysEnabled(false);
        this.setBackground(Color.BLACK);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        boolean track = super.getScrollableTracksViewportWidth();
        if (this.maxColumns == 0) {
            track = true;
        }
        return track;
    }

    public int getMaxColumns() {
        return this.maxColumns;
    }

    public void setMaxColumns(int maxColumns) {
        if (maxColumns < 0) {
            throw new IllegalArgumentException("Max columns must be 0 or positive");
        }
        this.maxColumns = maxColumns;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        Insets insets = this.getInsets();
        int columns = this.getMaxColumns();
        if (columns > 0) {
            if (this.maxColumns > 0 && columns > this.maxColumns) {
                columns = this.maxColumns;
            }
            int cw = this.getColumnWidth();
            d.width = columns * cw + insets.left + insets.right;
        }
        return d;
    }

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('m');
        }
        return this.columnWidth;
    }

    public int docLength() {
        return this.getDocument().getLength();
    }
}

