/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.prim.AInteger;
import convex.core.data.prim.CVMLong;
import convex.core.lang.RT;
import convex.core.text.Text;
import convex.core.util.Utils;
import convex.gui.components.BaseTextPane;
import convex.gui.components.DecimalAmountField;
import convex.gui.utils.SymbolIcon;
import convex.gui.utils.Toolkit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.math.BigInteger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class BalanceLabel
extends BaseTextPane {
    protected AInteger balance;
    public static final Color GOLD = new Color(255, 255, 0);
    public static final Color SILVER = new Color(200, 200, 230);
    public static final Color BRONZE = new Color(200, 120, 60);
    public static final Color COPPER = new Color(150, 100, 30);
    protected int decimals = 9;
    private Color balanceColour = GOLD;
    private static Color[] CCOLS = new Color[]{SILVER, BRONZE, COPPER};

    public BalanceLabel() {
        this.setEditable(false);
        this.setFocusable(false);
    }

    public void setBalance(long a) {
        this.setBalance((AInteger)CVMLong.create((long)a));
    }

    public void setDecimals(int decimals) {
        this.decimals = decimals;
        this.refreshBalance();
    }

    private synchronized void refreshBalance() {
        try {
            int i;
            if (this.balance == null) {
                super.setText("-         ");
                return;
            }
            super.setText("");
            int size = this.getFont().getSize();
            BigInteger unit = BalanceLabel.getUnit(this.decimals);
            BigInteger bi = this.balance.big();
            BigInteger change = bi.remainder(unit);
            BigInteger coins = bi.divide(unit);
            AttributeSet attribs = new SimpleAttributeSet();
            attribs = styleContext.addAttribute(attribs, StyleConstants.Alignment, 2);
            attribs = styleContext.addAttribute(attribs, StyleConstants.FontFamily, this.getFont().getFamily());
            this.setParagraphAttributes(attribs, true);
            String cs = Text.toFriendlyNumber((long)coins.longValue());
            this.append(cs, this.balanceColour, size);
            String ch = Text.zeroPad((BigInteger)change, (int)this.decimals);
            int decimalSize = size * 2 / 3;
            this.append(this.decimals > 0 ? "." : " ", SILVER, decimalSize);
            for (i = 0; i < this.decimals; i += 3) {
                Color c = BalanceLabel.changeColour(i);
                String chs = ch.substring(i, Math.min(this.decimals, i + 3));
                this.append(chs, c, decimalSize);
            }
            for (i = this.decimals; i < 9; ++i) {
                this.append("\u2007", this.balanceColour, decimalSize);
            }
            Toolkit.addPopupMenu(this, new BalanceMenu());
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            super.setText(e.getMessage());
            this.balance = null;
        }
    }

    public void setBalanceColour(Color c) {
        this.balanceColour = c;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        FontMetrics font = this.getFontMetrics(this.getFont());
        int pw = font.charWidth('0') * (10 + this.decimals);
        if (d.width < pw) {
            d.width = pw;
        }
        return d;
    }

    public void setBalance(AInteger a) {
        if (Utils.equals((ACell)a, (ACell)this.balance)) {
            return;
        }
        this.balance = a;
        this.refreshBalance();
    }

    public AInteger getBalance() {
        return this.balance;
    }

    private static Color changeColour(int i) {
        return CCOLS[i / 3 % 3];
    }

    private static BigInteger getUnit(int decimals) {
        return BigInteger.TEN.pow(decimals);
    }

    @Override
    public void setText(String s) {
        AInteger val = DecimalAmountField.parse(s, this.decimals, false);
        if (val == null) {
            super.setText("");
        } else {
            this.setBalance(val);
        }
    }

    public void setFromResult(Result r) {
        ACell bal = r.getValue();
        ACell error = r.getErrorCode();
        if (error != null) {
            if (ErrorCodes.NOBODY.equals(error)) {
                this.setText("<no account>");
            } else {
                this.setText(error.toString());
            }
            return;
        }
        if (bal instanceof AInteger) {
            this.setBalance((AInteger)bal);
        } else {
            this.setText("<bad value>");
        }
    }

    public class BalanceMenu
    extends JPopupMenu {
        JMenuItem copyMenuItem = new JMenuItem("Copy Value", SymbolIcon.get(57677, Toolkit.SMALL_ICON_SIZE));

        public BalanceMenu() {
            this.add(this.copyMenuItem);
            this.copyMenuItem.addActionListener(e -> Toolkit.copyToClipboard(RT.toString((ACell)this$0.balance)));
        }
    }
}

