/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.actor;

import convex.api.Convex;
import convex.core.Result;
import convex.core.cvm.AFn;
import convex.core.cvm.AccountStatus;
import convex.core.cvm.Address;
import convex.core.cvm.Symbols;
import convex.core.cvm.transactions.Invoke;
import convex.core.data.ACell;
import convex.core.data.AList;
import convex.core.data.AVector;
import convex.core.data.Lists;
import convex.core.data.Symbol;
import convex.core.data.Vectors;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.lang.impl.Fn;
import convex.gui.actor.ActorInvokePanel;
import convex.gui.actor.ArgBox;
import convex.gui.actor.ParamLabel;
import convex.gui.components.BaseListComponent;
import convex.gui.components.CodeLabel;
import convex.gui.components.Toast;
import convex.gui.components.account.AccountChooserPanel;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartOpComponent
extends BaseListComponent {
    protected ActorInvokePanel parent;
    protected Symbol sym;
    int paramCount;
    private HashMap<Integer, JTextField> paramFields = new HashMap();
    private static final Logger log = LoggerFactory.getLogger((String)SmartOpComponent.class.getName());

    public SmartOpComponent(ActorInvokePanel parent, Address contract, Symbol sym) {
        this.parent = parent;
        this.sym = sym;
        this.setFont(Toolkit.MONO_FONT);
        this.setLayout(new BorderLayout(0, 0));
        CodeLabel opName = new CodeLabel(sym.toString());
        opName.setFont(Toolkit.MONO_FONT);
        this.add((Component)opName, "North");
        JPanel paramPanel = new JPanel();
        paramPanel.setLayout((LayoutManager)new MigLayout("wrap 3", "[200][300,fill][400]", ""));
        AccountStatus as = parent.getLatestState().getAccount(contract);
        AFn fn = as.getCallableFunction(sym);
        AVector params = fn instanceof Fn ? ((Fn)fn).getParams() : Vectors.of((Object[])new Object[]{Symbols.FOO});
        this.paramCount = params.size();
        for (int i = 0; i < this.paramCount; ++i) {
            ACell paramSym = params.get(i);
            paramPanel.add(new ParamLabel(RT.str((ACell)paramSym).toString()));
            ArgBox argBox = new ArgBox();
            paramPanel.add(argBox);
            this.paramFields.put(i, argBox);
            paramPanel.add(new JLabel(""));
        }
        paramPanel.add(new ParamLabel("*offer*"));
        ArgBox offerBox = new ArgBox();
        this.paramFields.put(null, offerBox);
        paramPanel.add(offerBox);
        paramPanel.add(new JLabel("Offer amount (0 or blank for no offer)"));
        this.add((Component)paramPanel, "Center");
        JPanel actionPanel = new JPanel();
        actionPanel.setLayout(new FlowLayout(0));
        JButton execButton = new JButton("Execute...");
        actionPanel.add(execButton);
        execButton.addActionListener(e -> this.execute());
        this.add((Component)actionPanel, "South");
    }

    private void execute() {
        AVector args = Vectors.empty();
        for (int i = 0; i < this.paramCount; ++i) {
            JTextField argBox = this.paramFields.get(i);
            String s = argBox.getText();
            ACell arg = s.isBlank() ? null : Reader.read((String)s);
            args = args.conj(arg);
        }
        String offerString = this.paramFields.get(null).getText();
        Long offer = offerString.isBlank() ? null : Long.valueOf(Long.parseLong(offerString.trim()));
        AList rest = Lists.of((Object[])new Object[]{Lists.create((List)args).cons((ACell)this.sym)});
        if (offer != null) {
            rest = rest.cons(RT.cvm((Object)offer));
        }
        try {
            AList message = RT.cons((ACell)Symbols.CALL, (ACell)this.parent.contract, (ACell)rest);
            AccountChooserPanel execPanel = this.parent.execPanel;
            Convex peerConnection = execPanel.getConvex();
            Address myAddress = peerConnection.getAddress();
            String mode = execPanel.getMode();
            Result r = null;
            if (mode.equals("Query")) {
                r = peerConnection.querySync((ACell)message);
            } else if (mode.equals("Transact")) {
                Invoke trans = Invoke.create((Address)myAddress, (long)-1L, (ACell)message);
                r = peerConnection.transactSync((ACell)trans);
            } else {
                throw new Error("Unexpected mode: " + mode);
            }
            if (r.isError()) {
                this.showError(r.getErrorCode(), r.getValue());
            } else {
                this.showResult(r.getValue());
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage());
            Toast.display((JComponent)this.parent, "Unexpected Error: " + e.getMessage(), Toast.FAIL);
        }
    }

    private void showError(Object code, Object msg) {
        String resultString = "Error executing transaction: " + String.valueOf(code) + " " + String.valueOf(msg);
        log.info(resultString);
        Toast.display((JComponent)this.parent, resultString, Toast.FAIL);
    }

    private void showResult(Object v) {
        String resultString = "Transaction executed successfully";
        log.info(resultString);
        Toast.display((JComponent)this.parent, resultString, Toast.SUCCESS);
    }
}

