/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.wallet;

import convex.api.Convex;
import convex.core.data.ACell;
import convex.core.data.prim.AInteger;
import convex.core.lang.RT;
import convex.gui.components.BalanceLabel;
import convex.gui.wallet.TokenInfo;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class TokenInfoPanel
extends JPanel {
    public TokenInfoPanel(Convex convex, TokenInfo token) {
        this.setLayout((LayoutManager)new MigLayout("wrap 2"));
        this.add(new JLabel("Symbol: "));
        this.add((Component)new JLabel(token.getSymbol()), "wrap");
        this.add(new JLabel("ID: "));
        ACell id = token.getID();
        String idString = RT.toString((ACell)id);
        this.add((Component)new JLabel(idString), "wrap");
        this.add(new JLabel("Actor Name: "));
        JLabel descLabel = new JLabel("Loading...");
        this.add((Component)descLabel, "wrap");
        this.add(new JLabel("Total Supply: "));
        BalanceLabel supplyLabel = new BalanceLabel();
        supplyLabel.setDecimals(0);
        supplyLabel.setAlignmentX(0.0f);
        this.add((Component)supplyLabel, "wrap");
        this.add(new JLabel("Decimals: "));
        JLabel decimalsLabel = new JLabel("Loading...");
        this.add((Component)decimalsLabel, "wrap");
        if (id == null) {
            descLabel.setText("(Convex Gold: Native coin)");
            supplyLabel.setDecimals(9);
            decimalsLabel.setText(Integer.toString(9));
            convex.query("(coin-supply)").thenAcceptAsync(r -> {
                if (r.isError()) {
                    supplyLabel.setBalance(null);
                } else {
                    supplyLabel.setBalance(RT.ensureInteger((ACell)r.getValue()));
                }
            });
        } else {
            convex.query("(get (call *registry* (lookup (address " + String.valueOf(id) + "))) :name)").thenAcceptAsync(r -> {
                if (r.isError()) {
                    descLabel.setText(r.getErrorCode().toString());
                } else {
                    descLabel.setText(RT.toString((ACell)r.getValue()));
                }
            });
            convex.query("(@convex.asset/total-supply " + String.valueOf(id) + ")").thenAcceptAsync(r -> {
                if (r.isError()) {
                    supplyLabel.setBalance(null);
                } else {
                    supplyLabel.setBalance(RT.ensureInteger((ACell)r.getValue()));
                }
            });
            convex.query("(@convex.fungible/decimals " + String.valueOf(id) + ")").thenAcceptAsync(r -> {
                if (r.isError()) {
                    decimalsLabel.setText("Error - " + String.valueOf(r.getErrorCode()));
                    supplyLabel.setDecimals(0);
                } else {
                    AInteger decs = RT.ensureInteger((ACell)r.getValue());
                    supplyLabel.setDecimals((int)decs.longValue());
                    decimalsLabel.setText(RT.toString((ACell)decs));
                }
            });
        }
    }
}

