/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.utils;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.intellijthemes.materialthemeuilite.FlatMaterialOceanicIJTheme;
import com.formdev.flatlaf.util.SystemInfo;
import convex.core.util.Utils;
import convex.gui.utils.SymbolIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Toolkit {
    private static Logger log = LoggerFactory.getLogger((String)Toolkit.class.getName());
    public static final double BASE_SCALE = 1.25;
    public static final float SCALE = Toolkit.getUIScale();
    public static final int ICON_SIZE = (int)(32.0f * SCALE);
    public static final int IDENTICON_SIZE = (int)(14.0f * SCALE);
    public static final int IDENTICON_SIZE_LARGE = 2 * IDENTICON_SIZE;
    public static final int SMALL_ICON_SIZE = (int)(16.0f * SCALE);
    public static final int MAIN_ICON_SIZE = (int)(72.0f * SCALE);
    public static final float DEFAULT_FONT_SIZE = 12.0f * SCALE;
    public static Font DEFAULT_FONT = new Font("SansSerif", 0, (int)DEFAULT_FONT_SIZE);
    public static Font BIG_FONT = new Font("SansSerif", 1, (int)((double)DEFAULT_FONT_SIZE * 1.8));
    public static Font MONO_FONT = new Font("Monospaced", 0, (int)DEFAULT_FONT_SIZE);
    public static Font BIG_MONO_FONT = new Font("Monospaced", 1, (int)((double)DEFAULT_FONT_SIZE * 1.5));
    public static Font SMALL_MONO_FONT = new Font("Monospaced", 0, (int)((double)DEFAULT_FONT_SIZE * 0.8));
    public static Font BUTTON_FONT = new Font("SansSerif", 0, (int)((double)DEFAULT_FONT_SIZE * 1.2));
    public static final float SYMBOL_FONT_SIZE = DEFAULT_FONT_SIZE;
    public static Font SYMBOL_FONT = new Font("Monospaced", 0, (int)SYMBOL_FONT_SIZE);
    public static final Color SYMBOL_COLOUR = new Color(100, 170, 200);
    public static final Color WARNING_COLOUR = Color.ORANGE;
    public static final Color BUTTON_FG = new Color(176, 190, 197);
    public static final ImageIcon LOCKED_ICON;
    public static final ImageIcon UNLOCKED_ICON;
    public static final ImageIcon WARNING;
    public static final ImageIcon CAKE;
    public static final ImageIcon CONVEX;
    public static final ImageIcon COG;
    public static final ImageIcon REPL_ICON;
    public static final ImageIcon TESTNET_ICON;
    public static final ImageIcon WWW_ICON;
    public static final ImageIcon HACKER_ICON;
    public static final ImageIcon TERMINAL_ICON;
    public static final ImageIcon ECOSYSTEM_ICON;
    public static final ImageIcon WALLET_ICON;
    public static final ImageIcon DLFS_ICON;

    protected static void setupForApple() {
        System.setProperty("apple.awt.application.name", "Convex");
        System.setProperty("apple.awt.application.appearance", "system");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
    }

    protected static LookAndFeel installFlatLaf() {
        FlatDarculaLaf laf = new FlatDarculaLaf();
        return laf;
    }

    private static float getUIScale() {
        try {
            Double scale = 1.25;
            System.setProperty("flatlaf.uiScale", "" + scale);
            log.info("UI Scale: " + scale);
            return (float)scale.doubleValue();
        }
        catch (HeadlessException e) {
            return 1.0f;
        }
    }

    public static ImageIcon scaledIcon(int size, String resourcePath) {
        URL imgURL = Toolkit.class.getResource(resourcePath);
        if (imgURL == null) {
            throw new Error("No image: " + resourcePath);
        }
        ImageIcon imageIcon = new ImageIcon(imgURL);
        Image image = imageIcon.getImage();
        image = image.getScaledInstance(size, size, 4);
        return new ImageIcon(image);
    }

    private static void loadFonts() {
        try {
            InputStream is = Utils.getResourceAsStream((String)"/fonts/SourceCodePro-Regular.ttf");
            MONO_FONT = Font.createFont(0, is).deriveFont(DEFAULT_FONT_SIZE);
            is = Utils.getResourceAsStream((String)"/fonts/MaterialSymbolsSharp.ttf");
            SYMBOL_FONT = Font.createFont(0, is).deriveFont(SYMBOL_FONT_SIZE);
            DEFAULT_FONT = DEFAULT_FONT.deriveFont(DEFAULT_FONT_SIZE).deriveFont(0);
        }
        catch (Exception e) {
            System.err.println("PROBLEM LOADING FONTS:");
            e.printStackTrace();
        }
    }

    public static BufferedImage smoothResize(BufferedImage src, int w, int h) {
        BufferedImage newImage = new BufferedImage(w, h, 2);
        Graphics2D graphics = (Graphics2D)newImage.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics.drawImage(src, 0, 0, w, h, null);
        return newImage;
    }

    public static BufferedImage pixelResize(BufferedImage src, int w, int h) {
        BufferedImage newImage = new BufferedImage(w, h, 2);
        Graphics2D graphics = (Graphics2D)newImage.getGraphics();
        graphics.drawImage(src, 0, 0, w, h, null);
        return newImage;
    }

    public static DocumentListener createDocumentListener(final Runnable a) {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(a);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(a);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(a);
            }
        };
    }

    public static void init() {
    }

    public static Image getImage(URL resourceURL) {
        return Toolkit.getDefaultToolkit().getImage(resourceURL);
    }

    public static java.awt.Toolkit getDefaultToolkit() {
        return java.awt.Toolkit.getDefaultToolkit();
    }

    public static void launchBrowser(String url) {
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(new URI(url));
            }
        }
        catch (IOException | URISyntaxException ex) {
            log.warn("IO Failure launching browser: " + String.valueOf(ex));
        }
    }

    public static void showMainFrame(JComponent comp) {
        JFrame frame = new JFrame("Test Frame");
        frame.getContentPane().add(comp);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public static void relinquishFocus(Component c) {
        if (c.isFocusable()) {
            c.setFocusable(false);
            c.setFocusable(true);
        }
    }

    public static JMenuItem makeMenu(String name, Runnable op) {
        AbstractAction action = Toolkit.makeAction(name, op);
        JMenuItem mi = new JMenuItem(action);
        return mi;
    }

    public static AbstractAction makeAction(String name, final Runnable op) {
        return new AbstractAction(name){

            @Override
            public void actionPerformed(ActionEvent e) {
                op.run();
            }
        };
    }

    public static void addPopupMenu(JComponent comp, final JPopupMenu popupMenu) {
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeDisplayPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeDisplayPopupMenu(e);
            }

            private void maybeDisplayPopupMenu(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public static Border createDialogBorder() {
        return Toolkit.createEmptyBorder(20);
    }

    public static Border createEmptyBorder(int x) {
        return BorderFactory.createEmptyBorder(x, x, x, x);
    }

    public static JComponent makeHelp(final String helpText) {
        final JLabel help = new JLabel(SymbolIcon.get(59527, SMALL_ICON_SIZE));
        help.setToolTipText(helpText);
        help.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JOptionPane.showMessageDialog(help, helpText, "Help Tips", 1);
            }
        });
        return help;
    }

    public static JComponent makeNote(String title, String note) {
        JTextArea ta = new JTextArea(note);
        ta.setMinimumSize(new Dimension(50, 50));
        ta.setEditable(false);
        ta.setFocusable(false);
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        return Toolkit.withTitledBorder(title, ta);
    }

    public static JComponent makeNote(String note) {
        return Toolkit.makeNote("NOTE", note);
    }

    public static void copyToClipboard(String string) {
        if (string == null) {
            return;
        }
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection text = new StringSelection(string);
        c.setContents(text, text);
    }

    public static JComponent withTitledBorder(String title, JComponent comp) {
        Border existingBorder = comp.getBorder();
        AbstractBorder border = BorderFactory.createTitledBorder(title);
        if (existingBorder != null) {
            border = BorderFactory.createCompoundBorder(border, existingBorder);
        }
        comp.setBorder(border);
        return comp;
    }

    public static Icon menuIcon(int codePoint) {
        return SymbolIcon.get(codePoint, BUTTON_FONT.getSize());
    }

    public static <E> void scrollToBottom(JScrollPane scrollPane) {
        JScrollBar bar = scrollPane.getVerticalScrollBar();
        bar.setValue(bar.getMaximum());
    }

    public static void showMessge(Component parent, Object message) {
        JOptionPane.showMessageDialog(parent, message);
    }

    public static void showErrorMessage(Component parent, String attemptFailure, Exception e) {
        JOptionPane.showMessageDialog(parent, attemptFailure + "\n" + e.getMessage());
    }

    public static Component wrapPasswordField(final JPasswordField passArea) {
        final char ec = passArea.getEchoChar();
        JPanel panel = new JPanel();
        final JLabel eye = new JLabel(SymbolIcon.get(59636));
        eye.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                char c = passArea.getEchoChar();
                if (c == '\u0000') {
                    eye.setIcon(SymbolIcon.get(59636));
                    passArea.setEchoChar(ec);
                } else {
                    eye.setIcon(SymbolIcon.get(59637));
                    passArea.setEchoChar('\u0000');
                }
            }
        });
        panel.setBorder(null);
        panel.setLayout((LayoutManager)new MigLayout());
        panel.add((Component)passArea, "dock center");
        panel.add((Component)eye, "dock east");
        return panel;
    }

    public static JFileChooser createCAD3Chooser(String fileName) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(Toolkit.getCAD3Filter());
        if (fileName != null) {
            Path p = Path.of(fileName, new String[0]);
            Path dir = chooser.getCurrentDirectory().toPath();
            Path defaultFile = dir.resolve(p);
            chooser.setSelectedFile(defaultFile.toFile());
        }
        return chooser;
    }

    public static FileFilter getCAD3Filter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String filename = f.getName().toLowerCase();
                return filename.endsWith(".cad3") || filename.endsWith(".cad");
            }

            @Override
            public String getDescription() {
                return "CAD3 file (*.cad3, *.cad)";
            }
        };
    }

    static {
        try {
            if (SystemInfo.isMacOS) {
                Toolkit.setupForApple();
            }
            Toolkit.loadFonts();
            UIManager.getLookAndFeelDefaults().put("defaultFont", DEFAULT_FONT);
            LookAndFeel laf = Toolkit.installFlatLaf();
            if (System.getProperty("os.name").toLowerCase().startsWith("mac")) {
                InputMap im = (InputMap)UIManager.get("TextField.focusInputMap");
                im.put(KeyStroke.getKeyStroke(67, 256), "copy-to-clipboard");
                im.put(KeyStroke.getKeyStroke(86, 256), "paste-from-clipboard");
                im.put(KeyStroke.getKeyStroke(88, 256), "cut-to-clipboard");
            }
            UIManager.setLookAndFeel(laf);
            FlatMaterialOceanicIJTheme.setup();
            UIManager.put("Button.foreground", UIManager.get("Label.foreground"));
        }
        catch (HeadlessException e) {
            log.warn("Unable to initialise GUI Toolkit due to headless execution mode.");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("Unable to set look and feel: {}", (Throwable)e);
        }
        LOCKED_ICON = SymbolIcon.get(59543, ICON_SIZE, SYMBOL_COLOUR.getRGB());
        UNLOCKED_ICON = SymbolIcon.get(59544, ICON_SIZE, WARNING_COLOUR.getRGB());
        WARNING = Toolkit.scaledIcon(ICON_SIZE, "/images/ic_priority_high_black_36dp.png");
        CAKE = Toolkit.scaledIcon(ICON_SIZE, "/images/ic_cake_black_36dp.png");
        CONVEX = Toolkit.scaledIcon(ICON_SIZE, "/images/Convex.png");
        COG = Toolkit.scaledIcon(ICON_SIZE, "/images/cog.png");
        REPL_ICON = Toolkit.scaledIcon(ICON_SIZE, "/images/terminal-icon.png");
        TESTNET_ICON = Toolkit.scaledIcon(MAIN_ICON_SIZE, "/images/testnet.png");
        WWW_ICON = Toolkit.scaledIcon(MAIN_ICON_SIZE, "/images/www.png");
        HACKER_ICON = Toolkit.scaledIcon(MAIN_ICON_SIZE, "/images/hacker.png");
        TERMINAL_ICON = Toolkit.scaledIcon(MAIN_ICON_SIZE, "/images/terminal.png");
        ECOSYSTEM_ICON = Toolkit.scaledIcon(MAIN_ICON_SIZE, "/images/ecosystem.png");
        WALLET_ICON = Toolkit.scaledIcon(MAIN_ICON_SIZE, "/images/wallet.png");
        DLFS_ICON = Toolkit.scaledIcon(MAIN_ICON_SIZE, "/images/filesystem.png");
    }
}

