/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.utils;

import convex.gui.utils.Toolkit;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class SymbolIcon
extends ImageIcon {
    private static WeakHashMap<Long, SymbolIcon> cache = new WeakHashMap();

    public SymbolIcon(BufferedImage image) {
        super(image);
    }

    private static SymbolIcon create(int codePoint, double dsize, int colour) {
        int size = (int)dsize;
        BufferedImage image = new BufferedImage(size, size, 2);
        char[] c = Character.toChars(codePoint);
        String s = new String(c);
        JLabel label = new JLabel(s);
        label.setForeground(new Color(colour & 0xFFFFFF));
        Font font = Toolkit.SYMBOL_FONT.deriveFont((float)size);
        label.setFont(font);
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setSize(size, size);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        label.print(g);
        return new SymbolIcon(image);
    }

    public static SymbolIcon get(int codePoint) {
        return SymbolIcon.get(codePoint, Toolkit.SMALL_ICON_SIZE, Toolkit.SYMBOL_COLOUR.getRGB());
    }

    public static SymbolIcon get(int codePoint, double size) {
        return SymbolIcon.get(codePoint, size, Toolkit.SYMBOL_COLOUR.getRGB());
    }

    public static SymbolIcon get(int codePoint, double size, int colour) {
        int sz = (int)size;
        long id = (long)codePoint + (long)sz * 0x100000000L + (long)colour * 100000000000L;
        SymbolIcon result = cache.get(id);
        if (result != null) {
            return result;
        }
        result = SymbolIcon.create(codePoint, size, colour);
        cache.put(id, result);
        return result;
    }
}

