/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.server;

import convex.api.Convex;
import convex.api.ConvexLocal;
import convex.gui.components.AbstractGUI;
import convex.gui.peer.PeerComponent;
import convex.gui.repl.REPLPanel;
import convex.gui.server.ObserverPanel;
import convex.gui.server.PeerInfoPanel;
import convex.gui.server.StressPanel;
import convex.peer.Server;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerWindow
extends AbstractGUI {
    ConvexLocal peer;
    private static final Logger log = LoggerFactory.getLogger((String)PeerWindow.class.getName());
    JTabbedPane tabbedPane = new JTabbedPane(1);

    public Convex getPeerView() {
        return this.peer;
    }

    public PeerWindow(ConvexLocal convex) {
        super("Peer Control Panel - " + convex.toString());
        this.peer = convex;
        this.setPreferredSize(new Dimension(1200, 1000));
        this.setLayout((LayoutManager)new MigLayout());
        this.add((Component)this.tabbedPane, "dock center");
        Server server = convex.getLocalServer();
        if (server != null) {
            try {
                this.tabbedPane.addTab("REPL", null, new REPLPanel((Convex)convex), null);
            }
            catch (Exception t) {
                String msg = "Failed to connect to Peer: " + String.valueOf(t);
                t.printStackTrace();
                log.warn(msg);
                this.tabbedPane.addTab("REPL Error", null, new JLabel(msg), null);
                throw t;
            }
            this.tabbedPane.addTab("Observation", null, new JScrollPane(new ObserverPanel(server)), null);
        }
        this.tabbedPane.addTab("Stress", null, new StressPanel((Convex)convex), null);
        this.tabbedPane.addTab("Info", null, new PeerInfoPanel((Convex)convex), null);
        PeerComponent pcom = new PeerComponent(convex);
        this.add((Component)pcom, "dock north");
    }

    @Override
    public void setupFrame(JFrame frame) {
        frame.getContentPane().setLayout((LayoutManager)new MigLayout());
        frame.getContentPane().add((Component)this, "dock center");
    }
}

