/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.repl;

import convex.api.Convex;
import convex.core.Result;
import convex.core.crypto.AKeyPair;
import convex.core.cvm.Address;
import convex.core.cvm.Symbols;
import convex.core.data.ACell;
import convex.core.data.AList;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.SignedData;
import convex.core.exceptions.ParseException;
import convex.core.exceptions.ResultException;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.util.Utils;
import convex.gui.components.ActionButton;
import convex.gui.components.ActionPanel;
import convex.gui.components.BaseTextPane;
import convex.gui.components.CodePane;
import convex.gui.components.ConnectPanel;
import convex.gui.components.account.AccountChooserPanel;
import convex.gui.utils.CVXHighlighter;
import convex.gui.utils.Toolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeoutException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class REPLPanel
extends JPanel {
    protected final CodePane input;
    protected final CodePane output;
    protected final JScrollPane inputScrollPane;
    protected final JScrollPane outputScrollPane;
    private final JButton btnRun;
    private final JButton btnClear;
    private final JButton btnInfo;
    private final JCheckBox btnResults;
    private final JCheckBox btnTiming;
    private final JCheckBox btnCompile;
    private final JCheckBox btnTX;
    private final ArrayList<String> history = new ArrayList();
    private int historyPosition = 0;
    private InputListener inputListener = new InputListener();
    private Font OUTPUT_FONT = Toolkit.MONO_FONT.deriveFont(16.0f * Toolkit.SCALE);
    private Font INPUT_FONT = Toolkit.MONO_FONT.deriveFont(20.0f * Toolkit.SCALE);
    private Color DEFAULT_OUTPUT_COLOR = Color.LIGHT_GRAY;
    private JPanel actionPanel;
    private AccountChooserPanel execPanel;
    private final Convex convex;
    private JSplitPane splitPane;
    private static final Logger log = LoggerFactory.getLogger((String)REPLPanel.class.getName());
    boolean highlighting = false;

    public void setInput(String s) {
        this.input.setText(s);
        this.updateHighlight();
    }

    @Override
    public void setVisible(boolean value) {
        super.setVisible(value);
        if (value) {
            this.input.requestFocusInWindow();
        }
    }

    protected void handleResult(long start, Result r) {
        if (this.btnTiming.isSelected()) {
            this.output.append("Completion time: " + (Utils.getCurrentTimestamp() - start) + " ms\n");
        }
        if (r == null) {
            this.output.append(" No result??\n", Color.ORANGE);
            return;
        }
        if (this.btnResults.isSelected()) {
            this.showResultValue((ACell)r);
        } else if (r.isError()) {
            this.handleError(r.getErrorCode(), r.getValue(), (AVector<AString>)r.getTrace());
        } else {
            this.showResultValue(r.getValue());
        }
        this.execPanel.updateBalance();
    }

    protected void showResultValue(ACell m) {
        AString s = RT.print((ACell)m);
        String resultString = s == null ? "Print limit exceeded!" : s.toString();
        this.output.append("=> ", Color.CYAN);
        int start = this.output.docLength();
        this.output.append(resultString + "\n");
        int end = this.output.docLength();
        this.updateHighlight(this.output, start, end);
        this.output.setCaretPosition(end);
    }

    protected void handleError(ACell code, ACell msg, AVector<AString> trace) {
        this.output.append(" Exception: " + String.valueOf(code) + " " + String.valueOf(msg) + "\n", Color.ORANGE);
        if (trace != null) {
            for (AString s : trace) {
                this.output.append(" - " + s.toString() + "\n", Color.PINK);
            }
        }
    }

    private void addOutputWithHighlight(BaseTextPane pane, String text) {
        Document d = pane.getDocument();
        int start = d.getLength();
        pane.append(text, this.DEFAULT_OUTPUT_COLOR);
        int end = d.getLength();
        if (end > start) {
            this.updateHighlight(pane, start, end);
        }
    }

    public REPLPanel(Convex convex) {
        this.convex = convex;
        this.execPanel = new AccountChooserPanel(convex);
        this.setLayout((LayoutManager)new MigLayout());
        this.add((Component)this.execPanel, "dock north");
        this.splitPane = new JSplitPane(0);
        this.splitPane.setResizeWeight(0.7);
        this.splitPane.setOneTouchExpandable(true);
        this.add((Component)this.splitPane, "dock center");
        this.output = new CodePane();
        this.output.setEditable(false);
        this.output.setFont(this.OUTPUT_FONT);
        this.output.setBackground(new Color(10, 10, 10));
        this.output.setToolTipText("Output from transaction execution");
        this.outputScrollPane = this.wrapScrollPane(this.output);
        this.splitPane.setLeftComponent(this.outputScrollPane);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout((LayoutManager)new MigLayout());
        this.input = new CodePane();
        this.input.setFont(this.INPUT_FONT);
        this.input.getDocument().addDocumentListener(this.inputListener);
        this.input.addKeyListener(this.inputListener);
        this.input.setToolTipText("Input commands here (Press Enter at the end of input to send)");
        this.inputScrollPane = this.wrapScrollPane(this.input);
        inputPanel.add((Component)this.inputScrollPane, "dock center");
        JPanel historyPanel = new JPanel();
        historyPanel.setLayout((LayoutManager)new MigLayout("wrap 1,aligny center"));
        historyPanel.add(ActionButton.build(58134, e -> this.scrollHistory(-1), "Previous command in history"));
        historyPanel.add(ActionButton.build(58131, e -> this.scrollHistory(1), "Next command in history"));
        inputPanel.add((Component)historyPanel, "dock east");
        this.splitPane.setRightComponent(inputPanel);
        this.setFocusTraversalKeysEnabled(false);
        this.actionPanel = new ActionPanel();
        this.add((Component)this.actionPanel, "dock south");
        this.btnRun = new ActionButton("Run", 57796, e -> {
            this.sendMessage(this.input.getText());
            this.input.requestFocus();
        });
        this.btnRun.setToolTipText("Run the current command from the input pane");
        this.actionPanel.add(this.btnRun);
        this.btnClear = new ActionButton("Clear", 59861, e -> {
            this.output.setText("");
            this.input.setText("");
            this.input.requestFocus();
        });
        this.btnClear.setToolTipText("Clear the input and output");
        this.actionPanel.add(this.btnClear);
        this.btnInfo = new ActionButton("Connection Info", 59534, e -> ConnectPanel.showConnectionInfo(this, convex));
        this.btnInfo.setToolTipText("Show diagnostic information for the Convex connection");
        this.actionPanel.add(this.btnInfo);
        this.btnTX = new JCheckBox("Show transaction");
        this.btnTX.setToolTipText("Tick to show details of the transaction sent, including signature and transaction hash.");
        this.actionPanel.add(this.btnTX);
        this.btnResults = new JCheckBox("Full Results");
        this.btnResults.setToolTipText("Tick to show full Result record returned from peer.");
        this.actionPanel.add(this.btnResults);
        this.btnTiming = new JCheckBox("Show Timing");
        this.btnTiming.setToolTipText("Tick to receive execution time report after each transaction.");
        this.actionPanel.add(this.btnTiming);
        this.btnCompile = new JCheckBox("Precompile");
        this.btnCompile.setToolTipText("Tick to compile code before sending transaction. Usually reduces juice costs at the cost of slightly slower execution time.");
        this.btnCompile.setSelected(convex.isPreCompile());
        this.actionPanel.add(this.btnCompile);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                REPLPanel.this.input.requestFocusInWindow();
            }
        });
    }

    private JScrollPane wrapScrollPane(CodePane codePane) {
        JScrollPane scrollPane = new JScrollPane(codePane);
        return scrollPane;
    }

    protected AKeyPair getKeyPair() {
        return this.execPanel.getConvex().getKeyPair();
    }

    protected Address getAddress() {
        return this.execPanel.getConvex().getAddress();
    }

    private void sendMessage(String s) {
        if (s.isBlank()) {
            return;
        }
        this.output.append(s);
        this.output.append("\n");
        this.input.setText("");
        this.history.add(s);
        this.historyPosition = this.history.size();
        SwingUtilities.invokeLater(() -> {
            this.input.setText("");
            long start = Utils.getCurrentTimestamp();
            try {
                CompletionStage future;
                AList forms = Reader.readAll((String)s);
                ACell code = forms.count() == 1L ? forms.get(0) : forms.cons((ACell)Symbols.DO);
                this.convex.setPreCompile(this.btnCompile.isSelected());
                String mode = this.execPanel.getMode();
                if (mode.equals("Query")) {
                    Address qaddr = this.getAddress();
                    future = this.convex.query(code, qaddr);
                } else if (mode.equals("Transact")) {
                    future = CompletableFuture.supplyAsync(() -> {
                        try {
                            SignedData strans = this.convex.prepareTransaction(code);
                            if (this.btnTX.isSelected()) {
                                this.addOutputWithHighlight(this.output, strans.toString() + "\n");
                                this.output.append("TX Hash: " + String.valueOf(strans.getHash()) + "\n");
                            }
                            return strans;
                        }
                        catch (Exception e) {
                            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
                        }
                    }).thenCompose(strans -> this.convex.transact(strans));
                } else {
                    if (mode.equals("Prepare")) {
                        SignedData strans2 = this.convex.prepareTransaction(code);
                        this.convex.clearSequence();
                        this.addOutputWithHighlight(this.output, strans2.toString() + "\n");
                        return;
                    }
                    throw new Exception("Unrecognosed REPL mode: " + mode);
                }
                log.trace("Sent message");
                ((CompletableFuture)future).handleAsync((m, e) -> {
                    if (e != null) {
                        e.printStackTrace();
                        m = Result.fromException((Throwable)e);
                    }
                    this.handleResult(start, (Result)m);
                    Toolkit.scrollToBottom(this.outputScrollPane);
                    return m;
                });
            }
            catch (ResultException e2) {
                this.handleResult(start, e2.getResult());
            }
            catch (ParseException e3) {
                this.output.append(" PARSE ERROR: " + e3.getMessage() + "\n", Color.RED);
            }
            catch (TimeoutException t) {
                this.output.append(" TIMEOUT waiting for result\n", Color.RED);
            }
            catch (IllegalStateException t) {
                this.output.append(" EXCEPTION: ", Color.RED);
                this.output.append(t.getMessage() + "\n");
            }
            catch (Exception t) {
                this.output.append(" ERROR: ", Color.RED);
                this.output.append(t.getMessage() + "\n");
                t.printStackTrace();
            }
        });
    }

    protected void updateHighlight() {
        int len = this.input.getDocument().getLength();
        if (!this.highlighting) {
            this.highlighting = true;
            this.updateHighlight(this.input, 0, len);
        }
    }

    protected void updateHighlight(BaseTextPane pane, int start, int end) {
        SwingUtilities.invokeLater(() -> {
            CVXHighlighter.highlight(pane, start, end);
            this.highlighting = false;
        });
    }

    public void scrollHistory(int scroll) {
        int hSize = this.history.size();
        if (scroll < 0) {
            if (this.historyPosition > 0) {
                if (this.historyPosition == hSize) {
                    String s = this.input.getText();
                    this.history.add(s);
                }
                this.historyPosition = Math.max(0, this.historyPosition + scroll);
                this.setInput(this.history.get(this.historyPosition));
            }
        } else if (scroll > 0 && this.historyPosition < hSize - 1) {
            this.historyPosition = Math.min(hSize - 1, this.historyPosition + scroll);
            this.setInput(this.history.get(this.historyPosition));
        }
    }

    private class InputListener
    implements DocumentListener,
    KeyListener {
        private InputListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            REPLPanel.this.updateHighlight();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            REPLPanel.this.updateHighlight();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            REPLPanel.this.updateHighlight();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            if (e.isControlDown() || e.isShiftDown()) {
                if (code == 38) {
                    REPLPanel.this.scrollHistory(-1);
                    e.consume();
                } else if (code == 40) {
                    REPLPanel.this.scrollHistory(1);
                    e.consume();
                }
            }
            if (code == 10) {
                try {
                    Document doc = REPLPanel.this.input.getDocument();
                    int docLen = doc.getLength();
                    if (e.isControlDown() || e.isShiftDown()) {
                        doc.insertString(docLen, "\n", SimpleAttributeSet.EMPTY);
                    } else {
                        int off = REPLPanel.this.input.getCaretPosition();
                        if (off == docLen) {
                            String s = doc.getText(0, docLen);
                            REPLPanel.this.sendMessage(s.trim());
                        }
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

